/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.util;

import co.paralleluniverse.concurrent.util.AbstractCompletableExecutorService;
import co.paralleluniverse.concurrent.util.CompletableExecutorService;
import co.paralleluniverse.concurrent.util.CompletableScheduledExecutorService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class CompletableExecutors {
    public static CompletableExecutorService completableDecorator(ExecutorService delegate) {
        return delegate instanceof CompletableExecutorService ? (CompletableExecutorService)delegate : (delegate instanceof ScheduledExecutorService ? new ScheduledCompletableDecorator((ScheduledExecutorService)delegate) : new CompletableDecorator(delegate));
    }

    public static CompletableScheduledExecutorService completableDecorator(ScheduledExecutorService delegate) {
        return delegate instanceof CompletableScheduledExecutorService ? (CompletableScheduledExecutorService)delegate : new ScheduledCompletableDecorator(delegate);
    }

    private CompletableExecutors() {
    }

    private static class ScheduledCompletableDecorator
    extends CompletableDecorator
    implements CompletableScheduledExecutorService {
        ScheduledCompletableDecorator(ScheduledExecutorService delegate) {
            super(delegate);
        }

        @Override
        ScheduledExecutorService delegate() {
            return this.delegate();
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.delegate().schedule(command, delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.delegate().schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.delegate().scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.delegate().scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }

    private static class CompletableDecorator
    extends AbstractCompletableExecutorService {
        final ExecutorService delegate;

        CompletableDecorator(ExecutorService delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }

        ExecutorService delegate() {
            return this.delegate;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        @Override
        public void execute(Runnable command) {
            this.delegate.execute(command);
        }
    }
}

