/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.channels;

import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.channels.SendPort;
import java.util.concurrent.TimeUnit;

public class ThreadSendPort<Message> {
    private final SendPort<Message> p;

    public ThreadSendPort(SendPort<Message> p) {
        this.p = p;
    }

    public void send(Message message) throws InterruptedException {
        if (Strand.isCurrentFiber()) {
            throw new IllegalStateException("This method cannot be called on a fiber");
        }
        try {
            this.p.send(message);
        }
        catch (SuspendExecution e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean send(Message message, long timeout, TimeUnit unit) throws InterruptedException {
        if (Strand.isCurrentFiber()) {
            throw new IllegalStateException("This method cannot be called on a fiber");
        }
        try {
            return this.p.send(message, timeout, unit);
        }
        catch (SuspendExecution e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean trySend(Message message) {
        return this.p.trySend(message);
    }

    public void close() {
        this.p.close();
    }

    public final int hashCode() {
        return this.p.hashCode();
    }

    public final boolean equals(Object obj) {
        return this.p.equals(obj);
    }

    public final String toString() {
        return this.p.toString();
    }
}

