/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.channels;

import co.paralleluniverse.common.util.Function2;
import co.paralleluniverse.fibers.FiberFactory;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.strands.SuspendableAction2;
import co.paralleluniverse.strands.channels.Channel;
import co.paralleluniverse.strands.channels.Channels;
import co.paralleluniverse.strands.channels.DelegatingSendPort;
import co.paralleluniverse.strands.channels.ReceivePort;
import co.paralleluniverse.strands.channels.SendPort;
import com.google.common.base.Function;
import com.google.common.base.Predicate;

@Instrumented
public class TransformingSendPort<T>
extends DelegatingSendPort<T> {
    TransformingSendPort(SendPort<T> target) {
        super(target);
    }

    public TransformingSendPort<T> filter(Predicate<T> pred) {
        return Channels.transformSend(Channels.filterSend(this, pred));
    }

    public <S> TransformingSendPort<S> map(Function<S, T> f) {
        return Channels.transformSend(Channels.mapSend(this, f));
    }

    public <S> TransformingSendPort<S> reduce(Function2<T, S, T> f, T init) {
        return Channels.transformSend(Channels.reduceSend(this, f, init));
    }

    public <S> TransformingSendPort<S> flatMap(Channel<S> pipe, Function<S, ReceivePort<T>> f) {
        return Channels.transformSend(Channels.flatMapSend(pipe, this, f));
    }

    public <U> TransformingSendPort<U> fiberTransform(SuspendableAction2<? extends ReceivePort<? super U>, ? extends SendPort<? extends T>> transformer, Channel<U> in) {
        Channels.fiberTransform(in, this, transformer);
        return Channels.transformSend(in);
    }

    public <U> TransformingSendPort<U> fiberTransform(FiberFactory fiberFactory, SuspendableAction2<? extends ReceivePort<? super U>, ? extends SendPort<? extends T>> transformer, Channel<U> in) {
        Channels.fiberTransform(fiberFactory, in, this, transformer);
        return Channels.transformSend(in);
    }
}

