/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.BasicSingleConsumerFloatQueue;
import co.paralleluniverse.strands.queues.FloatQueueIterator;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedArrayQueue;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedArrayWordQueue;

public class SingleConsumerLinkedArrayFloatQueue
extends SingleConsumerLinkedArrayWordQueue<Float>
implements BasicSingleConsumerFloatQueue {
    @Override
    public boolean enq(float element) {
        return this.enqRaw(Float.floatToRawIntBits(element));
    }

    @Override
    public boolean enq(Float element) {
        return this.enq(element.floatValue());
    }

    @Override
    Float value(SingleConsumerLinkedArrayQueue.Node n, int i) {
        return Float.valueOf(this.floatValue(n, i));
    }

    float floatValue(SingleConsumerLinkedArrayQueue.Node n, int i) {
        return Float.intBitsToFloat(this.rawValue(n, i));
    }

    @Override
    public float pollFloat() {
        return Float.intBitsToFloat((int)this.pollRaw());
    }

    @Override
    public FloatQueueIterator iterator() {
        return new FloatLinkedArrayQueueIterator();
    }

    private class FloatLinkedArrayQueueIterator
    extends SingleConsumerLinkedArrayQueue.LinkedArrayQueueIterator
    implements FloatQueueIterator {
        private FloatLinkedArrayQueueIterator() {
            super(SingleConsumerLinkedArrayFloatQueue.this);
        }

        @Override
        public float floatValue() {
            return SingleConsumerLinkedArrayFloatQueue.this.floatValue(this.n, this.i);
        }

        @Override
        public float floatNext() {
            this.preNext();
            return this.floatValue();
        }
    }
}

