/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import co.paralleluniverse.common.monitoring.FlightRecorderMXBean;
import co.paralleluniverse.common.monitoring.SimpleMBean;
import co.paralleluniverse.concurrent.util.MapUtil;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class FlightRecorder
extends SimpleMBean
implements FlightRecorderMXBean {
    private static final int DEFAULT_SIZE = Integer.getInteger("co.paralleluniverse.monitoring.flightRecorderSize", 20000);
    private static final int DEFAULT_LEVEL = Integer.getInteger("co.paralleluniverse.monitoring.flightRecorderLevel", 5);
    private final ConcurrentMap<Thread, ThreadRecorder> recorders = MapUtil.newConcurrentHashMap();
    private final long startWallTime;
    private final long startTimestamp = System.nanoTime();
    private boolean recording = true;
    private Object aux;
    private static final MessageFormat recordFormatter = new MessageFormat("[{0}{1} {2} ({3})]\t");

    public FlightRecorder(String name) {
        super(null, name, "FlightRecorder", null);
        this.startWallTime = System.currentTimeMillis();
        this.registerMBean();
    }

    public void clear() {
        this.recorders.clear();
    }

    public void setAux(Object aux) {
        this.aux = aux;
    }

    public ThreadRecorder init(int size, int level) {
        if (!this.recording) {
            return null;
        }
        ThreadRecorder recorder = (ThreadRecorder)this.recorders.get(Thread.currentThread());
        if (recorder != null) {
            if (recorder.timestamps.length != size) {
                System.err.println("Flight recorder already initialized for thread " + Thread.currentThread() + " with size " + recorder.timestamps.length + ", which is different from the requested size of " + size);
            }
        } else {
            recorder = new ThreadRecorder(size, level, this.aux);
            this.recorders.put(Thread.currentThread(), recorder);
        }
        System.err.println("STARTING FLIGHT RECORDER FOR THREAD " + Thread.currentThread() + " OF SIZE " + size + " AT LEVEL " + level);
        return recorder;
    }

    public ThreadRecorder get() {
        ThreadRecorder recorder = (ThreadRecorder)this.recorders.get(Thread.currentThread());
        if (recorder == null) {
            return this.init(DEFAULT_SIZE, DEFAULT_LEVEL);
        }
        return recorder;
    }

    public void record(int level, Object payload) {
        ThreadRecorder recorder = this.get();
        if (recorder != null) {
            recorder.record(level, payload);
        }
    }

    public void record(int level, Object ... payload) {
        ThreadRecorder recorder = this.get();
        if (recorder != null) {
            recorder.record(level, payload);
        }
    }

    public void stop() {
        this.recording = false;
    }

    public Iterable<Record> getRecords() {
        return new Iterable<Record>(){

            @Override
            public Iterator<Record> iterator() {
                return new Iterator<Record>(){
                    final Thread[] threads;
                    final int n;
                    final ThreadRecorder[] trs;
                    final int[] is;
                    final long[] ts;
                    final Object[] ps;
                    int nextFr;
                    long lastTimestamp;
                    {
                        this.threads = FlightRecorder.this.recorders.keySet().toArray(new Thread[0]);
                        this.n = this.threads.length;
                        this.trs = new ThreadRecorder[this.n];
                        this.is = new int[this.n];
                        this.ts = new long[this.n];
                        this.ps = new Object[this.n];
                        this.nextFr = -1;
                        for (int i = 0; i < this.n; ++i) {
                            this.trs[i] = (ThreadRecorder)FlightRecorder.this.recorders.get(this.threads[i]);
                            this.is[i] = -1;
                            this.readNext(i);
                        }
                        this.nextFr = this.findMin();
                        this.lastTimestamp = -1L;
                    }

                    private void readNext(int index) {
                        ThreadRecorder tr = this.trs[index];
                        int i = this.is[index];
                        if (i < 0 && tr.numOfElements() == 0 || tr.isLast(i)) {
                            this.is[index] = -1;
                            this.ts[index] = Long.MAX_VALUE;
                            this.ps[index] = null;
                        } else {
                            this.is[index] = i = i < 0 ? tr.head : tr.next(i);
                            this.ts[index] = tr.timestamps[i];
                            this.ps[index] = tr.payloads[i];
                        }
                    }

                    private int findMin() {
                        long min = Long.MAX_VALUE;
                        int minIndex = -1;
                        for (int i = 0; i < this.n; ++i) {
                            if (this.ts[i] >= min) continue;
                            min = this.ts[i];
                            minIndex = i;
                        }
                        return minIndex;
                    }

                    private Record createRecord(int index, long lastTimestamp) {
                        long time = FlightRecorder.this.startWallTime + (this.ts[index] - FlightRecorder.this.startTimestamp) / 1000000L;
                        return new Record(this.threads[index], this.is[index], time, this.ps[index], time == lastTimestamp);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextFr >= 0;
                    }

                    @Override
                    public Record next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Record r = this.createRecord(this.nextFr, this.lastTimestamp);
                        this.readNext(this.nextFr);
                        this.nextFr = this.findMin();
                        return r;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dump(String fileName) {
        this.stop();
        fileName = ((String)fileName).replace("~", System.getProperty("user.home"));
        fileName = (String)fileName + ".gz";
        System.err.println("DUMPING FLIGHT LOG TO " + (String)fileName + "...");
        System.err.println("AVAILABLE RECORDERS");
        System.err.println("====================");
        for (Map.Entry entry : this.recorders.entrySet()) {
            System.err.println("THREAD " + entry.getKey() + " TOTAL RECORDED: " + ((ThreadRecorder)entry.getValue()).getTotalRecs() + " AVAILABLE: " + ((ThreadRecorder)entry.getValue()).numOfElements());
        }
        try {
            FileOutputStream fos = null;
            DeflaterOutputStream gos = null;
            PrintStream ps = null;
            try {
                fos = new FileOutputStream((String)fileName);
                gos = new GZIPOutputStream(fos);
                ps = new PrintStream(gos);
                this.dump(ps);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
                if (gos != null) {
                    gos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            System.err.println("DUMPED FLIGHT LOG TO " + (String)fileName);
        }
        catch (Exception ex) {
            System.err.println("EXCEPTION WHILE DUMPING FLIGHT LOG TO " + (String)fileName);
            ex.printStackTrace();
        }
    }

    public synchronized void dump(PrintStream ps) {
        ps.println("============================");
        ps.println("=== FLIGHT RECORDER DUMP ===");
        ps.println("============================");
        ps.println();
        ps.println("AVAILABLE RECORDERS");
        ps.println("====================");
        for (Map.Entry entry : this.recorders.entrySet()) {
            ps.println("THREAD " + entry.getKey() + " TOTAL RECORDED: " + ((ThreadRecorder)entry.getValue()).getTotalRecs() + " AVAILABLE: " + ((ThreadRecorder)entry.getValue()).numOfElements());
        }
        ps.println();
        ps.println("FLIGHT LOG");
        ps.println("====================");
        ps.println();
        for (Record record : this.getRecords()) {
            ps.println(record);
        }
        ps.println();
        ps.println("NO MORE RECORDS");
        ps.println("====================");
    }

    public static class Record {
        public final Thread thread;
        public final int index;
        public final long timestamp;
        public final Object payload;
        public final boolean sameAsLast;
        private static final long MILLIS_PER_SECOND = 1000L;
        private static final long SECONDS_PER_MINUTE = 60L;
        private static final long MINUTES_PER_HOUR = 60L;
        private static final long HOURS_PER_DAY = 24L;
        private static final long MILLIS_PER_MINUTE = 60000L;
        private static final long MILLIS_PER_HOUR = 3600000L;
        private static final long MILLIS_PER_DAY = 86400000L;

        private Record(Thread thread, int index, long timestamp, Object payload, boolean sameAsLast) {
            this.thread = thread;
            this.index = index;
            this.timestamp = timestamp;
            this.payload = payload;
            this.sameAsLast = sameAsLast;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(recordFormatter.format(new Object[]{this.formatTimestamp(this.timestamp), this.sameAsLast ? "*" : "", this.thread.getName(), this.index}));
            if (this.payload == null) {
                sb.append("NULL");
            } else {
                try {
                    sb.append(this.payload instanceof Object[] ? Arrays.toString((Object[])this.payload) : this.payload.toString());
                }
                catch (Exception e) {
                    sb.append("ERROR IN toString FOR THIS PAYLOAD");
                }
            }
            return sb.toString();
        }

        private String formatTimestamp(long m) {
            long hour = (m %= 86400000L) / 3600000L;
            long minute = (m %= 3600000L) / 60000L;
            long second = (m %= 60000L) / 1000L;
            long millis = m % 1000L;
            StringBuilder sb = new StringBuilder(13);
            sb.append(this.twoDigitDecimal((int)hour));
            sb.append(':');
            sb.append(this.twoDigitDecimal((int)minute));
            sb.append(':');
            sb.append(this.twoDigitDecimal((int)second));
            sb.append('.');
            sb.append(this.threeDigitDecimal((int)millis));
            return sb.toString();
        }

        private String twoDigitDecimal(int num) {
            if (num < 10) {
                return "0" + num;
            }
            return Integer.toString(num);
        }

        private String threeDigitDecimal(int num) {
            if (num < 10) {
                return "00" + num;
            }
            if (num < 100) {
                return "0" + num;
            }
            return Integer.toString(num);
        }
    }

    public class ThreadRecorder {
        private final Thread myThread = Thread.currentThread();
        private Object aux;
        private final int level;
        private final long[] timestamps;
        private final Object[] payloads;
        private long totalRecs;
        private int head;
        private int tail;

        private ThreadRecorder(int size, int level, Object aux) {
            this.aux = aux;
            this.level = level;
            this.timestamps = new long[size];
            this.payloads = new Object[size];
            this.head = 0;
            this.tail = 0;
            this.totalRecs = 0L;
        }

        public boolean recordsLevel(int level) {
            return level <= this.level;
        }

        public void setAux(Object aux) {
            this.aux = aux;
        }

        public Object getAux() {
            return this.aux;
        }

        public int numOfElements() {
            int n = this.tail - this.head;
            if (this.tail < this.head) {
                n += this.timestamps.length;
            }
            return n;
        }

        public long getTotalRecs() {
            return this.totalRecs;
        }

        private int next(int num) {
            if (++num == this.timestamps.length) {
                num = 0;
            }
            return num;
        }

        private boolean isLast(int i) {
            return this.next(i) == this.tail;
        }

        public Thread getThread() {
            return this.myThread;
        }

        public void record(int level, Object obj) {
            assert (Thread.currentThread() == this.myThread) : "my thread: " + this.myThread.getName() + " current thread: " + Thread.currentThread().getName();
            if (!FlightRecorder.this.recording) {
                return;
            }
            if (level > this.level) {
                return;
            }
            ++this.totalRecs;
            this.timestamps[this.tail] = System.nanoTime();
            this.payloads[this.tail] = obj;
            this.tail = this.next(this.tail);
            if (this.tail == this.head) {
                this.head = this.next(this.head);
            }
        }

        public void record(int level, Object ... objs) {
            this.record(level, (Object)objs);
        }
    }
}

