/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.util;

public final class Substring
implements CharSequence,
Comparable<Substring> {
    private final String s;
    private final int beginIndex;
    private final int endIndex;
    private int hash;

    public Substring(String s, int beginIndex, int endIndex) {
        if (s == null) {
            throw new NullPointerException();
        }
        this.s = s;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    public Substring(String s, int beginIndex) {
        this(s, beginIndex, s.length());
    }

    @Override
    public int length() {
        return this.endIndex - this.beginIndex;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.s.charAt(this.beginIndex + index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int length = this.endIndex - this.beginIndex;
        if (length < 0) {
            throw new StringIndexOutOfBoundsException("beginIndex > endIndex");
        }
        if (this.beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(this.beginIndex);
        }
        if (this.endIndex >= length) {
            throw new StringIndexOutOfBoundsException(this.endIndex);
        }
        return new Substring(this.s, this.beginIndex + start, this.beginIndex + end);
    }

    @Override
    public String toString() {
        return this.s.substring(this.beginIndex, this.endIndex);
    }

    public int hashCode() {
        int h = this.hash;
        int length = this.endIndex - this.beginIndex;
        if (h == 0 && length > 0) {
            for (int i = 0; i < length; ++i) {
                h = 31 * h + this.charAt(i);
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        CharSequence other;
        int n;
        if (this == obj) {
            return true;
        }
        if (obj instanceof Substring && (n = this.endIndex - this.beginIndex) == (other = (CharSequence)obj).length()) {
            int i = 0;
            while (n-- != 0) {
                if (this.charAt(i) != other.charAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Substring other) {
        int len1 = this.length();
        int len2 = other.length();
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = this.charAt(k);
            if (c1 == (c2 = other.charAt(k))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }
}

