/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.util;

import co.paralleluniverse.concurrent.util.OwnedSynchronizer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

class OwnedSynchronizer2
extends OwnedSynchronizer {
    private static final int SPINS = 0;
    private volatile boolean available;
    private volatile Thread waiter;
    private static final VarHandle WAITER;

    OwnedSynchronizer2() {
    }

    @Override
    public void register() {
        Thread currentThread = Thread.currentThread();
        if (!this.casWaiter(null, currentThread)) {
            throw new IllegalMonitorStateException("attempt by " + currentThread + " but owned by " + this.waiter);
        }
    }

    @Override
    public void unregister() {
        if (this.waiter != Thread.currentThread()) {
            throw new IllegalMonitorStateException("attempt by " + Thread.currentThread() + " but owned by " + this.waiter);
        }
        this.waiter = null;
    }

    @Override
    public boolean shouldSignal() {
        return this.waiter != null;
    }

    @Override
    public void signal() {
        this.available = true;
        Thread t = this.waiter;
        if (t != null) {
            LockSupport.unpark(t);
        }
    }

    @Override
    public void await() throws InterruptedException {
        int spins = 0;
        while (spins > 0) {
            if (this.available) {
                this.available = false;
                return;
            }
            if (ThreadLocalRandom.current().nextInt() < 0) continue;
            --spins;
        }
        LockSupport.park(this);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public long awaitNanos(long nanos) throws InterruptedException {
        long left = nanos;
        long deadline = System.nanoTime() + left;
        int spins = 0;
        while (spins > 0) {
            if (this.available) {
                this.available = false;
                return deadline - System.nanoTime();
            }
            if (ThreadLocalRandom.current().nextInt() >= 0) {
                --spins;
            }
            if (spins % 1000 != 0 || (left = deadline - System.nanoTime()) > 0L) continue;
            return left;
        }
        LockSupport.parkNanos(this, left);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        left = deadline - System.nanoTime();
        return left;
    }

    @Override
    public void await(long timeout, TimeUnit unit) throws InterruptedException {
        this.awaitNanos(TimeUnit.NANOSECONDS.convert(timeout, unit));
    }

    private boolean casWaiter(Thread expected, Thread update) {
        return WAITER.compareAndSet(this, expected, update);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            WAITER = l.findVarHandle(OwnedSynchronizer2.class, "waiter", Thread.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

