/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.util;

import co.paralleluniverse.common.reflection.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessControlContext;
import java.util.HashMap;
import java.util.Map;

public class ThreadAccess {
    private static final VarHandle TARGET;
    private static final VarHandle THREAD_LOCALS;
    private static final VarHandle INHERITABLE_THREAD_LOCALS;
    private static final VarHandle CONTEXT_CLASS_LOADER;
    private static final VarHandle INHERITED_ACCESS_CONTROL_CONTEXT;
    private static final Constructor threadLocalMapConstructor;
    private static final Constructor threadLocalMapInheritedConstructor;
    private static final Field threadLocalMapTableField;
    private static final Field threadLocalMapSizeField;
    private static final Field threadLocalMapThresholdField;
    private static final Class threadLocalMapEntryClass;
    private static final Constructor threadLocalMapEntryConstructor;
    private static final Field threadLocalMapEntryValueField;

    public static Runnable getTarget(Thread thread) {
        return TARGET.get(thread);
    }

    public static void setTarget(Thread thread, Runnable target) {
        TARGET.set(thread, target);
    }

    public static Object getThreadLocals(Thread thread) {
        return THREAD_LOCALS.get(thread);
    }

    public static void setThreadLocals(Thread thread, Object threadLocals) {
        THREAD_LOCALS.set(thread, threadLocals);
    }

    public static Object getInheritableThreadLocals(Thread thread) {
        return INHERITABLE_THREAD_LOCALS.get(thread);
    }

    public static void setInheritableThreadLocals(Thread thread, Object inheritableThreadLocals) {
        INHERITABLE_THREAD_LOCALS.set(thread, inheritableThreadLocals);
    }

    private static Object createThreadLocalMap(ThreadLocal tl, Object firstValue) {
        try {
            return threadLocalMapConstructor.newInstance(tl, firstValue);
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static Object createInheritedMap(Object inheritableThreadLocals) {
        try {
            return threadLocalMapInheritedConstructor.newInstance(inheritableThreadLocals);
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static Object cloneThreadLocalMap(Object orig) {
        try {
            Object clone = ThreadAccess.createThreadLocalMap(new ThreadLocal(), null);
            Object origTable = threadLocalMapTableField.get(orig);
            int len = Array.getLength(origTable);
            Object tableClone = Array.newInstance(threadLocalMapEntryClass, len);
            for (int i = 0; i < len; ++i) {
                Object entry = Array.get(origTable, i);
                if (entry == null) continue;
                Array.set(tableClone, i, ThreadAccess.cloneThreadLocalMapEntry(entry));
            }
            threadLocalMapTableField.set(clone, tableClone);
            threadLocalMapSizeField.setInt(clone, threadLocalMapSizeField.getInt(orig));
            threadLocalMapThresholdField.setInt(clone, threadLocalMapThresholdField.getInt(orig));
            return clone;
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static Object cloneThreadLocalMapEntry(Object entry) {
        try {
            ThreadLocal key = (ThreadLocal)((Reference)entry).get();
            Object value = threadLocalMapEntryValueField.get(entry);
            return threadLocalMapEntryConstructor.newInstance(key, value);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static Map<ThreadLocal, Object> toMap(Object threadLocalMap) {
        try {
            HashMap<ThreadLocal, Object> map = new HashMap<ThreadLocal, Object>();
            Object table = threadLocalMapTableField.get(threadLocalMap);
            int len = Array.getLength(table);
            for (int i = 0; i < len; ++i) {
                Object entry = Array.get(table, i);
                if (entry == null) continue;
                map.put((ThreadLocal)((Reference)entry).get(), threadLocalMapEntryValueField.get(entry));
            }
            return map;
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static ClassLoader getContextClassLoader(Thread thread) {
        return CONTEXT_CLASS_LOADER.get(thread);
    }

    public static void setContextClassLoader(Thread thread, ClassLoader classLoader) {
        CONTEXT_CLASS_LOADER.set(thread, classLoader);
    }

    public static AccessControlContext getInheritedAccessControlContext(Thread thread) {
        if (INHERITED_ACCESS_CONTROL_CONTEXT == null) {
            return null;
        }
        return INHERITED_ACCESS_CONTROL_CONTEXT.get(thread);
    }

    public static void setInheritedAccessControlContext(Thread thread, AccessControlContext accessControlContext) {
        if (INHERITED_ACCESS_CONTROL_CONTEXT != null) {
            INHERITED_ACCESS_CONTROL_CONTEXT.set(thread, accessControlContext);
        }
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            l = MethodHandles.privateLookupIn(Thread.class, l);
            TARGET = l.findVarHandle(Thread.class, "target", Runnable.class);
            THREAD_LOCALS = l.unreflectVarHandle(Thread.class.getDeclaredField("threadLocals"));
            INHERITABLE_THREAD_LOCALS = l.unreflectVarHandle(Thread.class.getDeclaredField("inheritableThreadLocals"));
            CONTEXT_CLASS_LOADER = l.unreflectVarHandle(Thread.class.getDeclaredField("contextClassLoader"));
            VarHandle _inheritedAccessControlContext = null;
            try {
                _inheritedAccessControlContext = l.unreflectVarHandle(Thread.class.getDeclaredField("inheritedAccessControlContext"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            INHERITED_ACCESS_CONTROL_CONTEXT = _inheritedAccessControlContext;
            Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            threadLocalMapConstructor = ReflectionUtil.accessible(threadLocalMapClass.getDeclaredConstructor(ThreadLocal.class, Object.class));
            threadLocalMapInheritedConstructor = ReflectionUtil.accessible(threadLocalMapClass.getDeclaredConstructor(threadLocalMapClass));
            threadLocalMapTableField = ReflectionUtil.accessible(threadLocalMapClass.getDeclaredField("table"));
            threadLocalMapSizeField = ReflectionUtil.accessible(threadLocalMapClass.getDeclaredField("size"));
            threadLocalMapThresholdField = ReflectionUtil.accessible(threadLocalMapClass.getDeclaredField("threshold"));
            threadLocalMapEntryClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap$Entry");
            threadLocalMapEntryConstructor = ReflectionUtil.accessible(threadLocalMapEntryClass.getDeclaredConstructor(ThreadLocal.class, Object.class));
            threadLocalMapEntryValueField = ReflectionUtil.accessible(threadLocalMapEntryClass.getDeclaredField("value"));
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

