/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.strands.Strand;
import javax.management.ConstructorParameters;

public class FiberInfo {
    private final long id;
    private final String name;
    private final Strand.State state;
    private final Object blocker;
    private final String blockerName;
    private final StackTraceElement[] stackTrace;

    public FiberInfo(long id, String name, Strand.State state, Object blocker, StackTraceElement[] stackTrace) {
        this.id = id;
        this.name = name;
        this.state = state;
        this.blocker = blocker;
        this.blockerName = null;
        this.stackTrace = stackTrace;
    }

    @ConstructorParameters(value={"id", "name", "state", "blocker", "stackTrace"})
    public FiberInfo(long id, String name, Strand.State state, String blockerName, StackTraceElement[] stackTrace) {
        this.id = id;
        this.name = name;
        this.state = state;
        this.blockerName = blockerName;
        this.blocker = null;
        this.stackTrace = stackTrace;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Strand.State getState() {
        return this.state;
    }

    public String getBlocker() {
        if (this.blocker == null) {
            return this.blockerName;
        }
        return this.blocker.toString();
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }
}

