/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberInfo;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class FibersDetailedMonitor {
    private final Map<Long, Fiber> fibers = new ConcurrentHashMap<Long, Fiber>();

    FibersDetailedMonitor() {
    }

    void fiberStarted(Fiber fiber) {
        this.fibers.put(fiber.getId(), fiber);
    }

    void fiberTerminated(Fiber fiber) {
        this.fibers.remove(fiber.getId());
    }

    public long[] getAllFiberIds() {
        int size = this.fibers.size();
        long[] ids = new long[size];
        int i = 0;
        Iterator<Long> iterator = this.fibers.keySet().iterator();
        while (iterator.hasNext()) {
            long id;
            ids[i] = id = iterator.next().longValue();
            ++i;
        }
        if (i < size) {
            return Arrays.copyOf(ids, i);
        }
        return ids;
    }

    public FiberInfo getFiberInfo(long id, boolean stack) {
        Fiber f = this.fibers.get(id);
        if (f == null) {
            return null;
        }
        return f.getFiberInfo(stack);
    }

    public FiberInfo[] getFiberInfo(long[] ids, boolean stack) {
        FiberInfo[] fis = new FiberInfo[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            fis[i] = this.getFiberInfo(ids[i], stack);
        }
        return fis;
    }
}

