/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.io.serialization.Serialization;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.Serializable;

public class ThreadLocalSerializer
extends Serializer<ThreadLocal<?>> {
    public static boolean PRINT_WARNINGS_ON_UNSERIALIZABLE_THREAD_LOCAL = false;

    public ThreadLocalSerializer() {
        this.setImmutable(true);
    }

    public void write(Kryo kryo, Output output, ThreadLocal<?> tl) {
        output.writeBoolean(tl instanceof InheritableThreadLocal);
        Object val = tl.get();
        int pos = output.position();
        try {
            kryo.writeClassAndObject(output, val);
        }
        catch (RuntimeException e) {
            if (PRINT_WARNINGS_ON_UNSERIALIZABLE_THREAD_LOCAL) {
                System.err.println("WARNING: Cannot serialize ThreadLocal (" + tl + " = " + val + "), it will be restored as null.");
            }
            output.setPosition(pos);
            kryo.writeObject(output, (Object)new DEFAULT());
        }
    }

    public ThreadLocal<?> read(Kryo kryo, Input input, Class<ThreadLocal<?>> type) {
        boolean inheritable = input.readBoolean();
        ThreadLocal tl = inheritable ? new InheritableThreadLocal() : new ThreadLocal();
        Object val = kryo.readClassAndObject(input);
        if (!(val instanceof DEFAULT)) {
            tl.set(val);
        }
        return tl;
    }

    private static boolean canSerialize(Kryo kryo, ThreadLocal<?> tl, Object val) {
        if (val == null) {
            return true;
        }
        if (val instanceof Serializable || kryo.getClassResolver().getRegistration(val.getClass()) != null) {
            return true;
        }
        if (val instanceof Serialization) {
            return false;
        }
        if (!kryo.getDefaultSerializer(val.getClass()).getClass().isAssignableFrom(FieldSerializer.class)) {
            return true;
        }
        if (PRINT_WARNINGS_ON_UNSERIALIZABLE_THREAD_LOCAL) {
            System.err.println("WARNING: Cannot serialize ThreadLocal (" + tl + " = " + val + "), it will be restored as null.");
        }
        return false;
    }

    static final class DEFAULT
    implements Serializable {
        DEFAULT() {
        }
    }
}

