/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.Handle;
import co.paralleluniverse.asm.Label;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.fibers.instrument.Classes;
import co.paralleluniverse.fibers.instrument.InstrumentMethod;
import co.paralleluniverse.fibers.instrument.MethodDatabase;

class LabelSuspendableCallSitesClassVisitor
extends ClassVisitor {
    private final MethodDatabase db;
    private String className;

    LabelSuspendableCallSitesClassVisitor(ClassVisitor cv, MethodDatabase db) {
        super(458752, cv);
        this.db = db;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        if (version < 49) {
            version = 49;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x100) == 0 && !Classes.isYieldMethod(this.className, name)) {
            MethodVisitor outMV = super.visitMethod(access, name, desc, signature, exceptions);
            return new MethodVisitor(458752, outMV){
                private int currLineNumber;
                {
                    this.currLineNumber = -1;
                }

                @Override
                public void visitLineNumber(int i, Label label) {
                    this.currLineNumber = i;
                    super.visitLineNumber(i, label);
                }

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
                    int type = 5;
                    if (InstrumentMethod.isSuspendableCall(LabelSuspendableCallSitesClassVisitor.this.db, 5, opcode, owner, name, desc)) {
                        Label l = new Label();
                        super.visitLabel(l);
                        super.visitLineNumber(this.currLineNumber, l);
                    }
                    super.visitMethodInsn(opcode, owner, name, desc, isInterface);
                }

                @Override
                public void visitInvokeDynamicInsn(String name, String desc, Handle handle, Object ... objects) {
                    int type = 6;
                    int opcode = 186;
                    if (InstrumentMethod.isSuspendableCall(LabelSuspendableCallSitesClassVisitor.this.db, 6, 186, handle.getOwner(), name, desc)) {
                        Label l = new Label();
                        super.visitLabel(l);
                        super.visitLineNumber(this.currLineNumber, l);
                    }
                    super.visitInvokeDynamicInsn(name, desc, handle, objects);
                }
            };
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }
}

