/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.ClassReader;
import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.ClassWriter;
import co.paralleluniverse.asm.ModuleVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ModuleFilterTask
extends Task {
    private final ArrayList<FileSet> filesets = new ArrayList();
    private String mod;

    public void addFileSet(FileSet fs) {
        this.filesets.add(fs);
    }

    public void setModule(String mod) {
        this.mod = mod;
    }

    public void execute() throws BuildException {
        try {
            ArrayList urls = new ArrayList();
            for (FileSet fs : this.filesets) {
                String[] includedFiles;
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                for (String filename : includedFiles = ds.getIncludedFiles()) {
                    if (!filename.endsWith("module-info.class")) continue;
                    File file = new File(fs.getDir(), filename);
                    if (file.isFile()) {
                        this.filter(file);
                        continue;
                    }
                    this.log("File not found: " + filename);
                }
            }
        }
        catch (Exception ex) {
            this.log(ex.getMessage());
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void filter(File file) {
        try {
            ClassWriter cw = null;
            try (FileInputStream fis = new FileInputStream(file);){
                ClassReader cr = new ClassReader(fis);
                cw = new ClassWriter(cr, 0);
                cr.accept(new ClassVisitor(458752, cw){

                    @Override
                    public ModuleVisitor visitModule(String name, int access, String version) {
                        return new ModuleVisitor(458752, super.visitModule(name, access, version)){

                            @Override
                            public void visitRequire(String module, int access, String version) {
                                if (!module.contains(ModuleFilterTask.this.mod)) {
                                    super.visitRequire(module, access, version);
                                }
                            }
                        };
                    }
                }, 0);
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(cw.toByteArray());
            }
        }
        catch (IOException ex) {
            throw new BuildException("Filterin module-info file " + file, (Throwable)ex);
        }
    }
}

