/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.tree.ClassNode;
import co.paralleluniverse.asm.tree.MethodNode;
import co.paralleluniverse.common.reflection.ASMUtil;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.fibers.instrument.SimpleSuspendableClassifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class OldSuspendablesScanner
extends Task {
    private static final boolean USE_REFLECTION = false;
    private static final String CLASSFILE_SUFFIX = ".class";
    private URLClassLoader cl;
    private final ArrayList<FileSet> filesets = new ArrayList();
    private final Set<String> results = new HashSet<String>();
    private String supersFile;
    private boolean append;
    private SimpleSuspendableClassifier ssc;
    private String suspendablesFile;

    public void addFileSet(FileSet fs) {
        this.filesets.add(fs);
    }

    public void setOutputFile(String outputFile) {
        this.supersFile = outputFile;
    }

    public void setAppend(boolean value) {
        this.append = value;
    }

    public void setSuspendablesFile(String suspendablesFile) {
        this.suspendablesFile = suspendablesFile;
    }

    public void run(String[] prefixes) throws Exception {
        for (String prefix : prefixes) {
            this.collect(prefix);
        }
        OldSuspendablesScanner.outputResults(this.supersFile, this.append, this.results);
    }

    public void nonAntExecute(String[] paths) throws Exception {
        this.readSuspandables();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            urls.add(new File(path).toURI().toURL());
        }
        this.log("URLs: " + urls, 3);
        this.cl = new URLClassLoader(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
        for (String path : paths) {
            for (File file : this.recursiveWalk(path)) {
                if (!file.getName().endsWith(CLASSFILE_SUFFIX) || !file.isFile()) continue;
                this.scanClass(file);
            }
        }
        this.scanSuspendablesFile();
        OldSuspendablesScanner.outputResults(this.supersFile, this.append, this.results);
    }

    public void execute() throws BuildException {
        this.readSuspandables();
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (FileSet fs : this.filesets) {
                urls.add(fs.getDir().toURI().toURL());
            }
            this.cl = new URLClassLoader(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
            this.log("URLs: " + Arrays.toString(this.cl.getURLs()), 2);
            for (FileSet fs : this.filesets) {
                try {
                    String[] includedFiles;
                    DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                    for (String filename : includedFiles = ds.getIncludedFiles()) {
                        if (!filename.endsWith(CLASSFILE_SUFFIX)) continue;
                        File file = new File(fs.getDir(), filename);
                        if (file.isFile()) {
                            this.scanClass(file);
                            continue;
                        }
                        this.log("File not found: " + filename);
                    }
                }
                catch (BuildException ex) {
                    this.log(ex.getMessage(), ex, 1);
                }
            }
            this.scanSuspendablesFile();
            this.log("OUTPUT: " + this.supersFile, 2);
            OldSuspendablesScanner.outputResults(this.supersFile, this.append, this.results);
        }
        catch (Exception e) {
            this.log(e, 0);
            throw new BuildException((Throwable)e);
        }
    }

    private void scanSuspendablesFile() throws Exception {
        if (this.ssc != null) {
            HashSet<String> classes = new HashSet<String>();
            for (String susCls : this.ssc.getSuspendableClasses()) {
                classes.add(susCls);
            }
            for (String susMethod : this.ssc.getSuspendables()) {
                classes.add(susMethod.substring(0, susMethod.indexOf(46)));
            }
            for (String className : classes) {
                this.log("scanning suspendable class:" + className, 3);
                this.scanClass(ASMUtil.getClassNode(className, this.cl, true));
            }
        }
    }

    public void readSuspandables() {
        if (this.suspendablesFile != null) {
            if (!new File(this.suspendablesFile).isFile()) {
                this.log("suspendable file " + this.suspendablesFile + " not found", 2);
            }
            this.ssc = new SimpleSuspendableClassifier(this.suspendablesFile);
            this.log("suspendablesFile: " + this.suspendablesFile, 2);
        }
    }

    private Set<String> collect(String prefix) throws Exception {
        prefix = prefix.trim();
        prefix = prefix.replace('.', '/');
        Enumeration<URL> urls = ClassLoader.getSystemResources(prefix);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            File file = new File(url.getFile());
            if (!file.isDirectory()) continue;
            this.scanClasses(file);
        }
        return this.results;
    }

    private void scanClasses(File file) throws Exception {
        if (file.isDirectory()) {
            System.out.println("Scanning dir: " + file.getPath());
            for (File f : file.listFiles()) {
                this.scanClasses(f);
            }
        } else {
            this.scanClass(file);
        }
    }

    private void scanClass(File file) throws Exception {
        this.log("Scanning " + file, 3);
        if (file != null) {
            this.scanClass(ASMUtil.getClassNode(new FileInputStream(file), true));
        }
    }

    private static void outputResults(String outputFile, boolean append1, Collection<String> results) throws Exception {
        try (PrintStream out = OldSuspendablesScanner.getOutputStream(outputFile, append1);){
            ArrayList<String> sorted = new ArrayList<String>(results);
            Collections.sort(sorted);
            for (String s : sorted) {
                out.println(s);
            }
        }
    }

    private static PrintStream getOutputStream(String outputFile, boolean append1) throws Exception {
        if (outputFile != null && (outputFile = outputFile.trim()).isEmpty()) {
            outputFile = null;
        }
        if (outputFile != null) {
            File file = new File(outputFile);
            if (file.getParent() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            return new PrintStream(new FileOutputStream(file, append1));
        }
        return System.out;
    }

    boolean isSuspendable(ClassNode cls, MethodNode m) {
        return ASMUtil.hasAnnotation(Suspendable.class, m) || this.ssc != null && this.ssc.isSuspendable(cls.name, m.name, m.desc);
    }

    public void scanClass(ClassNode cls) throws Exception {
        List<MethodNode> methods = cls.methods;
        for (MethodNode m : methods) {
            if (!this.isSuspendable(cls, m)) continue;
            this.log("Found annotated method: " + cls.name + "." + m.name + m.signature, 3);
            this.findSuperDeclarations(cls, cls, m);
        }
    }

    private boolean findSuperDeclarations(ClassNode cls, ClassNode declaringClass, MethodNode method) throws IOException {
        if (cls == null) {
            return false;
        }
        boolean foundMethod = false;
        MethodNode m = ASMUtil.getMethod(method, cls);
        if (m != null) {
            foundMethod = true;
            if (!ASMUtil.equals(cls, declaringClass) && !this.isSuspendable(cls, m)) {
                this.log("Found parent of annotated method: " + declaringClass.name + "." + method.name + method.signature + " in " + cls.name, 3);
                this.results.add(cls.name.replace('/', '.') + "." + method.name);
            }
        }
        boolean methodInParent = false;
        methodInParent |= this.findSuperDeclarations(ASMUtil.getClassNode(cls.superName, this.cl, true), declaringClass, method);
        for (String iface : cls.interfaces) {
            methodInParent |= this.findSuperDeclarations(ASMUtil.getClassNode(iface, this.cl, true), declaringClass, method);
        }
        if (!foundMethod && methodInParent) {
            this.log("Found parent of annotated method in a parent of: " + declaringClass.name + "." + method.name + method.signature + " in " + cls.name, 3);
            this.results.add(cls.name.replace('/', '.') + "." + method.name);
        }
        return foundMethod | methodInParent;
    }

    private String extractClassName(File file) {
        URL[] urls;
        String fileName = file.getPath();
        for (URL url : urls = this.cl.getURLs()) {
            if (!fileName.startsWith(url.getPath())) continue;
            String className = fileName.substring(url.getPath().length(), fileName.length() - CLASSFILE_SUFFIX.length()).replace('/', '.');
            return className;
        }
        throw new RuntimeException();
    }

    private void scanClass(Class cls) throws Exception {
        Method[] methods;
        for (Method m : methods = cls.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Suspendable.class)) continue;
            this.findSuperDeclarations(cls, m);
        }
    }

    private void findSuperDeclarations(Class cls, Method method) {
        if (cls == null) {
            return;
        }
        if (!cls.equals(method.getDeclaringClass())) {
            try {
                cls.getDeclaredMethod(method.getName(), method.getParameterTypes());
                this.results.add(cls.getName() + "." + method.getName());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.findSuperDeclarations(cls.getSuperclass(), method);
        for (Class<?> iface : cls.getInterfaces()) {
            this.findSuperDeclarations(iface, method);
        }
    }

    private List<File> recursiveWalk(String path) {
        File[] list = new File(path).listFiles();
        ArrayList<File> result = new ArrayList<File>();
        if (list == null) {
            return result;
        }
        for (File f : list) {
            if (f.isDirectory()) {
                result.addAll(this.recursiveWalk(f.getAbsolutePath()));
                continue;
            }
            result.add(f);
        }
        return result;
    }
}

