/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.channels;

import co.paralleluniverse.common.util.Pair;
import co.paralleluniverse.concurrent.util.EnhancedAtomicReference;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.Channel;
import co.paralleluniverse.strands.channels.Channels;
import co.paralleluniverse.strands.channels.Mix;
import co.paralleluniverse.strands.channels.Port;
import co.paralleluniverse.strands.channels.ReceivePort;
import co.paralleluniverse.strands.channels.Selector;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@Instrumented
public class ReceivePortGroup<M>
implements Mix<M> {
    private static final Object ping = new Object();
    private static final Predicate<Mix.State> soloP = new Predicate<Mix.State>(){

        public boolean apply(Mix.State s) {
            return s != null && s.solo != false;
        }
    };
    private static final Mix.Mode modeDefault = Mix.Mode.NORMAL;
    private static final boolean soloDefault = false;
    private static final Mix.SoloEffect soloEffectDefault = Mix.SoloEffect.PAUSE_OTHERS;
    private static final boolean alwaysOpenDefault = false;
    private static final Channel changedCh = Channels.newChannel(1, Channels.OverflowPolicy.DISPLACE, false, true);
    private final EnhancedAtomicReference<Mix.SoloEffect> soloEffect = new EnhancedAtomicReference();
    private final EnhancedAtomicReference<Map<? extends ReceivePort<? extends M>, Mix.State>> states = new EnhancedAtomicReference();
    private final EnhancedAtomicReference<Pair<Selector<M>, Map<? extends ReceivePort<? extends M>, Mix.State>>> selector = new EnhancedAtomicReference();
    private final boolean alwaysOpen;

    public ReceivePortGroup(Collection<? extends ReceivePort<? extends M>> ports, boolean alwaysOpen) {
        this.alwaysOpen = alwaysOpen;
        this.soloEffect.set(soloEffectDefault);
        HashMap<ReceivePort, Mix.State> newStates = new HashMap<ReceivePort, Mix.State>();
        for (ReceivePort port : ImmutableList.copyOf(ports)) {
            newStates.put(port, new Mix.State(modeDefault, false));
        }
        this.states.set((Map<ReceivePort<M>, Mix.State>)ImmutableMap.copyOf(newStates));
    }

    public ReceivePortGroup(Collection<? extends ReceivePort<? extends M>> ports) {
        this((Collection<ReceivePort<M>>)ImmutableList.copyOf(ports), false);
    }

    public ReceivePortGroup(ReceivePort<? extends M> ... ports) {
        this((Collection<ReceivePort<M>>)ImmutableList.copyOf((Object[])ports), false);
    }

    public ReceivePortGroup(boolean alwaysOpen) {
        this((Collection<ReceivePort<M>>)ImmutableList.of(), alwaysOpen);
    }

    public ReceivePortGroup() {
        this((Collection<ReceivePort<M>>)ImmutableList.of(), false);
    }

    @Override
    public M tryReceive() {
        try {
            return this.receive(0L, TimeUnit.NANOSECONDS);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() {
        this.removeClosed();
        return !this.alwaysOpen && ((Map)this.states.get()).isEmpty();
    }

    private void setupSelector() {
        Map newStates;
        Pair curr = (Pair)this.selector.get();
        Map currStates = curr != null ? (Map)curr.getSecond() : (Map)this.states.get();
        if (currStates == (newStates = (Map)this.states.get()) && curr != null && curr.getFirst() != null) {
            ((Selector)curr.getFirst()).reset();
        } else {
            Set newPorts = newStates.keySet();
            ArrayList mutedActions = new ArrayList(newPorts.size());
            ArrayList enabledActions = new ArrayList(newPorts.size());
            for (ReceivePort port : newPorts) {
                if (this.isPaused(port, newStates)) continue;
                if (this.isMuted(port, newStates)) {
                    mutedActions.add(Selector.receive(port));
                    continue;
                }
                enabledActions.add(Selector.receive(port));
            }
            ArrayList actions = new ArrayList(newPorts.size());
            actions.add(Selector.receive(changedCh));
            actions.addAll(mutedActions);
            actions.addAll(enabledActions);
            this.selector.set(new Pair(new Selector(true, actions), newStates));
        }
    }

    private boolean isMuted(Port<? extends M> port, Map<? extends ReceivePort<? extends M>, Mix.State> s) {
        return s.get(port).solo == false && (s.get(port).mode.equals((Object)Mix.Mode.MUTE) || ((Mix.SoloEffect)((Object)this.soloEffect.get())).equals((Object)Mix.SoloEffect.MUTE_OTHERS) && Iterables.any(s.values(), soloP));
    }

    private boolean isPaused(ReceivePort<? extends M> port, Map<? extends ReceivePort<? extends M>, Mix.State> s) {
        return s.get(port).solo == false && (s.get(port).mode.equals((Object)Mix.Mode.PAUSE) || ((Mix.SoloEffect)((Object)this.soloEffect.get())).equals((Object)Mix.SoloEffect.PAUSE_OTHERS) && Iterables.any(s.values(), soloP));
    }

    private void removeClosed() {
        this.states.swap(new Function<Map<? extends ReceivePort<? extends M>, Mix.State>, Map<? extends ReceivePort<? extends M>, Mix.State>>(){

            public Map<? extends ReceivePort<? extends M>, Mix.State> apply(Map<? extends ReceivePort<? extends M>, Mix.State> currStates) {
                HashMap newStates = new HashMap(currStates);
                for (ReceivePort port : currStates.keySet()) {
                    if (!port.isClosed()) continue;
                    newStates.remove(port);
                }
                return ImmutableMap.copyOf(newStates);
            }
        });
    }

    @Override
    public <T extends ReceivePort<? extends M>> Map<T, Mix.State> getState(T ... items) {
        if (items == null || items.length == 0) {
            return ImmutableMap.copyOf((Map)((Map)this.states.get()));
        }
        ImmutableList itemsCopy = ImmutableList.copyOf((Object[])items);
        Map currStates = (Map)this.states.get();
        HashMap<ReceivePort, Mix.State> ret = new HashMap<ReceivePort, Mix.State>(itemsCopy.size());
        for (ReceivePort p : itemsCopy) {
            ret.put(p, (Mix.State)currStates.get(p));
        }
        return ret;
    }

    @Override
    public Mix.SoloEffect getSoloEffect() {
        return (Mix.SoloEffect)((Object)this.soloEffect.get());
    }

    @Override
    @Instrumented(methodOptimized=true, methodStart=98, methodEnd=98, suspendableCallSites={98}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/ReceivePortGroup.receive(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={5})
    public M receive() throws SuspendExecution, InterruptedException {
        return this.receive(-1L, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=103, methodEnd=103, suspendableCallSites={103}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/ReceivePortGroup.receive(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={118})
    public M receive(Timeout var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=109, methodEnd=169, suspendableCallSites={128, 131, 135}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.trySelect()Lco/paralleluniverse/strands/channels/SelectAction;", "co/paralleluniverse/strands/channels/Selector.select()Lco/paralleluniverse/strands/channels/SelectAction;", "co/paralleluniverse/strands/channels/Selector.select(JLjava/util/concurrent/TimeUnit;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={339, 558, 737})
    public M receive(long var1_1, TimeUnit var3_2) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=237, methodEnd=250, suspendableCallSites={248}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Channel.send(Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={150})
    public <T extends ReceivePort<? extends M>> void add(T ... var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=254, methodEnd=269, suspendableCallSites={267}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Channel.send(Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={163})
    public <T extends ReceivePort<? extends M>> void remove(T ... var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=300, methodEnd=318, suspendableCallSites={317}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Channel.send(Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={176})
    public <T extends ReceivePort<? extends M>> void setState(Mix.State var1_1, T ... var2_2) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=322, methodEnd=347, suspendableCallSites={345}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Channel.send(Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={145})
    public <T extends ReceivePort<? extends M>> void setState(Map<T, Mix.State> var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=356, methodEnd=358, suspendableCallSites={357}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Channel.send(Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={111})
    public void setSoloEffect(Mix.SoloEffect var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

