/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.channels;

import co.paralleluniverse.common.monitoring.FlightRecorder;
import co.paralleluniverse.common.monitoring.FlightRecorderMessage;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.Synchronization;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.ReceivePort;
import co.paralleluniverse.strands.channels.SelectAction;
import co.paralleluniverse.strands.channels.SelectActionImpl;
import co.paralleluniverse.strands.channels.SelectReceiveListener;
import co.paralleluniverse.strands.channels.SelectSendListener;
import co.paralleluniverse.strands.channels.SendPort;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@Instrumented
public class Selector<Message>
implements Synchronization {
    private static final AtomicLong selectorId = new AtomicLong();
    private static final Object LEASED = new Object(){

        public String toString() {
            return "LEASED";
        }
    };
    final long id = selectorId.incrementAndGet();
    private volatile Object winner;
    private Strand waiter = Strand.currentStrand();
    private final List<? extends SelectActionImpl<Message>> actions;
    private int lastRegistered;
    private final boolean priority;
    SelectAction<Message> res;
    private static final VarHandle WINNER;
    static final FlightRecorder RECORDER;

    public static <Message> SelectAction<Message> send(SendPort<? super Message> ch, Message message) {
        return Selector.send(ch, message, null);
    }

    public static <Message> SelectAction<Message> send(SendPort<? super Message> ch, Message message, SelectSendListener<Message> listener) {
        return new SelectActionImpl<Message>(ch, message, listener);
    }

    public static <Message> SelectAction<Message> receive(ReceivePort<? extends Message> ch) {
        return Selector.receive(ch, null);
    }

    public static <Message> SelectAction<Message> receive(ReceivePort<? extends Message> ch, SelectReceiveListener<Message> listener) {
        return new SelectActionImpl<Message>(ch, listener);
    }

    Selector(boolean priority, List<? extends SelectAction<Message>> actions) {
        this.actions = actions;
        this.priority = priority;
        for (int i = 0; i < actions.size(); ++i) {
            SelectActionImpl sa = (SelectActionImpl)actions.get(i);
            sa.setSelector(this);
            sa.setIndex(i);
            Selector.record("<init>", "%s added %s", this, sa);
        }
    }

    private void selectInit() {
        if (!this.priority) {
            Collections.shuffle(this.actions, ThreadLocalRandom.current());
        }
    }

    void reset() {
        this.waiter = null;
        for (SelectActionImpl<Message> sa : this.actions) {
            sa.resetReceive();
        }
        this.winner = null;
    }

    @Override
    public Object register() {
        Strand s = Strand.currentStrand();
        if (this.waiter != null && !this.waiter.equals(s)) {
            throw new IllegalMonitorStateException("A strand is already registered");
        }
        this.waiter = Strand.currentStrand();
        int n = this.actions.size();
        this.res = null;
        this.lastRegistered = -1;
        for (int i = 0; i < n; ++i) {
            SelectActionImpl<Message> sa = this.actions.get(i);
            sa.token = sa.port.register(sa);
            this.lastRegistered = i;
            if (sa.isDone()) {
                assert (this.winner == sa);
                this.res = sa;
                break;
            }
            Object w = this.winner;
            if (w != null & w != LEASED) break;
        }
        return null;
    }

    @Override
    public void unregister(Object registrationToken) {
        for (int i = 0; i <= this.lastRegistered; ++i) {
            SelectActionImpl<Message> sa = this.actions.get(i);
            sa.port.unregister(sa.token);
            sa.token = null;
        }
        this.waiter = null;
    }

    boolean lease() {
        Selector.record("lease", "trying lease %s", this);
        int i = 0;
        long start = 0L;
        do {
            Object w;
            if ((w = this.winner) != null & w != LEASED) {
                return false;
            }
            if (i++ <= 0x400000) continue;
            if (start == 0L) {
                start = System.nanoTime();
            } else if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) > 10000L) {
                throw new RuntimeException("Unable to obtain selector lease in 10 seconds: " + w);
            }
            i = 0;
            Thread.yield();
        } while (!this.casWinner(null, LEASED));
        Selector.record("lease", "got lease %s", this);
        return true;
    }

    void setWinner(SelectAction<?> action) {
        Selector.record("setWinner", "won %s: %s", this, action);
        assert (this.winner == LEASED);
        this.winner = action;
    }

    void returnLease() {
        Selector.record("returnLease", "returned lease %s", this);
        assert (this.winner == LEASED);
        this.winner = null;
    }

    Strand getWaiter() {
        return this.waiter;
    }

    void signal() {
        this.waiter.unpark(this);
    }

    public SelectAction<?> getWinner() {
        return (SelectAction)this.winner;
    }

    private static int[] randomIntArray(int n) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int[] a = new int[n];
        int i = 1;
        while (i < n) {
            int x = random.nextInt(i);
            a[i] = a[x];
            a[x] = i++;
        }
        return a;
    }

    public String toString() {
        return Selector.class.getName() + "@" + Long.toHexString(this.id);
    }

    private boolean casWinner(Object expected, Object update) {
        return WINNER.compareAndSet(this, expected, update);
    }

    boolean isRecording() {
        return RECORDER != null;
    }

    static void record(String method, String format) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Selector", method, format, null));
        }
    }

    static void record(String method, String format, Object arg1) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Selector", method, format, new Object[]{arg1}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Selector", method, format, new Object[]{arg1, arg2}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Selector", method, format, new Object[]{arg1, arg2, arg3}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Selector", method, format, new Object[]{arg1, arg2, arg3, arg4}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Selector", method, format, new Object[]{arg1, arg2, arg3, arg4, arg5}));
        }
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            WINNER = l.findVarHandle(Selector.class, "winner", Object.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        RECORDER = Debug.isDebug() ? Debug.getGlobalFlightRecorder() : null;
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=49, methodEnd=49, suspendableCallSites={49}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select()Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={111})
    public static <Message> SelectAction<Message> select(boolean var0, SelectAction<Message> ... var1_1) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=64, methodEnd=64, suspendableCallSites={64}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(JLjava/util/concurrent/TimeUnit;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={190})
    public static <Message> SelectAction<Message> select(boolean var0, long var1_1, TimeUnit var3_2, SelectAction<Message> ... var4_3) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=78, methodEnd=78, suspendableCallSites={78}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(Lco/paralleluniverse/strands/Timeout;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={142})
    public static <Message> SelectAction<Message> select(boolean var0, Timeout var1_1, SelectAction<Message> ... var2_2) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=91, methodEnd=91, suspendableCallSites={91}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select()Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={126})
    public static <Message> SelectAction<Message> select(boolean var0, List<? extends SelectAction<Message>> var1_1) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=106, methodEnd=106, suspendableCallSites={106}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(JLjava/util/concurrent/TimeUnit;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={207})
    public static <Message> SelectAction<Message> select(boolean var0, long var1_1, TimeUnit var3_2, List<? extends SelectAction<Message>> var4_3) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=120, methodEnd=120, suspendableCallSites={120}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(Lco/paralleluniverse/strands/Timeout;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={157})
    public static <Message> SelectAction<Message> select(boolean var0, Timeout var1_1, List<? extends SelectAction<Message>> var2_2) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Instrumented(methodOptimized=true, methodStart=132, methodEnd=132, suspendableCallSites={132}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(Z[Lco/paralleluniverse/strands/channels/SelectAction;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={2})
    public static <Message> SelectAction<Message> select(SelectAction<Message> ... actions) throws InterruptedException, SuspendExecution {
        return Selector.select(false, actions);
    }

    @Instrumented(methodOptimized=true, methodStart=146, methodEnd=146, suspendableCallSites={146}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(ZJLjava/util/concurrent/TimeUnit;[Lco/paralleluniverse/strands/channels/SelectAction;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={4})
    public static <Message> SelectAction<Message> select(long timeout, TimeUnit unit, SelectAction<Message> ... actions) throws InterruptedException, SuspendExecution {
        return Selector.select(false, timeout, unit, actions);
    }

    @Instrumented(methodOptimized=true, methodStart=159, methodEnd=159, suspendableCallSites={159}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(ZLco/paralleluniverse/strands/Timeout;[Lco/paralleluniverse/strands/channels/SelectAction;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={3})
    public static <Message> SelectAction<Message> select(Timeout timeout, SelectAction<Message> ... actions) throws InterruptedException, SuspendExecution {
        return Selector.select(false, timeout, actions);
    }

    @Instrumented(methodOptimized=true, methodStart=171, methodEnd=171, suspendableCallSites={171}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(ZLjava/util/List;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={2})
    public static <Message> SelectAction<Message> select(List<? extends SelectAction<Message>> actions) throws InterruptedException, SuspendExecution {
        return Selector.select(false, actions);
    }

    @Instrumented(methodOptimized=true, methodStart=185, methodEnd=185, suspendableCallSites={185}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(ZJLjava/util/concurrent/TimeUnit;Ljava/util/List;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={4})
    public static <Message> SelectAction<Message> select(long timeout, TimeUnit unit, List<? extends SelectAction<Message>> actions) throws InterruptedException, SuspendExecution {
        return Selector.select(false, timeout, unit, actions);
    }

    @Instrumented(methodOptimized=true, methodStart=198, methodEnd=198, suspendableCallSites={198}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(ZLco/paralleluniverse/strands/Timeout;Ljava/util/List;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={3})
    public static <Message> SelectAction<Message> select(Timeout timeout, List<? extends SelectAction<Message>> actions) throws InterruptedException, SuspendExecution {
        return Selector.select(false, timeout, actions);
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=211, methodEnd=211, suspendableCallSites={211}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.trySelect()Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={111})
    public static <Message> SelectAction<Message> trySelect(boolean var0, SelectAction<Message> ... var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=224, methodEnd=224, suspendableCallSites={224}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.trySelect()Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={126})
    public static <Message> SelectAction<Message> trySelect(boolean var0, List<? extends SelectAction<Message>> var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Instrumented(methodOptimized=true, methodStart=235, methodEnd=235, suspendableCallSites={235}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.trySelect(Z[Lco/paralleluniverse/strands/channels/SelectAction;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={2})
    public static <Message> SelectAction<Message> trySelect(SelectAction<Message> ... actions) throws SuspendExecution {
        return Selector.trySelect(false, actions);
    }

    @Instrumented(methodOptimized=true, methodStart=246, methodEnd=246, suspendableCallSites={246}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.trySelect(ZLjava/util/List;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={2})
    public static <Message> SelectAction<Message> trySelect(List<? extends SelectAction<Message>> actions) throws SuspendExecution {
        return Selector.trySelect(false, actions);
    }

    @Instrumented(methodOptimized=true, methodStart=339, methodEnd=339, suspendableCallSites={339}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(JLjava/util/concurrent/TimeUnit;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={5})
    SelectAction<Message> select() throws InterruptedException, SuspendExecution {
        return this.select(-1L, null);
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=383, methodEnd=383, suspendableCallSites={383}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.select(JLjava/util/concurrent/TimeUnit;)Lco/paralleluniverse/strands/channels/SelectAction;"}, suspendableCallSitesOffsetsAfterInstr={118})
    SelectAction<Message> select(Timeout var1_1) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=387, methodEnd=427, suspendableCallSites={388, 416, 419, 426}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/Selector.trySelect()Lco/paralleluniverse/strands/channels/SelectAction;", "co/paralleluniverse/strands/Strand.park(Ljava/lang/Object;)V", "co/paralleluniverse/strands/channels/SelectActionImpl.fire()V", "co/paralleluniverse/strands/Strand.parkNanos(Ljava/lang/Object;J)V"}, suspendableCallSitesOffsetsAfterInstr={138, 476, 628, 793})
    SelectAction<Message> select(long var1_1, TimeUnit var3_2) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=431, methodEnd=449, suspendableCallSites={437, 441, 444}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/SelectActionImpl.fire()V", "co/paralleluniverse/strands/channels/ReceivePort.tryReceive()Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={183, 267, 373})
    public SelectAction<Message> trySelect() throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

