/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.concurrent;

import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.concurrent.AbstractOwnableSynchronizer;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

@Instrumented
public abstract class AbstractQueuedSynchronizer
extends AbstractOwnableSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414691L;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile int state;
    static final long spinForTimeoutThreshold = 1000L;
    private static final VarHandle STATE;
    private static final VarHandle HEAD;
    private static final VarHandle TAIL;
    private static final VarHandle WAIT_STATUS;
    private static final VarHandle NEXT;

    protected AbstractQueuedSynchronizer() {
    }

    protected final int getState() {
        return this.state;
    }

    protected final void setState(int newState) {
        this.state = newState;
    }

    protected final boolean compareAndSetState(int expect, int update) {
        return STATE.compareAndSet(this, expect, update);
    }

    private Node enq(Node node) {
        Node t;
        while (true) {
            if ((t = this.tail) == null) {
                if (!this.compareAndSetHead(new Node())) continue;
                this.tail = this.head;
                continue;
            }
            node.prev = t;
            if (this.compareAndSetTail(t, node)) break;
        }
        t.next = node;
        return t;
    }

    private Node addWaiter(Node mode) {
        Node node = new Node(Strand.currentStrand(), mode);
        Node pred = this.tail;
        if (pred != null) {
            node.prev = pred;
            if (this.compareAndSetTail(pred, node)) {
                pred.next = node;
                return node;
            }
        }
        this.enq(node);
        return node;
    }

    private void setHead(Node node) {
        this.head = node;
        node.strand = null;
        node.prev = null;
    }

    private void unparkSuccessor(Node node) {
        Node s;
        int ws = node.waitStatus;
        if (ws < 0) {
            AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, ws, 0);
        }
        if ((s = node.next) == null || s.waitStatus > 0) {
            s = null;
            Node t = this.tail;
            while (t != null && t != node) {
                if (t.waitStatus <= 0) {
                    s = t;
                }
                t = t.prev;
            }
        }
        if (s != null) {
            Strand.unpark(s.strand);
        }
    }

    private void doReleaseShared() {
        while (true) {
            Node h;
            if ((h = this.head) != null && h != this.tail) {
                int ws = h.waitStatus;
                if (ws == -1) {
                    if (!AbstractQueuedSynchronizer.compareAndSetWaitStatus(h, -1, 0)) continue;
                    this.unparkSuccessor(h);
                } else if (ws == 0 && !AbstractQueuedSynchronizer.compareAndSetWaitStatus(h, 0, -3)) continue;
            }
            if (h == this.head) break;
        }
    }

    private void setHeadAndPropagate(Node node, int propagate) {
        Node s;
        Node h = this.head;
        this.setHead(node);
        if (!(propagate <= 0 && h != null && h.waitStatus >= 0 || (s = node.next) != null && !s.isShared())) {
            this.doReleaseShared();
        }
    }

    private void cancelAcquire(Node node) {
        if (node == null) {
            return;
        }
        node.strand = null;
        Node pred = node.prev;
        while (pred.waitStatus > 0) {
            node.prev = pred = pred.prev;
        }
        Node predNext = pred.next;
        node.waitStatus = 1;
        if (node == this.tail && this.compareAndSetTail(node, pred)) {
            AbstractQueuedSynchronizer.compareAndSetNext(pred, predNext, null);
        } else {
            int ws;
            if (pred != this.head && ((ws = pred.waitStatus) == -1 || ws <= 0 && AbstractQueuedSynchronizer.compareAndSetWaitStatus(pred, ws, -1)) && pred.strand != null) {
                Node next = node.next;
                if (next != null && next.waitStatus <= 0) {
                    AbstractQueuedSynchronizer.compareAndSetNext(pred, predNext, next);
                }
            } else {
                this.unparkSuccessor(node);
            }
            node.next = node;
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node pred, Node node) {
        int ws = pred.waitStatus;
        if (ws == -1) {
            return true;
        }
        if (ws > 0) {
            do {
                node.prev = pred = pred.prev;
            } while (pred.waitStatus > 0);
            pred.next = node;
        } else {
            AbstractQueuedSynchronizer.compareAndSetWaitStatus(pred, ws, -1);
        }
        return false;
    }

    static void selfInterrupt() {
        Strand.currentStrand().interrupt();
    }

    protected boolean tryAcquire(int arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryRelease(int arg) {
        throw new UnsupportedOperationException();
    }

    protected int tryAcquireShared(int arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryReleaseShared(int arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean isHeldExclusively() {
        throw new UnsupportedOperationException();
    }

    public final boolean release(int arg) {
        if (this.tryRelease(arg)) {
            Node h = this.head;
            if (h != null && h.waitStatus != 0) {
                this.unparkSuccessor(h);
            }
            return true;
        }
        return false;
    }

    public final boolean releaseShared(int arg) {
        if (this.tryReleaseShared(arg)) {
            this.doReleaseShared();
            return true;
        }
        return false;
    }

    public final boolean hasQueuedStrands() {
        return this.head != this.tail;
    }

    public final boolean hasContended() {
        return this.head != null;
    }

    public final Strand getFirstQueuedStrand() {
        return this.head == this.tail ? null : this.fullGetFirstQueuedStrand();
    }

    private Strand fullGetFirstQueuedStrand() {
        Strand st;
        Node s;
        Node h = this.head;
        if (h != null && (s = h.next) != null && s.prev == this.head && (st = s.strand) != null || (h = this.head) != null && (s = h.next) != null && s.prev == this.head && (st = s.strand) != null) {
            return st;
        }
        Node t = this.tail;
        Strand firstStrand = null;
        while (t != null && t != this.head) {
            Strand tt = t.strand;
            if (tt != null) {
                firstStrand = tt;
            }
            t = t.prev;
        }
        return firstStrand;
    }

    public final boolean isQueued(Strand strand) {
        if (strand == null) {
            throw new NullPointerException();
        }
        Node p = this.tail;
        while (p != null) {
            if (p.strand == strand) {
                return true;
            }
            p = p.prev;
        }
        return false;
    }

    final boolean apparentlyFirstQueuedIsExclusive() {
        Node s;
        Node h = this.head;
        return h != null && (s = h.next) != null && !s.isShared() && s.strand != null;
    }

    public final boolean hasQueuedPredecessors() {
        Node s;
        Node h = this.head;
        Node t = this.tail;
        return h != t && ((s = h.next) == null || s.strand != Strand.currentStrand());
    }

    public final int getQueueLength() {
        int n = 0;
        Node p = this.tail;
        while (p != null) {
            if (p.strand != null) {
                ++n;
            }
            p = p.prev;
        }
        return n;
    }

    public final Collection<Strand> getQueuedStrands() {
        ArrayList<Strand> list = new ArrayList<Strand>();
        Node p = this.tail;
        while (p != null) {
            Strand t = p.strand;
            if (t != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public final Collection<Strand> getExclusiveQueuedStrands() {
        ArrayList<Strand> list = new ArrayList<Strand>();
        Node p = this.tail;
        while (p != null) {
            Strand t;
            if (!p.isShared() && (t = p.strand) != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public final Collection<Strand> getSharedQueuedStrands() {
        ArrayList<Strand> list = new ArrayList<Strand>();
        Node p = this.tail;
        while (p != null) {
            Strand t;
            if (p.isShared() && (t = p.strand) != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public String toString() {
        int s = this.getState();
        String q = this.hasQueuedStrands() ? "non" : "";
        return super.toString() + "[State = " + s + ", " + q + "empty queue]";
    }

    final boolean isOnSyncQueue(Node node) {
        if (node.waitStatus == -2 || node.prev == null) {
            return false;
        }
        if (node.next != null) {
            return true;
        }
        return this.findNodeFromTail(node);
    }

    private boolean findNodeFromTail(Node node) {
        Node t = this.tail;
        while (t != node) {
            if (t == null) {
                return false;
            }
            t = t.prev;
        }
        return true;
    }

    final boolean transferForSignal(Node node) {
        if (!AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            return false;
        }
        Node p = this.enq(node);
        int ws = p.waitStatus;
        if (ws > 0 || !AbstractQueuedSynchronizer.compareAndSetWaitStatus(p, ws, -1)) {
            Strand.unpark(node.strand);
        }
        return true;
    }

    final int fullyRelease(Node node) {
        boolean failed = true;
        try {
            int savedState = this.getState();
            if (this.release(savedState)) {
                failed = false;
                int n = savedState;
                return n;
            }
            throw new IllegalMonitorStateException();
        }
        finally {
            if (failed) {
                node.waitStatus = 1;
            }
        }
    }

    public final boolean owns(ConditionObject condition) {
        return condition.isOwnedBy(this);
    }

    public final boolean hasWaiters(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.hasWaiters();
    }

    public final int getWaitQueueLength(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.getWaitQueueLength();
    }

    public final Collection<Strand> getWaitingStrands(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.getWaitingStrands();
    }

    private final boolean compareAndSetHead(Node update) {
        return HEAD.compareAndSet(this, null, update);
    }

    private final boolean compareAndSetTail(Node expect, Node update) {
        return TAIL.compareAndSet(this, expect, update);
    }

    private static final boolean compareAndSetWaitStatus(Node node, int expect, int update) {
        return WAIT_STATUS.compareAndSet(node, expect, update);
    }

    private static final boolean compareAndSetNext(Node node, Node expect, Node update) {
        return NEXT.compareAndSet(node, expect, update);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            STATE = l.findVarHandle(AbstractQueuedSynchronizer.class, "state", Integer.TYPE);
            HEAD = l.findVarHandle(AbstractQueuedSynchronizer.class, "head", Node.class);
            TAIL = l.findVarHandle(AbstractQueuedSynchronizer.class, "tail", Node.class);
            WAIT_STATUS = l.findVarHandle(Node.class, "waitStatus", Integer.TYPE);
            NEXT = l.findVarHandle(Node.class, "next", Node.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Instrumented(methodOptimized=true, methodStart=841, methodEnd=842, suspendableCallSites={841}, suspendableCallSiteNames={"co/paralleluniverse/strands/Strand.park(Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={1})
    private boolean parkAndCheckInterrupt() throws SuspendExecution {
        Strand.park(this);
        return Strand.interrupted();
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=863, methodEnd=881, suspendableCallSites={875}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.parkAndCheckInterrupt()Z"}, suspendableCallSitesOffsetsAfterInstr={242})
    final boolean acquireQueued(Node var1_1, int var2_2) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=890, methodEnd=908, suspendableCallSites={902}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.parkAndCheckInterrupt()Z"}, suspendableCallSitesOffsetsAfterInstr={225})
    private void doAcquireInterruptibly(int var1_1) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=920, methodEnd=946, suspendableCallSites={939}, suspendableCallSiteNames={"co/paralleluniverse/strands/Strand.parkNanos(Ljava/lang/Object;J)V"}, suspendableCallSitesOffsetsAfterInstr={360})
    private boolean doAcquireNanos(int var1_1, long var2_2) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=954, methodEnd=978, suspendableCallSites={972}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.parkAndCheckInterrupt()Z"}, suspendableCallSitesOffsetsAfterInstr={258})
    private void doAcquireShared(int var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=987, methodEnd=1008, suspendableCallSites={1002}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.parkAndCheckInterrupt()Z"}, suspendableCallSitesOffsetsAfterInstr={231})
    private void doAcquireSharedInterruptibly(int var1_1) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=1020, methodEnd=1049, suspendableCallSites={1042}, suspendableCallSiteNames={"co/paralleluniverse/strands/Strand.parkNanos(Ljava/lang/Object;J)V"}, suspendableCallSitesOffsetsAfterInstr={366})
    private boolean doAcquireSharedNanos(int var1_1, long var2_2) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=1205, methodEnd=1211, suspendableCallSites={1206}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.acquireQueued(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;I)Z"}, suspendableCallSitesOffsetsAfterInstr={126})
    public final void acquire(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=1231, methodEnd=1238, suspendableCallSites={1234}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.doAcquireInterruptibly(I)V"}, suspendableCallSitesOffsetsAfterInstr={120})
    public final void acquireInterruptibly(int var1_1) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=1261, methodEnd=1266, suspendableCallSites={1264}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.doAcquireNanos(IJ)Z"}, suspendableCallSitesOffsetsAfterInstr={161})
    public final boolean tryAcquireNanos(int var1_1, long var2_2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=1304, methodEnd=1309, suspendableCallSites={1305}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.doAcquireShared(I)V"}, suspendableCallSitesOffsetsAfterInstr={106})
    public final void acquireShared(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=1328, methodEnd=1335, suspendableCallSites={1331}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.doAcquireSharedInterruptibly(I)V"}, suspendableCallSitesOffsetsAfterInstr={120})
    public final void acquireSharedInterruptibly(int var1_1) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=1357, methodEnd=1362, suspendableCallSites={1360}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.doAcquireSharedNanos(IJ)Z"}, suspendableCallSitesOffsetsAfterInstr={161})
    public final boolean tryAcquireSharedNanos(int var1_1, long var2_2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=1734, methodEnd=1746, suspendableCallSites={1745}, suspendableCallSiteNames={"co/paralleluniverse/strands/Strand.yield()V"}, suspendableCallSitesOffsetsAfterInstr={109})
    final boolean transferAfterCancelledWait(Node var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Instrumented
    public class ConditionObject
    implements Condition,
    Serializable {
        private static final long serialVersionUID = 1173984872572414699L;
        private transient Node firstWaiter;
        private transient Node lastWaiter;
        private static final int REINTERRUPT = 1;
        private static final int THROW_IE = -1;

        private Node addConditionWaiter() {
            Node t = this.lastWaiter;
            if (t != null && t.waitStatus != -2) {
                this.unlinkCancelledWaiters();
                t = this.lastWaiter;
            }
            Node node = new Node(Strand.currentStrand(), -2);
            if (t == null) {
                this.firstWaiter = node;
            } else {
                t.nextWaiter = node;
            }
            this.lastWaiter = node;
            return node;
        }

        private void doSignal(Node first) {
            do {
                if ((this.firstWaiter = first.nextWaiter) == null) {
                    this.lastWaiter = null;
                }
                first.nextWaiter = null;
            } while (!AbstractQueuedSynchronizer.this.transferForSignal(first) && (first = this.firstWaiter) != null);
        }

        private void doSignalAll(Node first) {
            Node next;
            this.firstWaiter = null;
            this.lastWaiter = null;
            do {
                next = first.nextWaiter;
                first.nextWaiter = null;
                AbstractQueuedSynchronizer.this.transferForSignal(first);
            } while ((first = next) != null);
        }

        private void unlinkCancelledWaiters() {
            Node t = this.firstWaiter;
            Node trail = null;
            while (t != null) {
                Node next = t.nextWaiter;
                if (t.waitStatus != -2) {
                    t.nextWaiter = null;
                    if (trail == null) {
                        this.firstWaiter = next;
                    } else {
                        trail.nextWaiter = next;
                    }
                    if (next == null) {
                        this.lastWaiter = trail;
                    }
                } else {
                    trail = t;
                }
                t = next;
            }
        }

        @Override
        public final void signal() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node first = this.firstWaiter;
            if (first != null) {
                this.doSignal(first);
            }
        }

        @Override
        public final void signalAll() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node first = this.firstWaiter;
            if (first != null) {
                this.doSignalAll(first);
            }
        }

        private void reportInterruptAfterWait(int interruptMode) throws InterruptedException {
            if (interruptMode == -1) {
                throw new InterruptedException();
            }
            if (interruptMode == 1) {
                AbstractQueuedSynchronizer.selfInterrupt();
            }
        }

        final boolean isOwnedBy(AbstractQueuedSynchronizer sync) {
            return sync == AbstractQueuedSynchronizer.this;
        }

        protected final boolean hasWaiters() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node w = this.firstWaiter;
            while (w != null) {
                if (w.waitStatus == -2) {
                    return true;
                }
                w = w.nextWaiter;
            }
            return false;
        }

        protected final int getWaitQueueLength() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int n = 0;
            Node w = this.firstWaiter;
            while (w != null) {
                if (w.waitStatus == -2) {
                    ++n;
                }
                w = w.nextWaiter;
            }
            return n;
        }

        protected final Collection<Strand> getWaitingStrands() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            ArrayList<Strand> list = new ArrayList<Strand>();
            Node w = this.firstWaiter;
            while (w != null) {
                Strand t;
                if (w.waitStatus == -2 && (t = w.strand) != null) {
                    list.add(t);
                }
                w = w.nextWaiter;
            }
            return list;
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=2012, methodEnd=2025, suspendableCallSites={2016, 2020}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.acquireQueued(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;I)Z", "co/paralleluniverse/strands/Strand.park(Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={161, 283})
        public final void awaitUninterruptibly() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Instrumented(methodOptimized=false, methodStart=2045, methodEnd=2047, suspendableCallSites={2046}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.transferAfterCancelledWait(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;)Z"}, suspendableCallSitesOffsetsAfterInstr={111})
        private int checkInterruptWhileWaiting(Node var1_1) throws SuspendExecution {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=2078, methodEnd=2097, suspendableCallSites={2084, 2085, 2088}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$ConditionObject.checkInterruptWhileWaiting(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;)I", "co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.acquireQueued(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;I)Z", "co/paralleluniverse/strands/Strand.park(Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={179, 274, 393})
        public final void await() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=2116, methodEnd=2141, suspendableCallSites={2124, 2128, 2129, 2133}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$ConditionObject.checkInterruptWhileWaiting(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;)I", "co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.acquireQueued(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;I)Z", "co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.transferAfterCancelledWait(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;)Z", "co/paralleluniverse/strands/Strand.parkNanos(Ljava/lang/Object;J)V"}, suspendableCallSitesOffsetsAfterInstr={251, 389, 518, 683})
        public final long awaitNanos(long var1_1) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=2163, methodEnd=2187, suspendableCallSites={2172, 2175, 2176, 2179}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$ConditionObject.checkInterruptWhileWaiting(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;)I", "co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.acquireQueued(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;I)Z", "co/paralleluniverse/strands/Strand.parkUntil(Ljava/lang/Object;J)V", "co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.transferAfterCancelledWait(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;)Z"}, suspendableCallSitesOffsetsAfterInstr={277, 427, 576, 751})
        public final boolean awaitUntil(Date var1_1) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=2209, methodEnd=2236, suspendableCallSites={2219, 2223, 2224, 2228}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$ConditionObject.checkInterruptWhileWaiting(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;)I", "co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.acquireQueued(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;I)Z", "co/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer.transferAfterCancelledWait(Lco/paralleluniverse/strands/concurrent/AbstractQueuedSynchronizer$Node;)Z", "co/paralleluniverse/strands/Strand.parkNanos(Ljava/lang/Object;J)V"}, suspendableCallSitesOffsetsAfterInstr={319, 514, 696, 917})
        public final boolean await(long var1_1, TimeUnit var3_2) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static final class Node {
        static final Node SHARED = new Node();
        static final Node EXCLUSIVE = null;
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        static final int CONDITION = -2;
        static final int PROPAGATE = -3;
        volatile int waitStatus;
        volatile Node prev;
        volatile Node next;
        volatile Strand strand;
        Node nextWaiter;

        final boolean isShared() {
            return this.nextWaiter == SHARED;
        }

        final Node predecessor() throws NullPointerException {
            Node p = this.prev;
            if (p == null) {
                throw new NullPointerException();
            }
            return p;
        }

        Node() {
        }

        Node(Strand strand, Node mode) {
            this.nextWaiter = mode;
            this.strand = strand;
        }

        Node(Strand strand, int waitStatus) {
            this.waitStatus = waitStatus;
            this.strand = strand;
        }
    }
}

