/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.concurrent;

import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.concurrent.AbstractQueuedSynchronizer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -6992448646407690164L;
    private final ReadLock readerLock;
    private final WriteLock writerLock;
    final Sync sync;

    public ReentrantReadWriteLock() {
        this(false);
    }

    public ReentrantReadWriteLock(boolean fair) {
        this.sync = fair ? new FairSync() : new NonfairSync();
        this.readerLock = new ReadLock(this);
        this.writerLock = new WriteLock(this);
    }

    @Override
    public WriteLock writeLock() {
        return this.writerLock;
    }

    @Override
    public ReadLock readLock() {
        return this.readerLock;
    }

    public final boolean isFair() {
        return this.sync instanceof FairSync;
    }

    protected Strand getOwner() {
        return this.sync.getOwner();
    }

    public int getReadLockCount() {
        return this.sync.getReadLockCount();
    }

    public boolean isWriteLocked() {
        return this.sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentStrand() {
        return this.sync.isHeldExclusively();
    }

    public int getWriteHoldCount() {
        return this.sync.getWriteHoldCount();
    }

    public int getReadHoldCount() {
        return this.sync.getReadHoldCount();
    }

    protected Collection<Strand> getQueuedWriterStrands() {
        return this.sync.getExclusiveQueuedStrands();
    }

    protected Collection<Strand> getQueuedReaderStrands() {
        return this.sync.getSharedQueuedStrands();
    }

    public final boolean hasQueuedStrands() {
        return this.sync.hasQueuedStrands();
    }

    public final boolean hasQueuedStrand(Strand strand) {
        return this.sync.isQueued(strand);
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection<Strand> getQueuedStrands() {
        return this.sync.getQueuedStrands();
    }

    public boolean hasWaiters(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.hasWaiters((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public int getWaitQueueLength(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitQueueLength((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    protected Collection<Strand> getWaitingStrands(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitingStrands((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public String toString() {
        int c = this.sync.getCount();
        int w = Sync.exclusiveCount(c);
        int r = Sync.sharedCount(c);
        return super.toString() + "[Write locks = " + w + ", Read locks = " + r + "]";
    }

    @Instrumented
    public static class WriteLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -4992448646407690164L;
        private final Sync sync;

        protected WriteLock(ReentrantReadWriteLock lock) {
            this.sync = lock.sync;
        }

        @Override
        public boolean tryLock() {
            return this.sync.tryWriteLock();
        }

        @Override
        public void unlock() {
            this.sync.release(1);
        }

        @Override
        public Condition newCondition() {
            return this.sync.newCondition();
        }

        public String toString() {
            Strand o = this.sync.getOwner();
            return super.toString() + (String)(o == null ? "[Unlocked]" : "[Locked by strand " + o.getName() + "]");
        }

        public boolean isHeldByCurrentStrand() {
            return this.sync.isHeldExclusively();
        }

        public int getHoldCount() {
            return this.sync.getWriteHoldCount();
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=941, methodEnd=942, suspendableCallSites={941}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/ReentrantReadWriteLock$Sync.acquire(I)V"}, suspendableCallSitesOffsetsAfterInstr={87})
        public void lock() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=997, methodEnd=998, suspendableCallSites={997}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/ReentrantReadWriteLock$Sync.acquireInterruptibly(I)V"}, suspendableCallSitesOffsetsAfterInstr={87})
        public void lockInterruptibly() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=1113, methodEnd=1113, suspendableCallSites={1113}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/ReentrantReadWriteLock$Sync.tryAcquireNanos(IJ)Z"}, suspendableCallSitesOffsetsAfterInstr={149})
        public boolean tryLock(long var1_1, TimeUnit var3_2) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @Instrumented
    public static class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -5992448646407690164L;
        private final Sync sync;

        protected ReadLock(ReentrantReadWriteLock lock) {
            this.sync = lock.sync;
        }

        @Override
        public boolean tryLock() {
            return this.sync.tryReadLock();
        }

        @Override
        public void unlock() {
            this.sync.releaseShared(1);
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            int r = this.sync.getReadLockCount();
            return super.toString() + "[Read locks = " + r + "]";
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=724, methodEnd=725, suspendableCallSites={724}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/ReentrantReadWriteLock$Sync.acquireShared(I)V"}, suspendableCallSitesOffsetsAfterInstr={87})
        public void lock() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=770, methodEnd=771, suspendableCallSites={770}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/ReentrantReadWriteLock$Sync.acquireSharedInterruptibly(I)V"}, suspendableCallSitesOffsetsAfterInstr={87})
        public void lockInterruptibly() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=868, methodEnd=868, suspendableCallSites={868}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/ReentrantReadWriteLock$Sync.tryAcquireSharedNanos(IJ)Z"}, suspendableCallSitesOffsetsAfterInstr={149})
        public boolean tryLock(long var1_1, TimeUnit var3_2) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = -2274990926593161451L;

        FairSync() {
        }

        @Override
        final boolean writerShouldBlock() {
            return this.hasQueuedPredecessors();
        }

        @Override
        final boolean readerShouldBlock() {
            return this.hasQueuedPredecessors();
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -8159625535654395037L;

        NonfairSync() {
        }

        @Override
        final boolean writerShouldBlock() {
            return false;
        }

        @Override
        final boolean readerShouldBlock() {
            return this.apparentlyFirstQueuedIsExclusive();
        }
    }

    @Instrumented
    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 6317671515068378041L;
        static final int SHARED_SHIFT = 16;
        static final int SHARED_UNIT = 65536;
        static final int MAX_COUNT = 65535;
        static final int EXCLUSIVE_MASK = 65535;
        private transient StrandLocalHoldCounter readHolds = new StrandLocalHoldCounter();
        private transient HoldCounter cachedHoldCounter;
        private transient Strand firstReader = null;
        private transient int firstReaderHoldCount;

        static int sharedCount(int c) {
            return c >>> 16;
        }

        static int exclusiveCount(int c) {
            return c & 0xFFFF;
        }

        Sync() {
            this.setState(this.getState());
        }

        abstract boolean readerShouldBlock();

        abstract boolean writerShouldBlock();

        @Override
        protected final boolean tryRelease(int releases) {
            boolean free;
            if (!this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int nextc = this.getState() - releases;
            boolean bl = free = Sync.exclusiveCount(nextc) == 0;
            if (free) {
                this.setExclusiveOwnerStrand(null);
            }
            this.setState(nextc);
            return free;
        }

        @Override
        protected final boolean tryAcquire(int acquires) {
            Strand current = Strand.currentStrand();
            int c = this.getState();
            int w = Sync.exclusiveCount(c);
            if (c != 0) {
                if (w == 0 || current != this.getExclusiveOwnerStrand()) {
                    return false;
                }
                if (w + Sync.exclusiveCount(acquires) > 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
                this.setState(c + acquires);
                return true;
            }
            if (this.writerShouldBlock() || !this.compareAndSetState(c, c + acquires)) {
                return false;
            }
            this.setExclusiveOwnerStrand(current);
            return true;
        }

        @Override
        protected final boolean tryReleaseShared(int unused) {
            int nextc;
            int c;
            Strand current = Strand.currentStrand();
            if (this.firstReader == current) {
                if (this.firstReaderHoldCount == 1) {
                    this.firstReader = null;
                } else {
                    --this.firstReaderHoldCount;
                }
            } else {
                int count;
                HoldCounter rh = this.cachedHoldCounter;
                if (rh == null || rh.tid != current.getId()) {
                    rh = (HoldCounter)this.readHolds.get();
                }
                if ((count = rh.count) <= 1) {
                    this.readHolds.remove();
                    if (count <= 0) {
                        throw this.unmatchedUnlockException();
                    }
                }
                --rh.count;
            }
            while (!this.compareAndSetState(c = this.getState(), nextc = c - 65536)) {
            }
            return nextc == 0;
        }

        private IllegalMonitorStateException unmatchedUnlockException() {
            return new IllegalMonitorStateException("attempt to unlock read lock, not locked by current strand");
        }

        @Override
        protected final int tryAcquireShared(int unused) {
            Strand current = Strand.currentStrand();
            int c = this.getState();
            if (Sync.exclusiveCount(c) != 0 && this.getExclusiveOwnerStrand() != current) {
                return -1;
            }
            int r = Sync.sharedCount(c);
            if (!this.readerShouldBlock() && r < 65535 && this.compareAndSetState(c, c + 65536)) {
                if (r == 0) {
                    this.firstReader = current;
                    this.firstReaderHoldCount = 1;
                } else if (this.firstReader == current) {
                    ++this.firstReaderHoldCount;
                } else {
                    HoldCounter rh = this.cachedHoldCounter;
                    if (rh == null || rh.tid != current.getId()) {
                        this.cachedHoldCounter = rh = (HoldCounter)this.readHolds.get();
                    } else if (rh.count == 0) {
                        this.readHolds.set(rh);
                    }
                    ++rh.count;
                }
                return 1;
            }
            return this.fullTryAcquireShared(current);
        }

        final int fullTryAcquireShared(Strand current) {
            int c;
            HoldCounter rh = null;
            do {
                if (Sync.exclusiveCount(c = this.getState()) != 0) {
                    if (this.getExclusiveOwnerStrand() != current) {
                        return -1;
                    }
                } else if (this.readerShouldBlock() && this.firstReader != current) {
                    if (rh == null && ((rh = this.cachedHoldCounter) == null || rh.tid != current.getId())) {
                        rh = (HoldCounter)this.readHolds.get();
                        if (rh.count == 0) {
                            this.readHolds.remove();
                        }
                    }
                    if (rh.count == 0) {
                        return -1;
                    }
                }
                if (Sync.sharedCount(c) != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(c, c + 65536));
            if (Sync.sharedCount(c) == 0) {
                this.firstReader = current;
                this.firstReaderHoldCount = 1;
            } else if (this.firstReader == current) {
                ++this.firstReaderHoldCount;
            } else {
                if (rh == null) {
                    rh = this.cachedHoldCounter;
                }
                if (rh == null || rh.tid != current.getId()) {
                    rh = (HoldCounter)this.readHolds.get();
                } else if (rh.count == 0) {
                    this.readHolds.set(rh);
                }
                ++rh.count;
                this.cachedHoldCounter = rh;
            }
            return 1;
        }

        final boolean tryWriteLock() {
            Strand current = Strand.currentStrand();
            int c = this.getState();
            if (c != 0) {
                int w = Sync.exclusiveCount(c);
                if (w == 0 || current != this.getExclusiveOwnerStrand()) {
                    return false;
                }
                if (w == 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
            }
            if (!this.compareAndSetState(c, c + 1)) {
                return false;
            }
            this.setExclusiveOwnerStrand(current);
            return true;
        }

        final boolean tryReadLock() {
            int r;
            int c;
            Strand current = Strand.currentStrand();
            do {
                if (Sync.exclusiveCount(c = this.getState()) != 0 && this.getExclusiveOwnerStrand() != current) {
                    return false;
                }
                r = Sync.sharedCount(c);
                if (r != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(c, c + 65536));
            if (r == 0) {
                this.firstReader = current;
                this.firstReaderHoldCount = 1;
            } else if (this.firstReader == current) {
                ++this.firstReaderHoldCount;
            } else {
                HoldCounter rh = this.cachedHoldCounter;
                if (rh == null || rh.tid != current.getId()) {
                    this.cachedHoldCounter = rh = (HoldCounter)this.readHolds.get();
                } else if (rh.count == 0) {
                    this.readHolds.set(rh);
                }
                ++rh.count;
            }
            return true;
        }

        @Override
        protected final boolean isHeldExclusively() {
            return this.getExclusiveOwnerStrand() == Strand.currentStrand();
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject();
        }

        final Strand getOwner() {
            return Sync.exclusiveCount(this.getState()) == 0 ? null : this.getExclusiveOwnerStrand();
        }

        final int getReadLockCount() {
            return Sync.sharedCount(this.getState());
        }

        final boolean isWriteLocked() {
            return Sync.exclusiveCount(this.getState()) != 0;
        }

        final int getWriteHoldCount() {
            return this.isHeldExclusively() ? Sync.exclusiveCount(this.getState()) : 0;
        }

        final int getReadHoldCount() {
            if (this.getReadLockCount() == 0) {
                return 0;
            }
            Strand current = Strand.currentStrand();
            if (this.firstReader == current) {
                return this.firstReaderHoldCount;
            }
            HoldCounter rh = this.cachedHoldCounter;
            if (rh != null && rh.tid == current.getId()) {
                return rh.count;
            }
            int count = ((HoldCounter)this.readHolds.get()).count;
            if (count == 0) {
                this.readHolds.remove();
            }
            return count;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.readHolds = new StrandLocalHoldCounter();
            this.setState(0);
        }

        final int getCount() {
            return this.getState();
        }

        static final class StrandLocalHoldCounter
        extends ThreadLocal<HoldCounter> {
            StrandLocalHoldCounter() {
            }

            @Override
            public HoldCounter initialValue() {
                return new HoldCounter();
            }
        }

        static final class HoldCounter {
            int count = 0;
            final long tid = Strand.currentStrand().getId();

            HoldCounter() {
            }
        }
    }
}

