/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.CircularBuffer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public class CircularObjectBuffer<E>
extends CircularBuffer<E> {
    private final Object[] array;
    private static final VarHandle ARRAY = MethodHandles.arrayElementVarHandle(Object[].class);

    public CircularObjectBuffer(int size, boolean singleProducer) {
        super(size, singleProducer);
        this.array = new Object[this.capacity];
    }

    @Override
    public boolean enq(E elem) {
        long index = this.preEnq();
        this.orderedSet((int)index & this.mask, elem);
        this.postEnq();
        return true;
    }

    @Override
    public CircularBuffer.Consumer newConsumer() {
        return new ObjectConsumer();
    }

    private void orderedSet(int i, Object value) {
        ARRAY.setOpaque(this.array, i, value);
    }

    private class ObjectConsumer
    extends CircularBuffer.Consumer {
        private Object value;

        private ObjectConsumer() {
            super(CircularObjectBuffer.this);
        }

        @Override
        protected void grabValue(int index) {
            this.value = CircularObjectBuffer.this.array[index];
        }

        @Override
        protected void clearValue() {
            this.value = null;
        }

        @Override
        protected E getValue() {
            return this.value;
        }
    }
}

