/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.CircularBuffer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

abstract class CircularWordBuffer<E>
extends CircularBuffer<E> {
    private final int[] array;
    private static final VarHandle ARRAY = MethodHandles.arrayElementVarHandle(int[].class);

    public CircularWordBuffer(int size, boolean singleProducer) {
        super(size, singleProducer);
        this.array = new int[this.capacity];
    }

    void enqRaw(int elem) {
        long index = this.preEnq();
        this.orderedSet((int)index & this.mask, elem);
        this.postEnq();
    }

    private void orderedSet(int i, int value) {
        ARRAY.setOpaque(this.array, i, value);
    }

    abstract class WordConsumer
    extends CircularBuffer.Consumer {
        private int value;

        WordConsumer() {
        }

        @Override
        protected void grabValue(int index) {
            this.value = CircularWordBuffer.this.array[index];
        }

        @Override
        protected void clearValue() {
        }

        int getRawValue() {
            return this.value;
        }
    }
}

