/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.BasicSingleConsumerDoubleQueue;
import co.paralleluniverse.strands.queues.DoubleQueueIterator;
import co.paralleluniverse.strands.queues.SingleConsumerArrayDWordQueue;
import co.paralleluniverse.strands.queues.SingleConsumerArrayQueue;

public class SingleConsumerArrayDoubleQueue
extends SingleConsumerArrayDWordQueue<Double>
implements BasicSingleConsumerDoubleQueue {
    public SingleConsumerArrayDoubleQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean enq(double item) {
        return this.enqRaw(Double.doubleToRawLongBits(item));
    }

    @Override
    public boolean enq(Double item) {
        if (item == null) {
            throw new IllegalArgumentException("null values not allowed");
        }
        return this.enq((double)item);
    }

    double doubleValue(int index) {
        return Double.longBitsToDouble(this.rawValue(index));
    }

    @Override
    Double value(int index) {
        return this.doubleValue(index);
    }

    @Override
    public double pollDouble() {
        int n = this.pk();
        double val = this.doubleValue(n);
        this.deq(n);
        return val;
    }

    @Override
    public DoubleQueueIterator iterator() {
        return new DoubleArrayQueueIterator();
    }

    private class DoubleArrayQueueIterator
    extends SingleConsumerArrayQueue.ArrayQueueIterator
    implements DoubleQueueIterator {
        private DoubleArrayQueueIterator() {
        }

        @Override
        public double doubleValue() {
            return SingleConsumerArrayDoubleQueue.this.doubleValue(this.n);
        }

        @Override
        public double doubleNext() {
            this.n = SingleConsumerArrayDoubleQueue.this.succ(this.n);
            return this.doubleValue();
        }
    }
}

