/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.SingleConsumerArrayQueue;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public class SingleConsumerArrayObjectQueue<E>
extends SingleConsumerArrayQueue<E> {
    private final Object[] array;
    private static final VarHandle ARRAY = MethodHandles.arrayElementVarHandle(Object[].class);

    public SingleConsumerArrayObjectQueue(int size) {
        super(size);
        this.array = new Object[this.capacity];
    }

    @Override
    public E value(int index) {
        return (E)this.array[index];
    }

    @Override
    int arrayLength() {
        return this.array.length;
    }

    @Override
    public boolean enq(E item) {
        if (item == null) {
            throw new IllegalArgumentException("null values not allowed");
        }
        long i = this.preEnq();
        if (i < 0L) {
            return false;
        }
        this.volatileSet((int)i & this.mask, item);
        return true;
    }

    @Override
    boolean hasNext(long lind, int iind) {
        return this.get(iind) != null;
    }

    @Override
    void awaitValue(long i) {
        while (this.get((int)i & this.mask) == null) {
        }
    }

    @Override
    void clearValue(int index) {
        this.array[index] = null;
    }

    @Override
    void copyValue(int to, int from) {
        this.array[to] = this.array[from];
    }

    private void volatileSet(int i, Object value) {
        ARRAY.setVolatile(this.array, i, value);
    }

    private void orderedSet(int i, Object value) {
        ARRAY.setOpaque(this.array, i, value);
    }

    private Object get(int i) {
        return ARRAY.getVolatile(this.array, i);
    }
}

