/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.util.Objects;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedArrayQueue;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;

public class SingleConsumerLinkedArrayObjectQueue<E>
extends SingleConsumerLinkedArrayQueue<E> {
    public static final int BLOCK_SIZE = 10;
    private static final Object TOMBSTONE = new Object();
    private static final VarHandle ARRAY = MethodHandles.arrayElementVarHandle(Object[].class);

    @Override
    SingleConsumerLinkedArrayQueue.Node newNode() {
        return new ObjectNode();
    }

    @Override
    int blockSize() {
        return 10;
    }

    @Override
    public boolean enq(E item) {
        SingleConsumerLinkedArrayQueue.Node n = null;
        while (true) {
            SingleConsumerLinkedArrayQueue.Node t = this.tail;
            for (int i = 0; i < 10; ++i) {
                if (SingleConsumerLinkedArrayObjectQueue.get(t, i) != null || !SingleConsumerLinkedArrayObjectQueue.compareAndSetElement(t, i, null, item)) continue;
                return true;
            }
            if (n == null) {
                n = this.newNode();
                SingleConsumerLinkedArrayObjectQueue.set(n, 0, item);
            }
            n.prev = t;
            if (this.compareAndSetTail(t, n)) {
                t.next = n;
                return true;
            }
            this.backoff();
        }
    }

    @Override
    E value(SingleConsumerLinkedArrayQueue.Node n, int i) {
        return (E)((ObjectNode)n).array[i];
    }

    @Override
    boolean hasValue(SingleConsumerLinkedArrayQueue.Node n, int index) {
        return SingleConsumerLinkedArrayObjectQueue.get(n, index) != null;
    }

    @Override
    boolean isDeleted(SingleConsumerLinkedArrayQueue.Node n, int index) {
        return ((ObjectNode)n).array[index] == TOMBSTONE;
    }

    @Override
    void markDeleted(SingleConsumerLinkedArrayQueue.Node n, int index) {
        ((ObjectNode)n).array[index] = TOMBSTONE;
    }

    private static boolean compareAndSetElement(SingleConsumerLinkedArrayQueue.Node n, int i, Object expect, Object update) {
        return ARRAY.compareAndSet(((ObjectNode)n).array, i, expect, update);
    }

    private static void lazySet(SingleConsumerLinkedArrayQueue.Node n, int i, Object value) {
        ARRAY.setOpaque(((ObjectNode)n).array, i, value);
    }

    private static Object get(SingleConsumerLinkedArrayQueue.Node n, int i) {
        return ARRAY.getVolatile(((ObjectNode)n).array, i);
    }

    private static void set(SingleConsumerLinkedArrayQueue.Node n, int i, Object x) {
        ((ObjectNode)n).array[i] = x;
    }

    static class ObjectNode
    extends SingleConsumerLinkedArrayQueue.Node {
        final Object[] array = new Object[10];

        ObjectNode() {
        }

        public String toString() {
            return "Node{array: " + Arrays.toString(this.array) + ", next: " + this.next + ", prev: " + Objects.systemToString(this.prev) + "}";
        }
    }
}

