/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.util.Objects;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedQueue;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public class SingleConsumerLinkedObjectQueue<E>
extends SingleConsumerLinkedQueue<E> {
    private static final VarHandle VALUE;

    @Override
    SingleConsumerLinkedQueue.Node<E> newNode() {
        return new ObjectNode();
    }

    @Override
    public boolean enq(E item) {
        if (item == null) {
            throw new IllegalArgumentException("null values not allowed");
        }
        ObjectNode node = new ObjectNode();
        node.value = item;
        return this.enq((E)node);
    }

    @Override
    E value(SingleConsumerLinkedQueue.Node<E> node) {
        return ((ObjectNode)node).value;
    }

    @Override
    void clearValue(SingleConsumerLinkedQueue.Node node) {
        VALUE.setOpaque(node, null);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            VALUE = l.findVarHandle(ObjectNode.class, "value", Object.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static class ObjectNode<E>
    extends SingleConsumerLinkedQueue.Node<E> {
        E value;

        ObjectNode() {
        }

        public String toString() {
            return "Node{value: " + this.value + ", next: " + this.next + ", prev: " + Objects.systemToString(this.prev) + "}";
        }
    }
}

