/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.kotlin;

import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.SimpleSuspendableClassifier;
import co.paralleluniverse.fibers.instrument.SuspendableClassifier;
import java.util.ArrayList;

public class KotlinClassifier
implements SuspendableClassifier {
    private static final String PKG_PREFIX = "kotlin";
    private static final String[][] supers;
    private static final String[] excludePrefixes;

    public MethodDatabase.SuspendableType isSuspendable(MethodDatabase db, String sourceName, String sourceDebugInfo, boolean isInterface, String className, String superClassName, String[] interfaces, String methodName, String methodDesc, String methodSignature, String[] methodExceptions) {
        int i;
        if (className == null) {
            return null;
        }
        for (String[] stringArray : supers) {
            if (!className.equals(stringArray[0])) continue;
            for (i = 1; i < stringArray.length; ++i) {
                if (methodName == null || !methodName.matches(stringArray[i])) continue;
                if (db.isVerbose()) {
                    db.getLog().log(LogLevel.INFO, KotlinClassifier.class.getName() + ": " + className + "." + methodName + " supersOrEqual " + stringArray[0] + "." + stringArray[i], new Object[0]);
                }
                return MethodDatabase.SuspendableType.SUSPENDABLE_SUPER;
            }
        }
        if (!(className.startsWith(PKG_PREFIX) || className.contains("$") && sourceName != null && sourceName.toLowerCase().endsWith(".kt"))) {
            return null;
        }
        for (String[] stringArray : excludePrefixes) {
            if (!className.startsWith((String)stringArray)) continue;
            return null;
        }
        for (String[] stringArray : supers) {
            if (!SimpleSuspendableClassifier.extendsOrImplements((String)stringArray[0], (MethodDatabase)db, (String)className, (String)superClassName, (String[])interfaces)) continue;
            for (i = 1; i < stringArray.length; ++i) {
                if (methodName == null || !methodName.matches(stringArray[i])) continue;
                if (db.isVerbose()) {
                    db.getLog().log(LogLevel.INFO, KotlinClassifier.class.getName() + ": " + className + "." + methodName + " extends " + stringArray[0] + "." + stringArray[i], new Object[0]);
                }
                return MethodDatabase.SuspendableType.SUSPENDABLE;
            }
        }
        if (methodName != null && methodName.contains("access$")) {
            return MethodDatabase.SuspendableType.SUSPENDABLE;
        }
        return null;
    }

    private static String[] sa(String ... elems) {
        return elems;
    }

    static {
        ArrayList<String[]> supersList = new ArrayList<String[]>();
        supersList.add(KotlinClassifier.sa("kotlin/reflect/KCallable", "call", "callBy"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/full/KCallable", "call", "callBy"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/KProperty0", "get"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/full/KProperty0", "get"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/KMutableProperty0", "set"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/full/KMutableProperty0", "set"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/KProperty1", "get"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/full/KProperty1", "get"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/KMutableProperty1", "set"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/full/KMutableProperty1", "set"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/KProperty2", "get"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/full/KProperty2", "get"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/KMutableProperty2", "set"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/full/KMutableProperty2", "set"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/KObservableProperty", "beforeChange", "afterChange"));
        supersList.add(KotlinClassifier.sa("kotlin/reflect/full/KObservableProperty", "beforeChange", "afterChange"));
        supersList.add(KotlinClassifier.sa("kotlin/properties/ObservableProperty", "beforeChange", "afterChange"));
        supersList.add(KotlinClassifier.sa("kotlin/properties/ReadWriteProperty", "getValue", "setValue"));
        supersList.add(KotlinClassifier.sa("kotlin/Lazy", "getValue"));
        for (int i = 0; i <= 22; ++i) {
            supersList.add(KotlinClassifier.sa("kotlin/jvm/functions/Function" + i, "invoke"));
        }
        supersList.add(KotlinClassifier.sa("co/paralleluniverse/strands/SuspendableCallable", "run"));
        supersList.add(KotlinClassifier.sa("co/paralleluniverse/strands/SuspendableRunnable", "run"));
        supers = (String[][])supersList.toArray((T[])new String[0][0]);
        excludePrefixes = new String[]{"kotlin/reflect/jvm/internal/impl/descriptors/impl/ModuleDescriptorImpl", "org/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl"};
    }
}

