/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.channels.reactivestreams;

import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Condition;
import co.paralleluniverse.strands.OwnedSynchronizer;
import co.paralleluniverse.strands.SuspendableCallable;
import co.paralleluniverse.strands.channels.ReceivePort;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Instrumented
class ChannelSubscription<T>
implements Subscription,
SuspendableCallable<Void> {
    private final ReceivePort<T> ch;
    private final Subscriber<? super T> s;
    private final Condition sync = new OwnedSynchronizer((Object)this);
    private volatile boolean cancelled;
    private volatile Throwable error;
    private final AtomicLong requested = new AtomicLong();

    public ChannelSubscription(Subscriber<? super T> s, ReceivePort<T> ch) {
        if (s == null) {
            throw new NullPointerException();
        }
        this.s = s;
        this.ch = ch;
    }

    public void request(long n) {
        if (this.cancelled) {
            return;
        }
        if (n <= 0L) {
            this.cancel(new IllegalArgumentException("Requested number must not be > 0 (#3.9) but was " + n));
        } else {
            long res = this.requested.addAndGet(n);
            if (n == Long.MAX_VALUE || res < 0L && n > 0L) {
                this.requested.set(-1L);
                this.sync.signal();
            } else if (res == n) {
                this.sync.signal();
            }
        }
    }

    private void cancel(Throwable error) {
        if (error != null) {
            this.error = error;
        } else {
            this.cancelled = true;
        }
        this.requested.set(-1L);
        this.ch.close();
        this.sync.signal();
    }

    private boolean checkCancelled() throws Throwable {
        if (this.error != null) {
            throw this.error;
        }
        return this.cancelled;
    }

    public void cancel() {
        this.cancel(null);
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=81, methodEnd=85, suspendableCallSites={82}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/ReceivePort.receive()Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={88})
    private boolean checkClosed() throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=97, methodEnd=119, suspendableCallSites={100, 101, 104, 107}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/reactivestreams/ChannelSubscription.checkClosed()Z", "co/paralleluniverse/strands/channels/ReceivePort.receive()Ljava/lang/Object;", "co/paralleluniverse/strands/channels/reactivestreams/ChannelSubscription.getRequested(JLjava/util/concurrent/TimeUnit;)J", "org/reactivestreams/Subscriber.onNext(Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={140, 189, 259, 347})
    public Void run() throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=123, methodEnd=145, suspendableCallSites={133}, suspendableCallSiteNames={"co/paralleluniverse/strands/Condition.await(IJLjava/util/concurrent/TimeUnit;)V"}, suspendableCallSitesOffsetsAfterInstr={312})
    private long getRequested(long var1_1, TimeUnit var3_2) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

