/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import co.prado.ads.banners.PradoBannerAdCallback;
import co.prado.ads.banners.PradoBannerView;
import co.prado.ads.fullscreen.interstitial.PradoInterstitialAd;
import co.prado.ads.fullscreen.interstitial.PradoInterstitialAdCallback;
import co.prado.ads.fullscreen.rewarded.PradoRewardedAd;
import co.prado.ads.fullscreen.rewarded.PradoRewardedAdCallback;
import co.prado.mediation.applovin.PradoSDKInfo;
import co.prado.sdk.Prado;
import co.prado.sdk.PradoError;
import co.prado.sdk.PradoInitializationListener;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;

public class PradoMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    public static final String TAG = PradoMediationAdapter.class.getSimpleName();
    private PradoInterstitialAd interstitialAd;
    private PradoRewardedAd rewardedAd;
    private PradoBannerView mPradoBanner;

    public PradoMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
        Log.d((String)TAG, (String)"constructor");
    }

    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        Log.d((String)TAG, (String)"initialize");
        onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS, null);
    }

    private void onSDKInitialized(Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        activity.runOnUiThread(() -> onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, ""));
    }

    public String getSdkVersion() {
        return PradoSDKInfo.getPradoSDKVersion();
    }

    public String getAdapterVersion() {
        return PradoSDKInfo.getMediationAdapterVersion();
    }

    public void onDestroy() {
        Log.d((String)TAG, (String)"onDestroy");
        this.interstitialAd = null;
        this.rewardedAd = null;
        if (this.mPradoBanner != null) {
            this.mPradoBanner.close();
        }
        this.mPradoBanner = null;
    }

    private void initPradoSDK(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, PradoInitializationListener listener) {
        Bundle serverParameters = maxAdapterResponseParameters.getServerParameters().getBundle("custom_parameters");
        if (serverParameters != null && !TextUtils.isEmpty((CharSequence)serverParameters.getString("publisher_id")) && !TextUtils.isEmpty((CharSequence)serverParameters.getString("token"))) {
            String publisherID = serverParameters.getString("publisher_id");
            String token = serverParameters.getString("token");
            Prado.setExtension((String)"max", (String)PradoSDKInfo.getMediationAdapterVersion());
            Prado.initialize((Context)activity, (String)publisherID, (String)token, (PradoInitializationListener)listener);
        } else {
            listener.onInitError(new PradoError(1000, "Missing Prado publisherId and token"));
        }
    }

    public void loadAdViewAd(final MaxAdapterResponseParameters maxAdapterResponseParameters, final MaxAdFormat maxAdFormat, final Activity activity, final MaxAdViewAdapterListener maxAdViewAdapterListener) {
        activity.runOnUiThread(() -> {
            if (Prado.isInitialized()) {
                Log.d((String)TAG, (String)"loadBanner SDK initialized");
                this.mPradoBanner = new PradoBannerView((Context)activity);
                this.mPradoBanner.setLayoutWithoutShowing();
                this.mPradoBanner.setBannerCallback(new PradoBannerAdCallback(){

                    public void onAdLoaded() {
                        Log.d((String)TAG, (String)"Banner onAdLoaded");
                        maxAdViewAdapterListener.onAdViewAdLoaded((View)PradoMediationAdapter.this.mPradoBanner);
                    }

                    public void onAdFailedToLoad(PradoError error) {
                        Log.d((String)TAG, (String)("Banner onAdFailedToLoad:: " + error.toString()));
                        maxAdViewAdapterListener.onAdViewAdLoadFailed(new MaxAdapterError(error.getCode(), error.getMessage()));
                    }

                    public void onAdShown() {
                        Log.d((String)TAG, (String)"Banner onAdShown");
                        maxAdViewAdapterListener.onAdViewAdDisplayed();
                    }

                    public void onAdFailedToShow(PradoError error) {
                        Log.d((String)TAG, (String)("Banner onAdFailedToShow:: " + error.toString()));
                        maxAdViewAdapterListener.onAdViewAdDisplayFailed(new MaxAdapterError(error.getCode(), error.getMessage()));
                    }

                    public void onAdImpression() {
                        Log.d((String)TAG, (String)"Banner onAdImpression");
                    }

                    public void onAdClosed() {
                        Log.d((String)TAG, (String)"Banner onAdClosed");
                        maxAdViewAdapterListener.onAdViewAdHidden();
                    }
                });
                this.mPradoBanner.load();
            } else {
                Log.d((String)TAG, (String)"loadBanner initializing SDK");
                this.initPradoSDK(maxAdapterResponseParameters, activity, new PradoInitializationListener(){

                    public void onInitSuccess() {
                        Log.d((String)TAG, (String)"loadBanner onInitSuccess");
                        PradoMediationAdapter.this.loadAdViewAd(maxAdapterResponseParameters, maxAdFormat, activity, maxAdViewAdapterListener);
                    }

                    public void onInitError(PradoError error) {
                        Log.d((String)TAG, (String)("Failed to init SDK::" + error));
                        maxAdViewAdapterListener.onAdViewAdLoadFailed(new MaxAdapterError(-5204, error.getMessage()));
                    }
                });
            }
        });
    }

    public void loadInterstitialAd(final MaxAdapterResponseParameters maxAdapterResponseParameters, final Activity activity, final MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        if (Prado.isInitialized()) {
            Log.d((String)TAG, (String)"loadInterstitialAd SDK initialized");
            PradoInterstitialAd.load((Activity)activity, (PradoInterstitialAdCallback)new PradoInterstitialAdCallback(){

                public void onAdLoaded(PradoInterstitialAd ad) {
                    Log.d((String)TAG, (String)"Interstitial onAdLoaded");
                    PradoMediationAdapter.this.interstitialAd = ad;
                    maxInterstitialAdapterListener.onInterstitialAdLoaded();
                }

                public void onAdFailedToLoad(PradoError error) {
                    Log.d((String)TAG, (String)("Interstitial onAdFailedToLoad:: " + error.toString()));
                    maxInterstitialAdapterListener.onInterstitialAdLoadFailed(new MaxAdapterError(error.getCode(), error.getMessage()));
                }

                public void onAdShown(PradoInterstitialAd ad) {
                    Log.d((String)TAG, (String)"Interstitial onAdShown");
                    maxInterstitialAdapterListener.onInterstitialAdDisplayed();
                }

                public void onAdFailedToShow(PradoInterstitialAd ad, PradoError error) {
                    Log.d((String)TAG, (String)("Interstitial onAdFailedToShow:: " + error.toString()));
                    maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(new MaxAdapterError(error.getCode(), error.getMessage()));
                }

                public void onAdImpression(PradoInterstitialAd ad) {
                    Log.d((String)TAG, (String)"Interstitial onAdImpression");
                }

                public void onAdClosed(PradoInterstitialAd ad) {
                    Log.d((String)TAG, (String)"Interstitial onAdClosed");
                    maxInterstitialAdapterListener.onInterstitialAdHidden();
                }
            });
        } else {
            Log.d((String)TAG, (String)"loadInterstitialAd initializing SDK");
            this.initPradoSDK(maxAdapterResponseParameters, activity, new PradoInitializationListener(){

                public void onInitSuccess() {
                    PradoMediationAdapter.this.loadInterstitialAd(maxAdapterResponseParameters, activity, maxInterstitialAdapterListener);
                }

                public void onInitError(PradoError error) {
                    Log.d((String)TAG, (String)("Failed to init SDK::" + error));
                    maxInterstitialAdapterListener.onInterstitialAdLoadFailed(new MaxAdapterError(-5204, error.getMessage()));
                }
            });
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        if (Prado.isInitialized() && this.interstitialAd != null) {
            if (this.interstitialAd.isLoaded()) {
                this.interstitialAd.show();
            } else {
                maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
            }
        } else {
            maxInterstitialAdapterListener.onInterstitialAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
        }
    }

    public void loadRewardedAd(final MaxAdapterResponseParameters maxAdapterResponseParameters, final Activity activity, final MaxRewardedAdapterListener maxRewardedAdapterListener) {
        if (Prado.isInitialized()) {
            Log.d((String)TAG, (String)"loadRewardedAd SDK initialized");
            PradoRewardedAd.load((Activity)activity, (PradoRewardedAdCallback)new PradoRewardedAdCallback(){

                public void onAdLoaded(PradoRewardedAd ad) {
                    Log.d((String)TAG, (String)"Rewarded onAdLoaded");
                    PradoMediationAdapter.this.rewardedAd = ad;
                    maxRewardedAdapterListener.onRewardedAdLoaded();
                }

                public void onAdFailedToLoad(PradoError error) {
                    Log.d((String)TAG, (String)("Rewarded onAdFailedToLoad:: " + error.toString()));
                    maxRewardedAdapterListener.onRewardedAdLoadFailed(new MaxAdapterError(error.getCode(), error.getMessage()));
                }

                public void onAdShown(PradoRewardedAd ad) {
                    Log.d((String)TAG, (String)"Rewarded onAdShown");
                    maxRewardedAdapterListener.onRewardedAdDisplayed();
                }

                public void onAdFailedToShow(PradoRewardedAd ad, PradoError error) {
                    Log.d((String)TAG, (String)("Rewarded onAdFailedToShow:: " + error.toString()));
                    maxRewardedAdapterListener.onRewardedAdDisplayFailed(new MaxAdapterError(error.getCode(), error.getMessage()));
                }

                public void onAdImpression(PradoRewardedAd ad) {
                    Log.d((String)TAG, (String)"Rewarded onAdImpression");
                }

                public void onAdClosed(PradoRewardedAd ad) {
                    Log.d((String)TAG, (String)"Rewarded onAdClosed");
                    maxRewardedAdapterListener.onRewardedAdHidden();
                }

                public void onRewardReceived(PradoRewardedAd ad) {
                    Log.d((String)TAG, (String)"Rewarded onRewardReceived");
                    maxRewardedAdapterListener.onUserRewarded(new MaxReward(){

                        public String getLabel() {
                            return "";
                        }

                        public int getAmount() {
                            return 0;
                        }
                    });
                }
            });
        } else {
            Log.d((String)TAG, (String)"loadRewardedAd initializing SDK");
            this.initPradoSDK(maxAdapterResponseParameters, activity, new PradoInitializationListener(){

                public void onInitSuccess() {
                    PradoMediationAdapter.this.loadRewardedAd(maxAdapterResponseParameters, activity, maxRewardedAdapterListener);
                }

                public void onInitError(PradoError error) {
                    Log.d((String)TAG, (String)("Failed to init SDK::" + error));
                    maxRewardedAdapterListener.onRewardedAdLoadFailed(new MaxAdapterError(-5204, error.getMessage()));
                }
            });
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        if (Prado.isInitialized() && this.rewardedAd != null) {
            if (this.rewardedAd.isLoaded()) {
                this.rewardedAd.show();
            } else {
                maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
            }
        } else {
            maxRewardedAdapterListener.onRewardedAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
        }
    }
}

