/*
 * Decompiled with CFR 0.152.
 */
package co.prado.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001e\u0010\t\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\n\"\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000bJ?\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\u001e\u0010\t\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\n\"\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\rJ7\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u00042\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\n\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lco/prado/utils/ReflectionUtil;", "", "()V", "getMethodQuietly", "Ljava/lang/reflect/Method;", "clazz", "Ljava/lang/Class;", "methodName", "", "parameterTypes", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "className", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "invokeMethodQuietly", "receiver", "method", "args", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "prado-sdk_androidNativeRelease"})
public final class ReflectionUtil {
    @NotNull
    public static final ReflectionUtil INSTANCE = new ReflectionUtil();

    private ReflectionUtil() {
    }

    @Nullable
    public final Method getMethodQuietly(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        try {
            method = clazz.getMethod(methodName, Arrays.copyOf(parameterTypes, parameterTypes.length));
        }
        catch (NoSuchMethodException ex) {
            method = null;
        }
        return method;
    }

    @Nullable
    public final Method getMethodQuietly(@Nullable String className, @NotNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        try {
            Class<?> clazz = Class.forName(className);
            Intrinsics.checkNotNull(clazz);
            method = this.getMethodQuietly(clazz, methodName, Arrays.copyOf(parameterTypes, parameterTypes.length));
        }
        catch (ClassNotFoundException ex) {
            method = null;
        }
        return method;
    }

    @Nullable
    public final Object invokeMethodQuietly(@Nullable Object receiver, @NotNull Method method, Object ... args) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            object = method.invoke(receiver, Arrays.copyOf(args, args.length));
        }
        catch (IllegalAccessException ex) {
            object = null;
        }
        catch (InvocationTargetException ex) {
            object = null;
        }
        return object;
    }
}

