/*
 * Decompiled with CFR 0.152.
 */
package co.prado.platforms;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import co.prado.ads.banners.PradoBannerAdCallback;
import co.prado.ads.banners.PradoBannerView;
import co.prado.ads.fullscreen.interstitial.PradoInterstitialAd;
import co.prado.ads.fullscreen.interstitial.PradoInterstitialAdCallback;
import co.prado.ads.fullscreen.rewarded.PradoRewardedAd;
import co.prado.ads.fullscreen.rewarded.PradoRewardedAdCallback;
import co.prado.sdk.Prado;
import co.prado.sdk.PradoError;
import co.prado.sdk.PradoInitializationListener;
import com.kpadplayer.sdk.platforms.BaseUnityBridge;
import org.jetbrains.annotations.NotNull;

public final class PradoUnityBridge
extends BaseUnityBridge {
    private static String TAG = PradoUnityBridge.class.getSimpleName();

    public PradoUnityBridge(Context context) {
        super(context);
    }

    public static PradoUnityBridge getInstance(Context context) {
        return new PradoUnityBridge(context);
    }

    public void initialize(Activity activity, String publisher_id, String token, String pluginVersion, String gameObject) {
        this.mGameObject = gameObject;
        Prado.Companion.setExtension("unity", pluginVersion);
        Prado.Companion.initialize((Context)activity, publisher_id, token, new PradoInitializationListener(){

            @Override
            public void onInitSuccess() {
                PradoUnityBridge.this.onSDKInitSuccess();
            }

            @Override
            public void onInitError(PradoError error) {
                PradoUnityBridge.this.onSDKInitError(error.getMessage());
            }
        });
    }

    public String getSDKVersion() {
        return Prado.Companion.getSDKVersion();
    }

    public boolean isInitialised() {
        return Prado.Companion.isInitialized();
    }

    protected void loadInterstitialAd_() {
        PradoInterstitialAd.Companion.load(this.mActivity, new PradoInterstitialAdCallback(){

            @Override
            public void onAdLoaded(PradoInterstitialAd ad) {
                Log.d((String)TAG, (String)"onAdShown");
                PradoUnityBridge.this.mInterstitialAd = ad;
                PradoUnityBridge.this.onInterstitialLoaded();
            }

            @Override
            public void onAdFailedToLoad(PradoError error) {
                Log.e((String)TAG, (String)("onAdFailedToLoad::" + error.toString()));
                PradoUnityBridge.this.onInterstitialFailedToLoad(error.getMessage());
            }

            @Override
            public void onAdShown(PradoInterstitialAd ad) {
                Log.d((String)TAG, (String)"onAdShown");
                PradoUnityBridge.this.onInterstitialShown();
            }

            @Override
            public void onAdFailedToShow(PradoInterstitialAd ad, PradoError error) {
                Log.e((String)TAG, (String)("onAdFailedToShow::" + error.toString()));
                PradoUnityBridge.this.onInterstitialFailedToShow(error.getMessage());
            }

            @Override
            public void onAdImpression(PradoInterstitialAd ad) {
                Log.d((String)TAG, (String)"onAdImpression");
                PradoUnityBridge.this.onInterstitialImpression();
            }

            @Override
            public void onAdClosed(PradoInterstitialAd ad) {
                Log.d((String)TAG, (String)"onAdClosed");
                PradoUnityBridge.this.onInterstitialClosed();
            }
        });
    }

    protected void loadRewardedAd_() {
        PradoRewardedAd.Companion.load(this.mActivity, new PradoRewardedAdCallback(){

            @Override
            public void onAdLoaded(@NotNull PradoRewardedAd ad) {
                PradoUnityBridge.this.mRewardedAd = ad;
                PradoUnityBridge.this.onRewardedLoaded();
            }

            @Override
            public void onAdFailedToLoad(@NotNull PradoError error) {
                Log.e((String)TAG, (String)("onAdFailedToLoad::" + error.toString()));
                PradoUnityBridge.this.onRewardedFailedToLoad(error.getMessage());
            }

            @Override
            public void onAdShown(@NotNull PradoRewardedAd ad) {
                Log.d((String)TAG, (String)"onAdShown");
                PradoUnityBridge.this.onRewardedShown();
            }

            @Override
            public void onAdFailedToShow(@NotNull PradoRewardedAd ad, @NotNull PradoError error) {
                Log.e((String)TAG, (String)("onAdFailedToShow::" + error.toString()));
                PradoUnityBridge.this.onRewardedFailedToShow(error.getMessage());
            }

            @Override
            public void onAdImpression(@NotNull PradoRewardedAd ad) {
                Log.d((String)TAG, (String)"onAdImpression");
                PradoUnityBridge.this.onRewardedImpression();
            }

            @Override
            public void onRewardReceived(@NotNull PradoRewardedAd ad) {
                PradoUnityBridge.this.onRewardedReceived();
            }

            @Override
            public void onAdClosed(@NotNull PradoRewardedAd ad) {
                PradoUnityBridge.this.onRewardedClosed();
            }
        });
    }

    protected boolean getIsRewardedLoaded_() {
        return this.mRewardedAd != null && this.mRewardedAd.isLoaded();
    }

    protected void showRewarded_() {
        this.mRewardedAd.show();
    }

    protected void loadBannerAd_() {
        if (this.mBannerView == null) {
            this.mBannerView = new PradoBannerView((Context)this.mActivity);
            this.mBannerView.setLayoutWithoutShowing();
        }
        ((PradoBannerView)this.mBannerView).setBannerCallback(new PradoBannerAdCallback(){

            @Override
            public void onAdLoaded() {
                PradoUnityBridge.this.onBannerLoaded();
                if (PradoUnityBridge.this.mAutoShowBanner) {
                    PradoUnityBridge.this.showBannerAd();
                }
            }

            @Override
            public void onAdFailedToLoad(@NotNull PradoError error) {
                PradoUnityBridge.this.onBannerFailedToLoad(error.getMessage());
            }

            @Override
            public void onAdShown() {
                PradoUnityBridge.this.onBannerShown();
            }

            @Override
            public void onAdFailedToShow(@NotNull PradoError error) {
                PradoUnityBridge.this.onBannerFailedToShow(error.getMessage());
            }

            @Override
            public void onAdImpression() {
                PradoUnityBridge.this.onBannerImpression();
            }

            @Override
            public void onAdClosed() {
                PradoUnityBridge.this.onBannerClosed();
            }
        });
    }
}

