/*
 * Decompiled with CFR 0.152.
 */
package co.prado.server;

import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.os.Build;
import android.text.TextUtils;
import co.prado.sdk.Prado;
import co.prado.sdk.PradoConstantDef;
import co.prado.utils.AdvertiserIdData;
import co.prado.utils.Logger;
import com.kpadplayer.general.utils.KPLogger;
import com.kpadplayer.general.utils.ScreenUtils;
import com.kpadplayer.general.utils.Utils;
import com.kpadplayer.sdk.SDKContext;
import com.kpadplayer.sdk.consent.ConsentUtil;
import com.kpadplayer.sdk.server.APIConfiguration;
import com.kpadplayer.sdk.utils.TestUtils;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lco/prado/server/PradoAPIConfiguration;", "Lcom/kpadplayer/sdk/server/APIConfiguration;", "()V", "getBasicParameters", "Landroid/content/ContentValues;", "context", "Landroid/content/Context;", "getInitSDKUrl", "", "getWaterfallParameters", "getWaterfallUrl", "getWebViewParameters", "Companion", "prado-sdk_androidNativeRelease"})
@SourceDebugExtension(value={"SMAP\nPradoAPIConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PradoAPIConfiguration.kt\nco/prado/server/PradoAPIConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,155:1\n731#2,9:156\n731#2,9:167\n37#3,2:165\n37#3,2:176\n*S KotlinDebug\n*F\n+ 1 PradoAPIConfiguration.kt\nco/prado/server/PradoAPIConfiguration\n*L\n78#1:156,9\n82#1:167,9\n79#1:165,2\n83#1:176,2\n*E\n"})
public final class PradoAPIConfiguration
extends APIConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = PradoAPIConfiguration.class.getSimpleName();
    private static final int PRADO_IAB_VENDOR_ID = 1350;

    @NotNull
    public String getInitSDKUrl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (TestUtils.isMultiEnv()) {
            return TestUtils.INSTANCE.getEnvApiUrl(context, SDKContext.SDKType.prado.getEnvUrl()) + "/api/initSDK";
        }
        return SDKContext.SDKType.prado.getEnvUrl() + "/api/initSDK";
    }

    @NotNull
    public String getWaterfallUrl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (TestUtils.isTestApp()) {
            String overrideWaterfallUrlStr = TestUtils.INSTANCE.getOverrideWaterfallUrl(context, null);
            if (!TextUtils.isEmpty((CharSequence)overrideWaterfallUrlStr)) {
                String string = overrideWaterfallUrlStr;
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
            String string = TestUtils.INSTANCE.getWaterfallUrl(context, "");
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        return SDKContext.SDKType.prado.getWaterfallUrl();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ContentValues getBasicParameters(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ContentValues contentValues = new ContentValues();
        contentValues.put("publisher_id", Prado.Companion.getPublisherId());
        contentValues.put("access_token", Prado.Companion.getToken());
        contentValues.put("package_id", context.getPackageName());
        contentValues.put("device_lang", Locale.getDefault().getLanguage());
        contentValues.put("device_type", ScreenUtils.getIsTablet((Context)context) ? "2" : "1");
        contentValues.put("omidpn", "pradoco");
        contentValues.put("omidpv", Prado.Companion.getSDKVersion());
        contentValues.put("version", "4");
        contentValues.put("sdk", SDKContext.SDKType.prado.name());
        contentValues.put("sdk_version", "4");
        contentValues.put("actual_sdk_version", Prado.Companion.getSDKVersion());
        contentValues.put("os_type", "android");
        contentValues.put("os_version", String.valueOf(Build.VERSION.SDK_INT));
        contentValues.put("ext", PradoConstantDef.INSTANCE.getEXTENSION_TYPE());
        contentValues.put("ext_version", PradoConstantDef.INSTANCE.getEXTENSION_VERSION());
        String webViewVersion = "w";
        String userAgent = Utils.getDefaultUserAgent();
        if (userAgent != null && StringsKt.contains$default((CharSequence)userAgent, (CharSequence)"Chrome", (boolean)false, (int)2, null)) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            int index = StringsKt.indexOf$default((CharSequence)userAgent, (String)"Chrome", (int)0, (boolean)false, (int)6, null);
            String string = userAgent.substring(index, userAgent.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String sub = string;
            Object object = sub;
            Regex regex = new Regex(" ");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray2 = false;
            Regex thisCollection$iv = $this$toTypedArray$iv;
            String[] res = thisCollection$iv.toArray(new String[0]);
            if (res != null && !(res.length == 0)) {
                void $this$toTypedArray$iv2;
                List list2;
                Collection $this$dropLastWhile$iv2;
                Object $i$f$toTypedArray2 = res[0];
                thisCollection$iv = new Regex("/");
                int it = 0;
                $i$f$toTypedArray2 = thisCollection$iv.split((CharSequence)$i$f$toTypedArray2, it);
                boolean $i$f$dropLastWhile2 = false;
                if (!$this$dropLastWhile$iv2.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                    while (iterator$iv.hasPrevious()) {
                        String it2 = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it2).length() == 0) continue;
                        list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv2 = list2;
                boolean $i$f$toTypedArray3 = false;
                void thisCollection$iv2 = $this$toTypedArray$iv2;
                String[] tempVal = thisCollection$iv2.toArray(new String[0]);
                if (tempVal != null && tempVal.length > 1) {
                    webViewVersion = "c_" + tempVal[1];
                }
            }
        }
        contentValues.put("webview_version", webViewVersion);
        Point point = ScreenUtils.getScreenSize((Context)context);
        contentValues.put("resolution_height", Integer.valueOf(point.y));
        contentValues.put("resolution_width", Integer.valueOf(point.x));
        contentValues.put("screen_size", Double.valueOf(ScreenUtils.getDeviceScreenSizeInInches((Context)context)));
        contentValues.put("dpi", Float.valueOf(context.getResources().getDisplayMetrics().density));
        contentValues.put("screen_category", Integer.valueOf(context.getResources().getConfiguration().screenLayout & 0xF));
        String appVersionCode = "";
        String appVersionName = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            appVersionCode = String.valueOf(packageInfo.versionCode);
            String string = packageInfo.versionName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"versionName");
            appVersionName = string;
        }
        catch (Exception ex) {
            KPLogger.e((String)TAG, (String)("Error when trying to get app version name and code: " + ex.getMessage()));
        }
        contentValues.put("app_version_code", appVersionCode);
        contentValues.put("app_version_name", appVersionName);
        contentValues.put("manufacturer", Build.MANUFACTURER);
        contentValues.put("model", Build.MODEL);
        contentValues.put("carrier_name", Utils.getCarrierName((Context)context));
        contentValues.put("network_type", Utils.getNetworkType((Context)context));
        return contentValues;
    }

    @NotNull
    public ContentValues getWaterfallParameters(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ContentValues contentValues = this.getBasicParameters(context);
        contentValues.put("coppa", Integer.valueOf(0));
        contentValues.put("consent", ConsentUtil.INSTANCE.getIABConsentString(context));
        contentValues.put("gdpr", ConsentUtil.INSTANCE.getIABGdprForServerRequest(context));
        AdvertiserIdData advertiserIdData = AdvertiserIdData.Companion.getAdvertiserIdData(context);
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.INSTANCE.d(string, advertiserIdData.toString());
        boolean hasConsent = ConsentUtil.INSTANCE.hasConsent(context, 1350);
        if (Intrinsics.areEqual((Object)advertiserIdData.isTrackingLimited(), (Object)true) || Intrinsics.areEqual((Object)new UUID(0L, 0L).toString(), (Object)advertiserIdData.getAndroidAdvertiserId()) || !hasConsent) {
            if (hasConsent) {
                this.setSessionIfa(context, contentValues);
            }
        } else {
            contentValues.put("ifa", advertiserIdData.getAndroidAdvertiserId());
            contentValues.put("ifa_type", "aaid");
        }
        return contentValues;
    }

    @NotNull
    public ContentValues getWebViewParameters(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ContentValues contentValues = this.getWaterfallParameters(context);
        contentValues.remove("gdpr");
        contentValues.put("local_gdpr", ConsentUtil.INSTANCE.getIABGdprForServerRequest(context));
        contentValues.put("force_gdpr", Integer.valueOf(ConsentUtil.INSTANCE.getForceGdprApplies(context)));
        return contentValues;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lco/prado/server/PradoAPIConfiguration$Companion;", "", "()V", "PRADO_IAB_VENDOR_ID", "", "TAG", "", "kotlin.jvm.PlatformType", "prado-sdk_androidNativeRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

