/*
 * Decompiled with CFR 0.152.
 */
package co.prado.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import co.prado.utils.Logger;
import co.prado.utils.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0003\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\u0004H\u0016R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lco/prado/utils/AdvertiserIdData;", "", "()V", "<set-?>", "", "androidAdvertiserId", "getAndroidAdvertiserId", "()Ljava/lang/String;", "", "isTrackingLimited", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "toString", "Companion", "GoogleAdInfo", "GoogleAdServiceConnection", "prado-sdk_androidNativeRelease"})
public final class AdvertiserIdData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String androidAdvertiserId;
    @Nullable
    private Boolean isTrackingLimited = false;
    private static final String TAG = AdvertiserIdData.class.getSimpleName();
    private static final int CONNECTION_RESULT_SUCCESS = 0;

    @Nullable
    public final String getAndroidAdvertiserId() {
        return this.androidAdvertiserId;
    }

    @Nullable
    public final Boolean isTrackingLimited() {
        return this.isTrackingLimited;
    }

    @NotNull
    public String toString() {
        return "aaid::" + this.androidAdvertiserId + " isTrackingLimited::" + this.isTrackingLimited;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lco/prado/utils/AdvertiserIdData$Companion;", "", "()V", "CONNECTION_RESULT_SUCCESS", "", "TAG", "", "kotlin.jvm.PlatformType", "getAdvertiserIdData", "Lco/prado/utils/AdvertiserIdData;", "context", "Landroid/content/Context;", "getAndroidIdViaReflection", "getAndroidIdViaService", "isGooglePlayServicesAvailable", "", "prado-sdk_androidNativeRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AdvertiserIdData getAdvertiserIdData(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            AdvertiserIdData identifiers = this.getAndroidIdViaReflection(context);
            if (identifiers == null && (identifiers = this.getAndroidIdViaService(context)) == null) {
                identifiers = new AdvertiserIdData();
            }
            return identifiers;
        }

        private final AdvertiserIdData getAndroidIdViaReflection(Context context) {
            try {
                Class[] classArray = new Class[]{Context.class};
                Method method = ReflectionUtil.INSTANCE.getMethodQuietly("com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo", classArray);
                if (method == null) {
                    return null;
                }
                Method getAdvertisingIdInfo = method;
                Object[] objectArray = new Object[]{context};
                Object object = ReflectionUtil.INSTANCE.invokeMethodQuietly(null, getAdvertisingIdInfo, objectArray);
                if (object == null) {
                    return null;
                }
                Object advertisingInfo = object;
                Method getId = ReflectionUtil.INSTANCE.getMethodQuietly(advertisingInfo.getClass(), "getId", new Class[0]);
                Method isLimitAdTrackingEnabled = ReflectionUtil.INSTANCE.getMethodQuietly(advertisingInfo.getClass(), "isLimitAdTrackingEnabled", new Class[0]);
                if (getId == null || isLimitAdTrackingEnabled == null) {
                    return null;
                }
                AdvertiserIdData identifiers = new AdvertiserIdData();
                identifiers.androidAdvertiserId = (String)ReflectionUtil.INSTANCE.invokeMethodQuietly(advertisingInfo, getId, new Object[0]);
                identifiers.isTrackingLimited = (Boolean)ReflectionUtil.INSTANCE.invokeMethodQuietly(advertisingInfo, isLimitAdTrackingEnabled, new Object[0]);
                return identifiers;
            }
            catch (Exception e2) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getTAG$cp(...)");
                String string2 = e2.getMessage();
                if (string2 == null) {
                    string2 = e2.toString();
                }
                Logger.INSTANCE.e(string, string2);
                return null;
            }
        }

        private final boolean isGooglePlayServicesAvailable(Context context) {
            Object[] objectArray = new Class[]{Context.class};
            Method method = ReflectionUtil.INSTANCE.getMethodQuietly("com.google.android.gms.common.GooglePlayServicesUtil", "isGooglePlayServicesAvailable", (Class<?>[])objectArray);
            if (method == null) {
                return false;
            }
            Method method2 = method;
            objectArray = new Object[]{context};
            Object connectionResult = ReflectionUtil.INSTANCE.invokeMethodQuietly(null, method2, objectArray);
            return connectionResult instanceof Integer && Intrinsics.areEqual((Object)connectionResult, (Object)0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final AdvertiserIdData getAndroidIdViaService(Context context) {
            GoogleAdServiceConnection connection = new GoogleAdServiceConnection();
            Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
            intent.setPackage("com.google.android.gms");
            if (context.bindService(intent, (ServiceConnection)connection, 1)) {
                try {
                    GoogleAdInfo adInfo = new GoogleAdInfo(connection.getBinder());
                    AdvertiserIdData identifiers = new AdvertiserIdData();
                    identifiers.androidAdvertiserId = adInfo.getAdvertiserId();
                    identifiers.isTrackingLimited = adInfo.isTrackingLimited();
                    AdvertiserIdData advertiserIdData = identifiers;
                    return advertiserIdData;
                }
                catch (Exception exception) {
                    String string = TAG;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getTAG$cp(...)");
                    String string2 = exception.getMessage();
                    if (string2 == null) {
                        string2 = exception.toString();
                    }
                    Logger.INSTANCE.e(string, string2);
                }
                finally {
                    context.unbindService((ServiceConnection)connection);
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lco/prado/utils/AdvertiserIdData$GoogleAdInfo;", "Landroid/os/IInterface;", "binder", "Landroid/os/IBinder;", "(Landroid/os/IBinder;)V", "advertiserId", "", "getAdvertiserId", "()Ljava/lang/String;", "isTrackingLimited", "", "()Z", "asBinder", "Companion", "prado-sdk_androidNativeRelease"})
    private static final class GoogleAdInfo
    implements IInterface {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final IBinder binder;
        private static final int FIRST_TRANSACTION_CODE = 1;
        private static final int SECOND_TRANSACTION_CODE = 2;

        public GoogleAdInfo(@NotNull IBinder binder) {
            Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
            this.binder = binder;
        }

        @NotNull
        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final String getAdvertiserId() throws RemoteException {
            String string;
            Parcel parcel = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain(...)");
            Parcel data = parcel;
            Parcel parcel2 = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel2, (String)"obtain(...)");
            Parcel reply = parcel2;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                string = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            String id = string;
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isTrackingLimited() throws RemoteException {
            boolean bl;
            Parcel parcel = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain(...)");
            Parcel data = parcel;
            Parcel parcel2 = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel2, (String)"obtain(...)");
            Parcel reply = parcel2;
            boolean limitAdTracking = false;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(1);
                this.binder.transact(2, data, reply, 0);
                reply.readException();
                bl = reply.readInt() != 0;
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            limitAdTracking = bl;
            return limitAdTracking;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lco/prado/utils/AdvertiserIdData$GoogleAdInfo$Companion;", "", "()V", "FIRST_TRANSACTION_CODE", "", "SECOND_TRANSACTION_CODE", "prado-sdk_androidNativeRelease"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lco/prado/utils/AdvertiserIdData$GoogleAdServiceConnection;", "Landroid/content/ServiceConnection;", "()V", "binder", "Landroid/os/IBinder;", "getBinder", "()Landroid/os/IBinder;", "consumed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "queue", "Ljava/util/concurrent/BlockingQueue;", "onServiceConnected", "", "name", "Landroid/content/ComponentName;", "service", "onServiceDisconnected", "prado-sdk_androidNativeRelease"})
    @SourceDebugExtension(value={"SMAP\nAdvertiserIdData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvertiserIdData.kt\nco/prado/utils/AdvertiserIdData$GoogleAdServiceConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
    private static final class GoogleAdServiceConnection
    implements ServiceConnection {
        @NotNull
        private final AtomicBoolean consumed = new AtomicBoolean(false);
        @NotNull
        private final BlockingQueue<IBinder> queue = new LinkedBlockingDeque();

        public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            try {
                this.queue.put(service);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void onServiceDisconnected(@NotNull ComponentName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        }

        @NotNull
        public final IBinder getBinder() throws InterruptedException {
            if (!(!this.consumed.compareAndSet(true, true))) {
                boolean bl = false;
                String string = "Binder already consumed";
                throw new IllegalStateException(string.toString());
            }
            IBinder iBinder = this.queue.take();
            Intrinsics.checkNotNullExpressionValue((Object)iBinder, (String)"take(...)");
            return iBinder;
        }
    }
}

