/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.cklib.gradle;

import co.touchlab.cklib.gradle.CKlibGradleExtensionKt;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR$\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u000fR$\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lco/touchlab/cklib/gradle/CKlibGradleExtension;", "", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "getProject", "()Lorg/gradle/api/Project;", "_konanHome", "", "_llvmHome", "kotlinVersion", "getKotlinVersion", "()Ljava/lang/String;", "setKotlinVersion", "(Ljava/lang/String;)V", "arch", "getArch", "setArch", "makeKonanHome", "value", "konanHome", "getKonanHome", "setKonanHome", "llvmHome", "getLlvmHome", "setLlvmHome", "plugin"})
public class CKlibGradleExtension {
    @NotNull
    private final Project project;
    @Nullable
    private String _konanHome;
    @Nullable
    private String _llvmHome;
    @Nullable
    private String kotlinVersion;
    @NotNull
    private String arch;

    @Inject
    public CKlibGradleExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.arch = CKlibGradleExtensionKt.getHostArch();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final String getKotlinVersion() {
        return this.kotlinVersion;
    }

    public final void setKotlinVersion(@Nullable String string) {
        this.kotlinVersion = string;
    }

    @NotNull
    public final String getArch() {
        return this.arch;
    }

    public final void setArch(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.arch = string;
    }

    private final String makeKonanHome() {
        if (this.kotlinVersion == null) {
            throw new GradleException("CKLib 'config.kotlinVersion' required. See https://github.com/touchlab/cklib");
        }
        return System.getProperty("user.home") + "/.konan/kotlin-native-prebuilt-" + CKlibGradleExtensionKt.getSimpleOsName() + "-" + this.arch + "-" + this.kotlinVersion;
    }

    @NotNull
    public final String getKonanHome() {
        String string = this._konanHome;
        if (string == null) {
            string = this.makeKonanHome();
        }
        return string;
    }

    public final void setKonanHome(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._konanHome = value;
    }

    @NotNull
    public final String getLlvmHome() {
        Object object = this._llvmHome;
        if (object == null) {
            object = CKlibGradleExtensionKt.getDefaultCklibDir() + "/" + CKlibGradleExtensionKt.getLlvmName();
        }
        return object;
    }

    public final void setLlvmHome(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._llvmHome = value;
    }
}

