/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.cklib.gradle;

import co.touchlab.cklib.gradle.CompileToBitcodeExtension;
import co.touchlab.cklib.gradle.reflection.PlatformManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.TargetSupportException;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0014\u0010\f\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0003\"\u0014\u0010\u000e\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0003\"\u0014\u0010\u0010\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0003\"\u0014\u0010\u0012\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0003\"\u0014\u0010\u0014\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0003\"\u0014\u0010\u0016\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0003\"\u0014\u0010\u0018\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0003\"\u0014\u0010\u001a\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0003\"\u0014\u0010\u001c\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0003\u00a8\u0006\u001e"}, d2={"defaultCklibDir", "", "getDefaultCklibDir", "()Ljava/lang/String;", "platformManager", "Lco/touchlab/cklib/gradle/reflection/PlatformManager;", "Lorg/gradle/api/Project;", "getPlatformManager", "(Lorg/gradle/api/Project;)Lco/touchlab/cklib/gradle/reflection/PlatformManager;", "llvmHome", "getLlvmHome", "(Lorg/gradle/api/Project;)Ljava/lang/String;", "simpleOsName", "getSimpleOsName", "hostArch", "getHostArch", "osName", "getOsName", "llvmName", "getLlvmName", "archiveType", "getArchiveType", "llvm_linux_x64", "getLlvm_linux_x64", "llvm_mingw_x64", "getLlvm_mingw_x64", "llvm_macos_x64", "getLlvm_macos_x64", "llvm_macos_arm64", "getLlvm_macos_arm64", "plugin"})
public final class CKlibGradleExtensionKt {
    @NotNull
    private static final String llvm_linux_x64 = "llvm-11.1.0-linux-x64-2";
    @NotNull
    private static final String llvm_mingw_x64 = "llvm-11.1.0-windows-x64-2";
    @NotNull
    private static final String llvm_macos_x64 = "apple-llvm-20200714-macos-x64-1";
    @NotNull
    private static final String llvm_macos_arm64 = "apple-llvm-20200714-macos-aarch64-1";

    @NotNull
    public static final String getDefaultCklibDir() {
        return System.getProperty("user.home") + "/.cklib";
    }

    @NotNull
    public static final PlatformManager getPlatformManager(@NotNull Project $this$platformManager) {
        Intrinsics.checkNotNullParameter((Object)$this$platformManager, (String)"<this>");
        CompileToBitcodeExtension cklibExtension = (CompileToBitcodeExtension)$this$platformManager.getExtensions().getByType(CompileToBitcodeExtension.class);
        return new PlatformManager(new Distribution(cklibExtension.getConfig().getKonanHome(), false, null, null, null, 30, null), cklibExtension.getConfig().getKonanHome());
    }

    @NotNull
    public static final String getLlvmHome(@NotNull Project $this$llvmHome) {
        Intrinsics.checkNotNullParameter((Object)$this$llvmHome, (String)"<this>");
        return ((CompileToBitcodeExtension)$this$llvmHome.getExtensions().getByType(CompileToBitcodeExtension.class)).getConfig().getLlvmHome();
    }

    @NotNull
    public static final String getSimpleOsName() {
        String hostOs = HostManager.Companion.hostOs();
        return Intrinsics.areEqual((Object)hostOs, (Object)"osx") ? "macos" : hostOs;
    }

    @NotNull
    public static final String getHostArch() {
        return HostManager.Companion.hostArch();
    }

    @NotNull
    public static final String getOsName() {
        String string;
        String javaOsName = System.getProperty("os.name");
        if (Intrinsics.areEqual((Object)javaOsName, (Object)"Mac OS X")) {
            string = "osx";
        } else if (Intrinsics.areEqual((Object)javaOsName, (Object)"Linux")) {
            string = "linux";
        } else {
            Intrinsics.checkNotNull((Object)javaOsName);
            if (StringsKt.startsWith$default((String)javaOsName, (String)"Windows", (boolean)false, (int)2, null)) {
                string = "windows";
            } else {
                throw new TargetSupportException("Unknown operating system: " + javaOsName, null, 2, null);
            }
        }
        return string;
    }

    @NotNull
    public static final String getLlvmName() {
        String string;
        switch (CKlibGradleExtensionKt.getOsName()) {
            case "osx": {
                if (Intrinsics.areEqual((Object)CKlibGradleExtensionKt.getHostArch(), (Object)"aarch64")) {
                    string = llvm_macos_arm64;
                    break;
                }
                string = llvm_macos_x64;
                break;
            }
            case "linux": {
                string = llvm_linux_x64;
                break;
            }
            case "windows": {
                string = llvm_mingw_x64;
                break;
            }
            default: {
                throw new TargetSupportException("Unknown operating system: " + CKlibGradleExtensionKt.getOsName(), null, 2, null);
            }
        }
        return string;
    }

    @NotNull
    public static final String getArchiveType() {
        return Intrinsics.areEqual((Object)CKlibGradleExtensionKt.getOsName(), (Object)"windows") ? "zip" : "tar.gz";
    }

    @NotNull
    public static final String getLlvm_linux_x64() {
        return llvm_linux_x64;
    }

    @NotNull
    public static final String getLlvm_mingw_x64() {
        return llvm_mingw_x64;
    }

    @NotNull
    public static final String getLlvm_macos_x64() {
        return llvm_macos_x64;
    }

    @NotNull
    public static final String getLlvm_macos_arm64() {
        return llvm_macos_arm64;
    }
}

