/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.kermit.irplugin;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContext;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lco/touchlab/kermit/irplugin/KermitChiselTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "pluginContext", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "stripBelow", "", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;Ljava/lang/String;)V", "classLogger", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "stripFunctionSet", "", "makeStripFunctionNameSet", "severity", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "kermit-ir-plugin"})
public final class KermitChiselTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final IrPluginContext pluginContext;
    @NotNull
    private final IrClassSymbol classLogger;
    @NotNull
    private final Set<String> stripFunctionSet;

    public KermitChiselTransformer(@NotNull IrPluginContext pluginContext, @NotNull String stripBelow) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        Intrinsics.checkNotNullParameter((Object)stripBelow, (String)"stripBelow");
        this.pluginContext = pluginContext;
        IrClassSymbol irClassSymbol = this.pluginContext.referenceClass(new FqName("co.touchlab.kermit.Logger"));
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this.classLogger = irClassSymbol;
        this.stripFunctionSet = this.makeStripFunctionNameSet(stripBelow);
    }

    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression) {
        IrType recType;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrExpression irExpression = expression.getDispatchReceiver();
        Object object = recType = irExpression != null ? irExpression.getType() : null;
        if (recType != null && IrTypeUtilsKt.isSubtypeOfClass((IrType)recType, (IrClassSymbol)this.classLogger)) {
            String string = ((IrSimpleFunction)expression.getSymbol().getOwner()).getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression.symbol.owner.name.identifier");
            String functionName = string;
            boolean stripCall = this.stripFunctionSet.contains(functionName);
            if (stripCall) {
                return (IrExpression)ExpressionHelpersKt.irUnit((IrBuilderWithScope)((IrBuilderWithScope)new DeclarationIrBuilder((IrGeneratorContext)this.pluginContext, (IrSymbol)expression.getSymbol(), 0, 0, 12, null)));
            }
        }
        return super.visitCall(expression);
    }

    private final Set<String> makeStripFunctionNameSet(String severity) {
        Set set;
        switch (severity) {
            case "Verbose": 
            case "None": {
                set = SetsKt.emptySet();
                break;
            }
            case "Debug": {
                set = SetsKt.setOf((Object)"v");
                break;
            }
            case "Info": {
                Object[] objectArray = new String[]{"v", "d"};
                set = SetsKt.setOf((Object[])objectArray);
                break;
            }
            case "Warn": {
                Object[] objectArray = new String[]{"v", "d", "i"};
                set = SetsKt.setOf((Object[])objectArray);
                break;
            }
            case "Error": {
                Object[] objectArray = new String[]{"v", "d", "i", "w"};
                set = SetsKt.setOf((Object[])objectArray);
                break;
            }
            case "Assert": {
                Object[] objectArray = new String[]{"v", "d", "i", "w", "e"};
                set = SetsKt.setOf((Object[])objectArray);
                break;
            }
            case "All": {
                Object[] objectArray = new String[]{"v", "d", "i", "w", "e", "a"};
                set = SetsKt.setOf((Object[])objectArray);
                break;
            }
            default: {
                set = SetsKt.emptySet();
            }
        }
        return set;
    }
}

