/*
 * Decompiled with CFR 0.152.
 */
package timber.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.NativeBox;
import timber.log.Tree;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J,\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0019J\u001f\u0010\u001f\u001a\u00020\u001b2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0002\u0010 J\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\rJ\u0014\u0010\"\u001a\u00020\u001b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0#J.\u0010$\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0019H\u0001J\u000e\u0010%\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\rJ\u0006\u0010'\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Ltimber/log/Timber;", "", "()V", "ASSERT", "", "DEBUG", "ERROR", "INFO", "VERBOSE", "WARNING", "forestArray", "Ltimber/log/NativeBox;", "", "Ltimber/log/Tree;", "size", "getSize", "()I", "trees", "", "getTrees", "()Ljava/util/List;", "isLoggable", "", "priority", "tag", "", "log", "", "throwable", "", "message", "plant", "([Ltimber/log/Tree;)V", "tree", "plantAll", "", "rawLog", "tagged", "uproot", "uprootAll", "timber-kmp"})
public final class Timber {
    private static final NativeBox<Tree[]> forestArray;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARNING = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    public static final Timber INSTANCE;

    @NotNull
    public final List<Tree> getTrees() {
        return ArraysKt.toList((Object[])forestArray.getValue());
    }

    public final int getSize() {
        return ((Object[])forestArray.getValue()).length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void uprootAll() {
        NativeBox<Tree[]> lock$iv = forestArray;
        boolean $i$f$synchronized2 = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            boolean bl3 = false;
            NativeBox<Tree[]> nativeBox = forestArray;
            Tree[] treeArray = new Tree[]{};
            nativeBox.setValue(treeArray);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void uproot(@NotNull Tree tree) {
        Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
        NativeBox<Tree[]> lock$iv = forestArray;
        boolean $i$f$synchronized2 = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            void $this$toTypedArray$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            List newList = new ArrayList();
            boolean treeFound = false;
            for (Tree ltree22 : forestArray.getValue()) {
                if (Intrinsics.areEqual((Object)ltree22, (Object)tree)) {
                    treeFound = true;
                    continue;
                }
                newList.add(ltree22);
            }
            boolean ltree22 = false;
            int n = 0;
            if (!treeFound) {
                boolean bl5 = false;
                String string = "Cannot uproot tree which is not planted: " + tree;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Collection ltree22 = newList;
            NativeBox<Tree[]> nativeBox = forestArray;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Tree[] treeArray = thisCollection$iv.toArray(new Tree[0]);
            if (treeArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Tree[] treeArray2 = treeArray;
            nativeBox.setValue(treeArray2);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void plant(@NotNull Tree tree) {
        Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
        NativeBox<Tree[]> lock$iv = forestArray;
        boolean $i$f$synchronized2 = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            void $this$toTypedArray$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            List newList = new ArrayList();
            CollectionsKt.addAll((Collection)newList, (Object[])forestArray.getValue());
            newList.add(tree);
            Collection collection = newList;
            NativeBox<Tree[]> nativeBox = forestArray;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Tree[] treeArray = thisCollection$iv.toArray(new Tree[0]);
            if (treeArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Tree[] treeArray2 = treeArray;
            nativeBox.setValue(treeArray2);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void plant(Tree ... trees) {
        Intrinsics.checkParameterIsNotNull((Object)trees, (String)"trees");
        NativeBox<Tree[]> lock$iv = forestArray;
        boolean $i$f$synchronized2 = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            void $this$toTypedArray$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            List newList = new ArrayList();
            CollectionsKt.addAll((Collection)newList, (Object[])forestArray.getValue());
            CollectionsKt.addAll((Collection)newList, (Object[])trees);
            Collection collection = newList;
            NativeBox<Tree[]> nativeBox = forestArray;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Tree[] treeArray = thisCollection$iv.toArray(new Tree[0]);
            if (treeArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Tree[] treeArray2 = treeArray;
            nativeBox.setValue(treeArray2);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void plantAll(@NotNull Iterable<? extends Tree> trees) {
        Intrinsics.checkParameterIsNotNull(trees, (String)"trees");
        NativeBox<Tree[]> lock$iv = forestArray;
        boolean $i$f$synchronized2 = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            void $this$toTypedArray$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            List newList = new ArrayList();
            CollectionsKt.addAll((Collection)newList, (Object[])forestArray.getValue());
            CollectionsKt.addAll((Collection)newList, trees);
            Collection collection = newList;
            NativeBox<Tree[]> nativeBox = forestArray;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Tree[] treeArray = thisCollection$iv.toArray(new Tree[0]);
            if (treeArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Tree[] treeArray2 = treeArray;
            nativeBox.setValue(treeArray2);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isLoggable(int priority, @Nullable String tag) {
        boolean bl;
        block1: {
            Object[] $this$any$iv = forestArray.getValue();
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Tree it = (Tree)element$iv;
                boolean bl2 = false;
                if (!it.isLoggable(priority, tag)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean isLoggable$default(Timber timber, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        return timber.isLoggable(n, string);
    }

    public final void log(int priority, @Nullable String tag, @Nullable Throwable throwable, @Nullable String message) {
        Object[] $this$forEach$iv = forestArray.getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tree it = (Tree)element$iv;
            boolean bl = false;
            it.log(priority, tag, throwable, message);
        }
    }

    @PublishedApi
    public final void rawLog(int priority, @Nullable String tag, @Nullable Throwable throwable, @Nullable String message) {
        Object[] $this$forEach$iv = forestArray.getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tree it = (Tree)element$iv;
            boolean bl = false;
            it.rawLog(priority, tag, throwable, message);
        }
    }

    @NotNull
    public final Tree tagged(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        String taggedTag = tag;
        return new Tree(taggedTag){
            final /* synthetic */ String $taggedTag;

            public boolean isLoggable(int priority, @Nullable String tag) {
                String string = tag;
                if (string == null) {
                    string = this.$taggedTag;
                }
                return Timber.INSTANCE.isLoggable(priority, string);
            }

            protected void performLog(int priority, @Nullable String tag, @Nullable Throwable throwable, @Nullable String message) {
                String string = tag;
                if (string == null) {
                    string = this.$taggedTag;
                }
                Timber.INSTANCE.log(priority, string, throwable, message);
            }
            {
                this.$taggedTag = $captured_local_variable$0;
            }
        };
    }

    private Timber() {
    }

    static {
        Tree[] treeArray;
        Timber timber;
        INSTANCE = timber = new Timber();
        Tree[] treeArray2 = treeArray = new Tree[0];
        forestArray = new NativeBox<Tree[]>(treeArray2);
    }
}

