/*
 * Decompiled with CFR 0.152.
 */
package co.unruly.matchers;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class OptionalMatchers {
    public static <T> Matcher<Optional<T>> empty() {
        return new TypeSafeMatcher<Optional<T>>(){

            protected boolean matchesSafely(Optional<T> item) {
                return !item.isPresent();
            }

            public void describeTo(Description description) {
                description.appendText("An empty Optional");
            }
        };
    }

    public static <T> Matcher<Optional<T>> contains(final T content) {
        return new TypeSafeMatcher<Optional<T>>(){

            protected boolean matchesSafely(Optional<T> item) {
                return item.map(content::equals).orElse(false);
            }

            public void describeTo(Description description) {
                description.appendText(Optional.of(content).toString());
            }
        };
    }

    public static <T> Matcher<Optional<T>> contains(final Matcher<T> matcher) {
        return new TypeSafeMatcher<Optional<T>>(){

            protected boolean matchesSafely(Optional<T> item) {
                return item.map(arg_0 -> ((Matcher)matcher).matches(arg_0)).orElse(false);
            }

            public void describeTo(Description description) {
                description.appendText("Optional with an item that matches" + matcher);
            }
        };
    }

    public static Matcher<OptionalInt> emptyInt() {
        return new TypeSafeMatcher<OptionalInt>(){

            protected boolean matchesSafely(OptionalInt item) {
                return !item.isPresent();
            }

            public void describeTo(Description description) {
                description.appendText("An empty OptionalInt");
            }
        };
    }

    public static Matcher<OptionalInt> containsInt(final int content) {
        return new TypeSafeMatcher<OptionalInt>(){

            protected boolean matchesSafely(OptionalInt item) {
                return item.isPresent() && item.getAsInt() == content;
            }

            public void describeTo(Description description) {
                description.appendText(Optional.of(content).toString());
            }
        };
    }

    public static Matcher<OptionalInt> containsInt(final Matcher<Integer> matcher) {
        return new TypeSafeMatcher<OptionalInt>(){

            protected boolean matchesSafely(OptionalInt item) {
                return item.isPresent() && matcher.matches((Object)item.getAsInt());
            }

            public void describeTo(Description description) {
                description.appendText("OptionalInt with an item that matches" + matcher);
            }
        };
    }

    public static Matcher<OptionalLong> emptyLong() {
        return new TypeSafeMatcher<OptionalLong>(){

            protected boolean matchesSafely(OptionalLong item) {
                return !item.isPresent();
            }

            public void describeTo(Description description) {
                description.appendText("An empty OptionalLong");
            }
        };
    }

    public static Matcher<OptionalLong> containsLong(final long content) {
        return new TypeSafeMatcher<OptionalLong>(){

            protected boolean matchesSafely(OptionalLong item) {
                return item.isPresent() && item.getAsLong() == content;
            }

            public void describeTo(Description description) {
                description.appendText(Optional.of(content).toString());
            }
        };
    }

    public static Matcher<OptionalLong> containsLong(final Matcher<Long> matcher) {
        return new TypeSafeMatcher<OptionalLong>(){

            protected boolean matchesSafely(OptionalLong item) {
                return item.isPresent() && matcher.matches((Object)item.getAsLong());
            }

            public void describeTo(Description description) {
                description.appendText("OptionalLong with an item that matches" + matcher);
            }
        };
    }

    public static Matcher<OptionalDouble> emptyDouble() {
        return new TypeSafeMatcher<OptionalDouble>(){

            protected boolean matchesSafely(OptionalDouble item) {
                return !item.isPresent();
            }

            public void describeTo(Description description) {
                description.appendText("An empty OptionalDouble");
            }
        };
    }

    public static Matcher<OptionalDouble> containsDouble(final double content) {
        return new TypeSafeMatcher<OptionalDouble>(){

            protected boolean matchesSafely(OptionalDouble item) {
                return item.isPresent() && item.getAsDouble() == content;
            }

            public void describeTo(Description description) {
                description.appendText(Optional.of(content).toString());
            }
        };
    }

    public static Matcher<OptionalDouble> containsDouble(final Matcher<Double> matcher) {
        return new TypeSafeMatcher<OptionalDouble>(){

            protected boolean matchesSafely(OptionalDouble item) {
                return item.isPresent() && matcher.matches((Object)item.getAsDouble());
            }

            public void describeTo(Description description) {
                description.appendText("OptionalDouble with an item that matches" + matcher);
            }
        };
    }
}

