/*
 * Decompiled with CFR 0.152.
 */
package co.unruly.config;

import co.unruly.config.ConfigurationSource;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.amazonaws.services.secretsmanager.model.ResourceNotFoundException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SecretsManager
implements ConfigurationSource {
    private final String secretName;
    private final String region;
    private final AWSSecretsManager client;
    private Map<String, String> credentials;

    public SecretsManager(String secretName, String region) {
        this.secretName = secretName;
        this.region = region;
        this.client = this.setupClient();
    }

    public SecretsManager(String secretName, String region, AWSSecretsManager client) {
        this.secretName = secretName;
        this.region = region;
        this.client = client;
    }

    @Override
    public String get(String key) {
        if (this.credentials == null) {
            this.credentials = this.fetchCredentials();
        }
        return this.credentials.get(key);
    }

    private Map<String, String> fetchCredentials() {
        HashMap emptyResults = new HashMap();
        return this.getSecretValueFromRequest().map(GetSecretValueResult::getSecretString).flatMap(this::parseJSON).orElse(emptyResults);
    }

    private AWSSecretsManager setupClient() {
        return (AWSSecretsManager)((AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withRegion(this.region)).build();
    }

    private Optional<GetSecretValueResult> getSecretValueFromRequest() {
        return this.getSecretValue(this.createRequest());
    }

    private GetSecretValueRequest createRequest() {
        return new GetSecretValueRequest().withSecretId(this.secretName);
    }

    private Optional<GetSecretValueResult> getSecretValue(GetSecretValueRequest getSecretValueRequest) {
        try {
            return Optional.ofNullable(this.client.getSecretValue(getSecretValueRequest));
        }
        catch (ResourceNotFoundException e) {
            return Optional.empty();
        }
    }

    private Optional<Map<String, String>> parseJSON(String jsonInput) {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<Map<String, String>> parseAsMap = new TypeReference<Map<String, String>>(){};
        try {
            return Optional.ofNullable(mapper.readValue(jsonInput, (TypeReference)parseAsMap));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

