/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.authentication.configuration;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.webapps.authentication.components.PipelineAuthenticator;
import org.apache.cocoon.webapps.authentication.configuration.ApplicationConfiguration;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.SAXException;

public final class HandlerConfiguration
implements Serializable {
    private final String name;
    private String redirectURI;
    private SourceParameters redirectParameters;
    private String authenticationResource;
    private String logoutResource;
    private String authenticatorClass;
    private SourceParameters authenticationResourceParameters;
    private String loadResource;
    private SourceParameters loadResourceParameters;
    private String saveResource;
    private SourceParameters saveResourceParameters;
    private Map applications = new Hashtable(3, 2.0f);
    private Map configurations;
    private boolean saveOnLogout = false;

    public HandlerConfiguration(String name) {
        this.name = name;
        this.configurations = new HashMap(3, 2.0f);
    }

    public void configure(SourceResolver resolver, Request request, Configuration conf) throws ProcessingException, SAXException, IOException, ConfigurationException {
        Configuration[] configurations;
        Configuration[] appConfs;
        int pos;
        Configuration child = conf.getChild("redirect-to", false);
        if (child == null) {
            throw new ConfigurationException("Handler '" + this.name + "' needs a redirect-to URI.");
        }
        this.redirectURI = child.getAttribute("uri");
        if (this.redirectURI.startsWith("cocoon:") && (pos = this.redirectURI.indexOf(47)) != -1 && this.redirectURI.length() > pos) {
            if (this.redirectURI.charAt(pos + 1) == '/') {
                this.redirectURI = this.redirectURI.substring(pos + 2).trim();
                this.redirectURI = request.getContextPath() + "/" + this.redirectURI;
            } else {
                this.redirectURI = this.redirectURI.substring(pos + 1).trim();
            }
        }
        this.redirectParameters = SourceParameters.create((Configuration)child);
        child = conf.getChild("authentication", false);
        if (child == null) {
            throw new ConfigurationException("Handler '" + this.name + "' needs authentication configuration");
        }
        this.authenticatorClass = child.getAttribute("authenticator", PipelineAuthenticator.class.getName());
        this.authenticationResource = PipelineAuthenticator.class.getName().equals(this.authenticatorClass) ? child.getAttribute("uri") : child.getAttribute("uri", null);
        this.logoutResource = child.getAttribute("logout-uri", null);
        this.authenticationResourceParameters = SourceParameters.create((Configuration)child);
        child = conf.getChild("load", false);
        if (child != null) {
            this.loadResource = child.getAttribute("uri");
            this.loadResourceParameters = SourceParameters.create((Configuration)child);
        }
        if ((child = conf.getChild("save", false)) != null) {
            this.saveResource = child.getAttribute("uri");
            this.saveResourceParameters = SourceParameters.create((Configuration)child);
            this.saveOnLogout = child.getAttributeAsBoolean("saveOnLogout", false);
        }
        if ((child = conf.getChild("applications", false)) != null && (appConfs = child.getChildren("application")) != null) {
            for (int i = 0; i < appConfs.length; ++i) {
                Configuration appconf = appConfs[i];
                String appName = appconf.getAttribute("name");
                if (this.applications.get(appName) != null) {
                    throw new ConfigurationException("Application names must be unique: " + appName);
                }
                ApplicationConfiguration apphandler = new ApplicationConfiguration(this, appName);
                this.applications.put(appName, apphandler);
                apphandler.configure(resolver, appconf);
            }
        }
        if ((configurations = conf.getChildren("configuration")) != null) {
            for (int i = 0; i < configurations.length; ++i) {
                child = configurations[i];
                String value = child.getAttribute("name");
                if (this.getConfiguration(value) != null) {
                    throw new ConfigurationException("Configuration names must be unique for application " + this.name + ": " + value);
                }
                this.configurations.put(value, child);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public SourceParameters getRedirectParameters() {
        return this.redirectParameters;
    }

    public String getAuthenticationResource() {
        return this.authenticationResource;
    }

    public SourceParameters getAuthenticationResourceParameters() {
        return this.authenticationResourceParameters;
    }

    public String getLogoutResource() {
        return this.logoutResource;
    }

    public String getSaveResource() {
        return this.saveResource;
    }

    public String getLoadResource() {
        return this.loadResource;
    }

    public boolean saveOnLogout() {
        return this.saveOnLogout;
    }

    public SourceParameters getSaveResourceParameters() {
        return this.saveResourceParameters;
    }

    public SourceParameters getLoadResourceParameters() {
        return this.loadResourceParameters;
    }

    public Map getApplications() {
        return this.applications;
    }

    public Configuration getConfiguration(String name) {
        return (Configuration)this.configurations.get(name);
    }

    public String toString() {
        return "authentication handler '" + this.name + "' (" + super.toString() + ')';
    }

    public String getAuthenticatorClassName() {
        return this.authenticatorClass;
    }
}

