/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.authentication.generation;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.webapps.authentication.AuthenticationManager;
import org.apache.cocoon.webapps.authentication.context.AuthenticationContext;
import org.apache.cocoon.webapps.authentication.generation.UserManagementHandler;
import org.apache.cocoon.webapps.authentication.user.RequestState;
import org.apache.cocoon.webapps.authentication.user.UserHandler;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMUtil;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public final class ConfigurationGenerator
extends ServiceableGenerator {
    public static final String REQ_PARAMETER_STATE = "authstate";
    public static final String REQ_PARAMETER_ROLE = "authrole";
    public static final String REQ_PARAMETER_ID = "authid";
    public static final String REQ_PARAMETER_USER = "authuser";
    private static final String SESSION_CONTEXT_ATTRIBUTE_ADMIN_ROLE = "org.apache.cocoon.webapps.generation.ConfigurationGenerator.simple-role";
    protected XPathProcessor xpathProcessor;

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.xpathProcessor);
            this.xpathProcessor = null;
        }
        super.dispose();
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.xpathProcessor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        AuthenticationManager authManager = null;
        RequestState state = null;
        try {
            authManager = (AuthenticationManager)this.manager.lookup(AuthenticationManager.ROLE);
            state = authManager.getState();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.xmlConsumer.startDocument();
        if (state != null) {
            try {
                UserHandler userhandler = state.getHandler();
                Configuration conf = state.getModuleConfiguration("single-role-user-management");
                if (conf == null) {
                    throw new ProcessingException("Module configuration 'single-role-user-management' for authentication user management generator not found.");
                }
                UserManagementHandler handler = new UserManagementHandler(conf, state.getApplicationName());
                this.showConfiguration(this.xmlConsumer, this.source, handler, userhandler.getContext());
            }
            catch (ConfigurationException ex) {
                throw new ProcessingException("ConfigurationException: " + (Object)((Object)ex), (Throwable)ex);
            }
        }
        this.xmlConsumer.endDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showConfiguration(XMLConsumer consumer, String src, UserManagementHandler handler, AuthenticationContext context) throws ProcessingException, SAXException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN showConfiguration consumer=" + consumer + ", src=" + src);
        }
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        Session session = request.getSession();
        boolean isAdmin = src == null || src.equals("admin");
        AttributesImpl attr = new AttributesImpl();
        consumer.startElement("", "configuration", "configuration", (Attributes)attr);
        String uri = response.encodeURL(request.getRequestURI());
        consumer.startElement("", "uri", "uri", (Attributes)attr);
        consumer.characters(uri.toCharArray(), 0, uri.length());
        consumer.endElement("", "uri", "uri");
        if (isAdmin) {
            consumer.startElement("", "menue", "menue", (Attributes)attr);
            if (handler.getNewRoleResource() != null) {
                consumer.startElement("", "addrole", "addrole", (Attributes)attr);
                consumer.endElement("", "addrole", "addrole");
            }
            if (handler.getDeleteRoleResource() != null) {
                consumer.startElement("", "delrole", "delrole", (Attributes)attr);
                consumer.endElement("", "delrole", "delrole");
            }
            consumer.endElement("", "menue", "menue");
        }
        Session session2 = session;
        synchronized (session2) {
            NodeList childs;
            Document userDF;
            Map pars;
            String id;
            Object users;
            Document userDF2;
            String role;
            String state = request.getParameter(REQ_PARAMETER_STATE);
            if (state == null) {
                String string = state = isAdmin ? "main" : "seluser";
            }
            if (state.equals("addrole")) {
                role = request.getParameter(REQ_PARAMETER_ROLE);
                if (role != null && role.trim().length() > 0) {
                    SourceParameters pars2 = new SourceParameters();
                    Enumeration requestParameters = request.getParameterNames();
                    while (requestParameters.hasMoreElements()) {
                        String current = (String)requestParameters.nextElement();
                        pars2.setParameter(current, request.getParameter(current));
                    }
                    this.addRole(role, pars2, handler);
                } else {
                    role = null;
                }
                session.removeAttribute(SESSION_CONTEXT_ATTRIBUTE_ADMIN_ROLE);
            }
            if (state.equals("delrole")) {
                try {
                    role = request.getParameter(REQ_PARAMETER_ROLE);
                    if (role != null) {
                        userDF2 = this.getUsers(role, null, handler);
                        users = null;
                        if (userDF2 != null) {
                            users = DOMUtil.selectNodeList((Node)userDF2, (String)"users/user", (XPathProcessor)this.xpathProcessor);
                        }
                        if (users != null) {
                            for (int i = 0; i < users.getLength(); ++i) {
                                this.deleteUser(role, DOMUtil.getValueOf((Node)users.item(i), (String)"ID", (XPathProcessor)this.xpathProcessor), null, handler);
                            }
                        }
                        this.deleteRole(role, null, handler);
                    }
                    session.removeAttribute(SESSION_CONTEXT_ATTRIBUTE_ADMIN_ROLE);
                }
                catch (TransformerException local) {
                    throw new ProcessingException("TransformerException: " + local, (Throwable)local);
                }
            }
            if (state.equals("chguser")) {
                String user;
                if (!isAdmin) {
                    Map pars3 = context.getContextInfo();
                    id = (String)pars3.get("ID");
                    role = (String)pars3.get("role");
                    user = "old";
                } else {
                    role = request.getParameter(REQ_PARAMETER_ROLE);
                    id = request.getParameter(REQ_PARAMETER_ID);
                    user = request.getParameter(REQ_PARAMETER_USER);
                }
                boolean addingNewUserFailed = false;
                if (role != null && id != null && user != null) {
                    if (user.equals("new")) {
                        SourceParameters pars4 = new SourceParameters();
                        Enumeration requestParameters = request.getParameterNames();
                        while (requestParameters.hasMoreElements()) {
                            String current = (String)requestParameters.nextElement();
                            pars4.setParameter(current, request.getParameter(current));
                        }
                        boolean bl = addingNewUserFailed = !this.addUser(role, id, pars4, handler);
                        if (!addingNewUserFailed) {
                            consumer.startElement("", "addeduser", "addeduser", (Attributes)attr);
                            consumer.characters(id.toCharArray(), 0, id.length());
                            consumer.endElement("", "addeduser", "addeduser");
                        }
                    } else {
                        String delete = request.getParameter("authdeluser");
                        if (delete != null && delete.equals("true")) {
                            this.deleteUser(role, id, null, handler);
                        } else {
                            SourceParameters pars5 = new SourceParameters();
                            Enumeration requestParameters = request.getParameterNames();
                            while (requestParameters.hasMoreElements()) {
                                String current = (String)requestParameters.nextElement();
                                pars5.setParameter(current, request.getParameter(current));
                            }
                            this.changeUser(role, id, pars5, handler);
                        }
                    }
                    session.removeAttribute(SESSION_CONTEXT_ATTRIBUTE_ADMIN_ROLE);
                }
                state = !addingNewUserFailed ? (isAdmin ? "adduser" : "seluser") : "erruser";
            }
            if (state.equals("seluser")) {
                if (!isAdmin) {
                    pars = context.getContextInfo();
                    id = (String)pars.get("ID");
                    role = (String)pars.get("role");
                } else {
                    role = request.getParameter(REQ_PARAMETER_ROLE);
                    id = request.getParameter(REQ_PARAMETER_ID);
                }
                if (role != null && id != null) {
                    session.setAttribute(SESSION_CONTEXT_ATTRIBUTE_ADMIN_ROLE, (Object)role);
                    userDF = this.getUsers(role, id, handler);
                    Element users2 = null;
                    try {
                        if (userDF != null) {
                            users2 = (Element)DOMUtil.getSingleNode((Node)userDF, (String)"users/user", (XPathProcessor)this.xpathProcessor);
                        }
                    }
                    catch (TransformerException local) {
                        throw new ProcessingException("TransformerException: " + local, (Throwable)local);
                    }
                    consumer.startElement("", "uservalues", "uservalues", (Attributes)attr);
                    if (users2 != null && users2.hasChildNodes()) {
                        childs = users2.getChildNodes();
                        for (int i = 0; i < childs.getLength(); ++i) {
                            if (childs.item(i).getNodeType() != 1) continue;
                            IncludeXMLConsumer.includeNode((Node)childs.item(i), (ContentHandler)consumer, (LexicalHandler)consumer);
                        }
                    }
                    consumer.endElement("", "uservalues", "uservalues");
                }
                consumer.startElement("", "user", "user", (Attributes)attr);
                consumer.characters("old".toCharArray(), 0, 3);
                consumer.endElement("", "user", "user");
                if (!isAdmin) {
                    consumer.startElement("", "role", "role", (Attributes)attr);
                    consumer.characters(role.toCharArray(), 0, role.length());
                    consumer.endElement("", "role", "role");
                }
            }
            if (state.equals("erruser")) {
                if (!isAdmin) {
                    pars = context.getContextInfo();
                    id = (String)pars.get("ID");
                    role = (String)pars.get("role");
                } else {
                    role = request.getParameter(REQ_PARAMETER_ROLE);
                    id = request.getParameter(REQ_PARAMETER_ID);
                }
                if (role != null && id != null) {
                    session.setAttribute(SESSION_CONTEXT_ATTRIBUTE_ADMIN_ROLE, (Object)role);
                    userDF = this.getUsers(role, id, handler);
                    Element users3 = null;
                    try {
                        if (userDF != null) {
                            users3 = (Element)DOMUtil.getSingleNode((Node)userDF, (String)"users/user", (XPathProcessor)this.xpathProcessor);
                        }
                    }
                    catch (TransformerException local) {
                        throw new ProcessingException("TransformerException: " + local, (Throwable)local);
                    }
                    consumer.startElement("", "uservalues", "uservalues", (Attributes)attr);
                    if (users3 != null && users3.hasChildNodes()) {
                        childs = users3.getChildNodes();
                        for (int i = 0; i < childs.getLength(); ++i) {
                            if (childs.item(i).getNodeType() != 1) continue;
                            IncludeXMLConsumer.includeNode((Node)childs.item(i), (ContentHandler)consumer, (LexicalHandler)consumer);
                        }
                    }
                    consumer.endElement("", "uservalues", "uservalues");
                }
                consumer.startElement("", "user", "user", (Attributes)attr);
                consumer.characters("error".toCharArray(), 0, 5);
                consumer.endElement("", "user", "user");
                if (!isAdmin) {
                    consumer.startElement("", "role", "role", (Attributes)attr);
                    consumer.characters(role.toCharArray(), 0, role.length());
                    consumer.endElement("", "role", "role");
                }
            }
            if (state.equals("adduser")) {
                consumer.startElement("", "user", "user", (Attributes)attr);
                consumer.characters("new".toCharArray(), 0, 3);
                consumer.endElement("", "user", "user");
            }
            if (state.equals("selrole")) {
                role = request.getParameter(REQ_PARAMETER_ROLE);
                session.setAttribute(SESSION_CONTEXT_ATTRIBUTE_ADMIN_ROLE, (Object)role);
                userDF2 = this.getUsers(role, null, handler);
                users = null;
                try {
                    if (userDF2 != null) {
                        users = DOMUtil.getSingleNode((Node)userDF2, (String)"users", (XPathProcessor)this.xpathProcessor);
                    }
                }
                catch (TransformerException local) {
                    throw new ProcessingException("TransformerException: " + local, (Throwable)local);
                }
                IncludeXMLConsumer.includeNode((Node)users, (ContentHandler)consumer, (LexicalHandler)consumer);
            }
            if (isAdmin) {
                Document rolesDF = this.getRoles(handler);
                Node roles = null;
                try {
                    if (rolesDF != null) {
                        roles = DOMUtil.getSingleNode((Node)rolesDF, (String)"roles", (XPathProcessor)this.xpathProcessor);
                    }
                }
                catch (TransformerException local) {
                    throw new ProcessingException("TransformerException: " + local, (Throwable)local);
                }
                IncludeXMLConsumer.includeNode(roles, (ContentHandler)consumer, (LexicalHandler)consumer);
                String role2 = (String)session.getAttribute(SESSION_CONTEXT_ATTRIBUTE_ADMIN_ROLE);
                if (role2 != null) {
                    consumer.startElement("", "role", "role", (Attributes)attr);
                    consumer.characters(role2.toCharArray(), 0, role2.length());
                    consumer.endElement("", "role", "role");
                }
            }
        }
        consumer.endElement("", "configuration", "configuration");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END showConfiguration");
        }
    }

    public Document getUsers(String role, String ID, UserManagementHandler handler) throws IOException, ProcessingException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN getUsers role=" + role + ", ID=" + ID);
        }
        Document frag = null;
        if (handler.getLoadUsersResource() != null) {
            SourceParameters parameters;
            String loadUsersResource = handler.getLoadUsersResource();
            SourceParameters loadParameters = handler.getLoadUsersResourceParameters();
            SourceParameters sourceParameters = parameters = loadParameters == null ? new SourceParameters() : loadParameters;
            if (handler.getApplicationName() != null) {
                parameters.setSingleParameterValue("application", handler.getApplicationName());
            }
            if (ID != null) {
                parameters.setSingleParameterValue("type", "user");
                parameters.setSingleParameterValue("ID", ID);
            } else {
                parameters.setSingleParameterValue("type", "users");
            }
            if (role != null) {
                parameters.setSingleParameterValue("role", role);
            }
            frag = this.loadResource(loadUsersResource, parameters);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END getUsers fragment=" + (frag == null ? "null" : XMLUtils.serializeNode(frag, (Properties)XMLUtils.createPropertiesForXML((boolean)false))));
        }
        return frag;
    }

    public Document getRoles(UserManagementHandler handler) throws IOException, ProcessingException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN getRoles");
        }
        Document frag = null;
        if (handler.getLoadRolesResource() != null) {
            SourceParameters parameters;
            String loadRolesResource = handler.getLoadRolesResource();
            SourceParameters loadParameters = handler.getLoadRolesResourceParameters();
            SourceParameters sourceParameters = parameters = loadParameters == null ? new SourceParameters() : (SourceParameters)loadParameters.clone();
            if (handler.getApplicationName() != null) {
                parameters.setSingleParameterValue("application", handler.getApplicationName());
            }
            parameters.setSingleParameterValue("type", "roles");
            frag = this.loadResource(loadRolesResource, parameters);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END getRoles fragment=" + frag);
        }
        return frag;
    }

    private void addRole(String name, SourceParameters parameters, UserManagementHandler handler) throws IOException, ProcessingException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN addRole role=" + name + ", parameters=" + parameters);
        }
        if (handler.getNewRoleResource() != null) {
            String newRoleResource = handler.getNewRoleResource();
            SourceParameters handlerPars = handler.getNewRoleResourceParameters();
            if (parameters == null) {
                parameters = new SourceParameters();
            }
            parameters.add(handlerPars);
            if (handler.getApplicationName() != null) {
                parameters.setSingleParameterValue("application", handler.getApplicationName());
            }
            parameters.setSingleParameterValue("type", "role");
            parameters.setSingleParameterValue("role", name);
            this.invokeResource(newRoleResource, parameters);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END addRole");
        }
    }

    public boolean addUser(String role, String ID, SourceParameters parameters, UserManagementHandler handler) throws IOException, ProcessingException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN addUser role=" + role + ", ID=" + ID + ", parameters=" + parameters);
        }
        boolean result = false;
        if (handler.getNewUserResource() != null && ID != null && ID.trim().length() > 0) {
            Document user = this.getUsers(null, null, handler);
            Node node = null;
            if (user != null) {
                try {
                    node = DOMUtil.getSingleNode((Node)user, (String)("users/user/ID[text()='" + ID + "']"), (XPathProcessor)this.xpathProcessor);
                }
                catch (TransformerException local) {
                    throw new ProcessingException("Transformer exception: " + local, (Throwable)local);
                }
            }
            if (user == null || node == null) {
                String newUserResource = handler.getNewUserResource();
                SourceParameters newUsersPars = handler.getNewUserResourceParameters();
                if (parameters == null) {
                    parameters = new SourceParameters();
                }
                parameters.add(newUsersPars);
                if (handler.getApplicationName() != null) {
                    parameters.setSingleParameterValue("application", handler.getApplicationName());
                }
                parameters.setSingleParameterValue("type", "user");
                parameters.setSingleParameterValue("role", role);
                parameters.setSingleParameterValue("ID", ID);
                this.invokeResource(newUserResource, parameters);
                result = true;
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END addUser success=" + result);
        }
        return result;
    }

    private void deleteRole(String name, SourceParameters parameters, UserManagementHandler handler) throws IOException, ProcessingException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN deleteRole role=" + name + ", parameters=" + parameters);
        }
        if (handler.getDeleteRoleResource() != null) {
            String deleteRoleResource = handler.getDeleteRoleResource();
            SourceParameters handlerPars = handler.getDeleteRoleResourceParameters();
            if (parameters == null) {
                parameters = new SourceParameters();
            }
            parameters.add(handlerPars);
            if (handler.getApplicationName() != null) {
                parameters.setSingleParameterValue("application", handler.getApplicationName());
            }
            parameters.setSingleParameterValue("type", "role");
            parameters.setSingleParameterValue("role", name);
            this.invokeResource(deleteRoleResource, parameters);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END deleteRole");
        }
    }

    private void deleteUser(String role, String name, SourceParameters parameters, UserManagementHandler handler) throws IOException, ProcessingException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN deleteUser role=" + role + ", ID=" + name + ", parameters=" + parameters);
        }
        if (handler.getDeleteUserResource() != null) {
            String deleteUserResource = handler.getDeleteUserResource();
            SourceParameters handlerPars = handler.getDeleteUserResourceParameters();
            if (parameters == null) {
                parameters = new SourceParameters();
            }
            parameters.add(handlerPars);
            if (handler.getApplicationName() != null) {
                parameters.setSingleParameterValue("application", handler.getApplicationName());
            }
            parameters.setSingleParameterValue("type", "user");
            parameters.setSingleParameterValue("role", role);
            parameters.setSingleParameterValue("ID", name);
            this.invokeResource(deleteUserResource, parameters);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END deleteUser");
        }
    }

    private void changeUser(String role, String name, SourceParameters parameters, UserManagementHandler handler) throws IOException, ProcessingException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN changeUser role=" + role + ", ID=" + name + ", parameters=" + parameters);
        }
        if (handler.getChangeUserResource() != null) {
            String changeUserResource = handler.getChangeUserResource();
            SourceParameters handlerPars = handler.getChangeUserResourceParameters();
            if (parameters == null) {
                parameters = new SourceParameters();
            }
            parameters.add(handlerPars);
            if (handler.getApplicationName() != null) {
                parameters.setSingleParameterValue("application", handler.getApplicationName());
            }
            parameters.setSingleParameterValue("type", "user");
            parameters.setSingleParameterValue("role", role);
            parameters.setSingleParameterValue("ID", name);
            this.invokeResource(changeUserResource, parameters);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END changeUser");
        }
    }

    private void invokeResource(String resource, SourceParameters parameters) throws IOException, ProcessingException, SAXException {
        Source source = null;
        try {
            source = SourceUtil.getSource((String)resource, null, (SourceParameters)parameters, (SourceResolver)this.resolver);
            SourceUtil.parse((ServiceManager)this.manager, (Source)source, (ContentHandler)new DefaultHandler());
        }
        catch (SourceException se) {
            try {
                throw SourceUtil.handle((SourceException)se);
            }
            catch (Throwable throwable) {
                this.resolver.release(source);
                throw throwable;
            }
        }
        this.resolver.release(source);
    }

    private Document loadResource(String resource, SourceParameters parameters) throws IOException, ProcessingException, SAXException {
        Document document;
        Source source = null;
        try {
            source = SourceUtil.getSource((String)resource, null, (SourceParameters)parameters, (SourceResolver)this.resolver);
            document = SourceUtil.toDOM((Source)source);
        }
        catch (SourceException se) {
            try {
                throw SourceUtil.handle((SourceException)se);
            }
            catch (Throwable throwable) {
                this.resolver.release(source);
                throw throwable;
            }
        }
        this.resolver.release(source);
        return document;
    }
}

