/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.axis;

import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.ServletEndpointContextImpl;
import org.apache.axis.utils.XMLUtils;
import org.apache.cocoon.components.axis.SoapServer;
import org.apache.cocoon.util.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.dom.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SoapServerImpl
extends AbstractLogEnabled
implements SoapServer,
Composable,
Configurable,
Contextualizable,
Initializable,
Startable,
ThreadSafe {
    public static final String DEFAULT_SERVER_CONFIG = "resource://org/apache/axis/server/server-config.wsdd";
    private String m_transportName;
    private ServletSecurityProvider m_securityProvider;
    private String m_jwsClassDir;
    private AxisServer m_axisServer;
    private FileProvider m_engineConfig;
    private String m_attachmentDir;
    private Source m_serverWSDD;
    private WSDDDocument[] m_descriptors;
    private Context m_context;
    private ComponentManager m_manager;

    public void contextualize(Context context) throws ContextException {
        this.m_context = context;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.m_manager = manager;
    }

    public void configure(Configuration config) throws ConfigurationException {
        try {
            this.setServerConfig(config);
            this.setAttachmentDir(config);
            this.setJWSDir(config);
            this.setSecurityProvider(config);
            this.setTransportName(config);
            this.setManagedServices(config);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("SoapServerImpl.configure() complete");
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Error during configuration", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setServerConfig(Configuration config) throws Exception {
        Configuration wsdd = config.getChild("server-wsdd");
        SourceResolver resolver = null;
        try {
            resolver = (SourceResolver)this.m_manager.lookup(SourceResolver.ROLE);
            this.m_serverWSDD = resolver.resolveURI(wsdd.getAttribute("src", DEFAULT_SERVER_CONFIG));
            Object var5_4 = null;
            if (resolver == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (resolver == null) throw throwable;
            this.m_manager.release((Component)resolver);
            throw throwable;
        }
        this.m_manager.release((Component)resolver);
    }

    private void setAttachmentDir(Configuration config) throws ConfigurationException, ContextException {
        Configuration dir = config.getChild("attachment-dir");
        this.m_attachmentDir = dir.getAttribute("src", null);
        if (this.m_attachmentDir == null) {
            File workDir = (File)this.m_context.get((Object)"work-directory");
            File attachmentDir = IOUtils.createFile((File)workDir, (String)("attachments" + File.separator));
            this.m_attachmentDir = IOUtils.getFullFilename((File)attachmentDir);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("attachment directory = " + this.m_attachmentDir);
        }
    }

    private void setJWSDir(Configuration config) throws ConfigurationException, ContextException {
        Configuration dir = config.getChild("jws-dir");
        this.m_jwsClassDir = dir.getAttribute("src", null);
        if (this.m_jwsClassDir == null) {
            File workDir = (File)this.m_context.get((Object)"work-directory");
            File jwsClassDir = IOUtils.createFile((File)workDir, (String)("axis-jws" + File.separator));
            this.m_jwsClassDir = IOUtils.getFullFilename((File)jwsClassDir);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("jws class directory = " + this.m_jwsClassDir);
        }
    }

    private void setSecurityProvider(Configuration config) throws ConfigurationException {
        Configuration secProvider = config.getChild("security-provider", false);
        if (secProvider != null) {
            boolean providerIsEnabled;
            String attr = secProvider.getAttribute("enabled");
            boolean bl = providerIsEnabled = "true".equalsIgnoreCase(attr) || "yes".equalsIgnoreCase(attr);
            if (providerIsEnabled) {
                this.m_securityProvider = new ServletSecurityProvider();
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("security provider = " + this.m_securityProvider);
        }
    }

    private void setTransportName(Configuration config) throws ConfigurationException {
        Configuration name = config.getChild("transport");
        this.m_transportName = name.getAttribute("name", "http");
    }

    private void setManagedServices(Configuration config) throws Exception {
        Configuration m = config.getChild("managed-services", false);
        ArrayList<WSDDDocument> descriptors = new ArrayList<WSDDDocument>();
        if (m != null) {
            DOMParser parser;
            block7: {
                SourceResolver resolver = null;
                parser = null;
                try {
                    Configuration[] services = m.getChildren("descriptor");
                    resolver = (SourceResolver)this.m_manager.lookup(SourceResolver.ROLE);
                    parser = (DOMParser)this.m_manager.lookup(DOMParser.ROLE);
                    int i = 0;
                    while (i < services.length) {
                        String location = services[i].getAttribute("src");
                        Source source = resolver.resolveURI(location);
                        Document d = parser.parseDocument(new InputSource(new InputStreamReader(source.getInputStream())));
                        descriptors.add(new WSDDDocument(d));
                        ++i;
                    }
                    Object var12_11 = null;
                    if (resolver == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    if (resolver != null) {
                        this.m_manager.release((Component)resolver);
                    }
                    if (parser != null) {
                        this.m_manager.release((Component)parser);
                    }
                    throw throwable;
                }
                this.m_manager.release((Component)resolver);
            }
            if (parser != null) {
                this.m_manager.release((Component)parser);
            }
        }
        this.m_descriptors = descriptors.toArray(new WSDDDocument[0]);
    }

    public void initialize() throws Exception {
        this.m_axisServer = this.createEngine();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("SoapServerImpl.initialize() complete");
        }
    }

    public void start() throws Exception {
        int i = 0;
        while (i < this.m_descriptors.length) {
            WSDDDeployment deployment = this.m_engineConfig.getDeployment();
            this.m_descriptors[i].deploy(deployment);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Deployed Descriptor:\n" + XMLUtils.DocumentToString((Document)this.m_descriptors[i].getDOMDocument()));
            }
            ++i;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("SoapServerImpl.start() complete");
        }
    }

    public void stop() throws Exception {
        WSDDDeployment deployment = this.m_engineConfig.getDeployment();
        WSDDService[] services = deployment.getServices();
        int i = 0;
        while (i < services.length) {
            deployment.undeployService(services[i].getQName());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Undeployed: " + services[i].toString());
            }
            ++i;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("SoapServerImpl.stop() complete");
        }
    }

    public void invoke(MessageContext message) throws Exception {
        this.m_axisServer.invoke(message);
    }

    public MessageContext createMessageContext(HttpServletRequest req, HttpServletResponse res, ServletContext con) {
        MessageContext msgContext = new MessageContext((AxisEngine)this.m_axisServer);
        String webInfPath = con.getRealPath("/WEB-INF");
        String homeDir = con.getRealPath("/");
        msgContext.setTransportName(this.m_transportName);
        msgContext.setProperty("axis-message-context-logger", (Object)this.getLogger());
        msgContext.setProperty("component-manager", (Object)this.m_manager);
        msgContext.setProperty("jws.classDir", (Object)this.m_jwsClassDir);
        msgContext.setProperty("home.dir", (Object)homeDir);
        msgContext.setProperty("path", (Object)req.getServletPath());
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, (Object)req);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, (Object)res);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, (Object)webInfPath);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, (Object)req.getPathInfo());
        msgContext.setProperty("Authorization", (Object)req.getHeader("Authorization"));
        msgContext.setProperty("remoteaddr", (Object)req.getRemoteAddr());
        ServletEndpointContextImpl sec = new ServletEndpointContextImpl();
        msgContext.setProperty("servletEndpointContext", (Object)sec);
        String realpath = con.getRealPath(req.getServletPath());
        if (realpath != null) {
            msgContext.setProperty("realpath", (Object)realpath);
        }
        msgContext.setProperty("configPath", (Object)webInfPath);
        if (this.m_securityProvider != null) {
            msgContext.setProperty("securityProvider", (Object)this.m_securityProvider);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.debugMessageContext(msgContext);
        }
        return msgContext;
    }

    private void debugMessageContext(MessageContext context) {
        Iterator i = context.getPropertyNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.getLogger().debug("MessageContext: Key:" + key + ": Value: " + context.getProperty(key));
        }
    }

    public AxisServer createEngine() throws Exception {
        AxisServer engine = AxisServer.getServer((Map)this.getEngineEnvironment());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Axis engine created");
        }
        return engine;
    }

    protected Map getEngineEnvironment() throws Exception {
        HashMap<String, Object> env = new HashMap<String, Object>();
        this.m_engineConfig = new FileProvider(this.m_serverWSDD.getInputStream());
        env.put("engineConfig", this.m_engineConfig);
        env.put("axis.attachments.Directory", this.m_attachmentDir);
        return env;
    }
}

