/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.IOUtils;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class ScriptGenerator
extends ServiceableGenerator
implements Configurable {
    protected BSFLanguage[] additionalLanguages;
    private Source inputSource;

    public void configure(Configuration conf) throws ConfigurationException {
        if (conf != null) {
            Configuration languagesToAdd = conf.getChild("add-languages");
            Configuration[] languages = languagesToAdd.getChildren("language");
            this.additionalLanguages = new BSFLanguage[languages.length];
            for (int i = 0; i < languages.length; ++i) {
                Configuration language = languages[i];
                BSFLanguage bsfLanguage = new BSFLanguage();
                bsfLanguage.name = language.getAttribute("name");
                bsfLanguage.engineSrc = language.getAttribute("src");
                this.getLogger().debug("Configuring ScriptGenerator with additional BSF language " + bsfLanguage.name);
                this.getLogger().debug("Configuring ScriptGenerator with BSF engine " + bsfLanguage.engineSrc);
                Configuration[] extensions = language.getChildren("extension");
                bsfLanguage.extensions = new String[extensions.length];
                for (int j = 0; j < extensions.length; ++j) {
                    bsfLanguage.extensions[i] = extensions[i].getValue();
                    this.getLogger().debug("Configuring ScriptGenerator with lang extension " + bsfLanguage.extensions[i]);
                }
                this.additionalLanguages[i] = bsfLanguage;
            }
        }
    }

    public void recycle() {
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        super.recycle();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws ProcessingException {
        SAXParser parser = null;
        try {
            this.getLogger().debug("processing file [" + this.source + "]");
            this.inputSource = this.resolver.resolveURI(this.source);
            this.getLogger().debug("file resolved to [" + this.inputSource.getURI() + "]");
            InputStreamReader in = new InputStreamReader(this.inputSource.getInputStream());
            BSFManager mgr = new BSFManager();
            if (this.additionalLanguages != null) {
                for (int i = 0; i < this.additionalLanguages.length; ++i) {
                    this.getLogger().debug("adding BSF language " + this.additionalLanguages[i].name + " with engine " + this.additionalLanguages[i].engineSrc);
                    BSFManager.registerScriptingEngine((String)this.additionalLanguages[i].name, (String)this.additionalLanguages[i].engineSrc, (String[])this.additionalLanguages[i].extensions);
                }
            }
            StringBuffer output = new StringBuffer();
            mgr.registerBean("resolver", (Object)this.resolver);
            mgr.registerBean("source", (Object)this.source);
            mgr.registerBean("objectModel", (Object)this.objectModel);
            mgr.registerBean("parameters", (Object)this.parameters);
            mgr.registerBean("output", (Object)output);
            mgr.registerBean("logger", (Object)this.getLogger());
            this.getLogger().debug("BSFManager execution begining");
            mgr.exec(BSFManager.getLangFromFilename((String)this.inputSource.getURI()), this.inputSource.getURI(), 0, 0, (Object)IOUtils.getStringFromReader((Reader)in));
            this.getLogger().debug("BSFManager execution complete");
            this.getLogger().debug("output = [" + output.toString() + "]");
            InputSource xmlInput = new InputSource(new StringReader(output.toString()));
            parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
            parser.parse(xmlInput, (ContentHandler)this.xmlConsumer);
        }
        catch (SourceException se) {
            try {
                throw SourceUtil.handle((SourceException)se);
                catch (FileNotFoundException e) {
                    throw new ResourceNotFoundException("Could not load script " + this.inputSource.getURI(), (Throwable)e);
                }
                catch (BSFException e) {
                    throw new ProcessingException("Exception in ScriptGenerator.generate()", (Throwable)e);
                }
                catch (Exception e) {
                    throw new ProcessingException("Exception in ScriptGenerator.generate()", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.manager.release(parser);
                throw throwable;
            }
        }
        this.manager.release((Object)parser);
    }

    protected class BSFLanguage {
        public String name;
        public String engineSrc;
        public String[] extensions;

        protected BSFLanguage() {
        }
    }
}

