/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting.modular;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.acting.modular.DatabaseAction;
import org.apache.cocoon.util.HashMap;

public class DatabaseQueryAction
extends DatabaseAction {
    protected String selectMode(boolean isAutoIncrement, Map modes) {
        return (String)modes.get(DatabaseAction.MODE_OTHERS);
    }

    protected boolean honourAutoIncrement() {
        return false;
    }

    protected DatabaseAction.CacheHelper getQuery(Configuration table, Map modeTypes, Map defaultModeNames) throws ConfigurationException, ServiceException {
        DatabaseAction.LookUpKey lookUpKey = new DatabaseAction.LookUpKey(table, modeTypes);
        DatabaseAction.CacheHelper queryData = null;
        HashMap hashMap = this.cachedQueryData;
        synchronized (hashMap) {
            queryData = (DatabaseAction.CacheHelper)this.cachedQueryData.get((Object)lookUpKey);
            if (queryData == null) {
                Configuration[] queries = table.getChild("queries").getChildren("query");
                Configuration[] keys = table.getChild("keys").getChildren("key");
                Configuration[] values = table.getChild("values").getChildren("value");
                boolean found = false;
                String queryModeName = "";
                String query = "";
                boolean useValues = true;
                int i = 0;
                while (i < queries.length) {
                    queryModeName = queries[i].getAttribute("mode", null);
                    if (queryModeName.equals(modeTypes.get(DatabaseAction.MODE_OTHERS)) || "all".equals(queryModeName)) {
                        query = queries[i].getValue();
                        useValues = queries[i].getAttributeAsBoolean("use-values", useValues);
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    throw new ConfigurationException("Could not find query mode " + modeTypes.get(DatabaseAction.MODE_OTHERS) + " for table " + table.getAttribute("name", null));
                }
                queryData = new DatabaseAction.CacheHelper(keys.length, keys.length + (useValues ? values.length : 0));
                queryData.queryString = query;
                this.fillModes(keys, true, defaultModeNames, modeTypes, queryData);
                if (useValues) {
                    this.fillModes(values, false, defaultModeNames, modeTypes, queryData);
                }
                this.cachedQueryData.put((Object)lookUpKey, (Object)queryData);
            }
        }
        return queryData;
    }

    protected Object[][] getColumnValues(Configuration tableConf, DatabaseAction.CacheHelper queryData, Map objectModel) throws ConfigurationException, ServiceException {
        Object[][] columnValues = new Object[queryData.columns.length][];
        int i = 0;
        while (i < queryData.columns.length) {
            columnValues[i] = this.getColumnValue(tableConf, queryData.columns[i], objectModel);
            ++i;
        }
        return columnValues;
    }

    protected int processRow(Map objectModel, Connection conn, PreparedStatement statement, String outputMode, Configuration table, DatabaseAction.CacheHelper queryData, Object[][] columnValues, int rowIndex, Map results) throws SQLException, ConfigurationException, Exception {
        int currentIndex = 1;
        int i = 0;
        while (i < queryData.columns.length) {
            DatabaseAction.Column col = queryData.columns[i];
            if (col.isKey) {
                this.setColumn(objectModel, outputMode, results, table, col.columnConf, rowIndex, columnValues[i][col.isSet ? rowIndex : 0], statement, currentIndex);
                ++currentIndex;
            }
            ++i;
        }
        boolean hasResult = statement.execute();
        if (!hasResult) {
            return statement.getUpdateCount();
        }
        ResultSet resultset = statement.getResultSet();
        ResultSetMetaData metadata = resultset.getMetaData();
        rowIndex = 0;
        while (resultset.next()) {
            ++rowIndex;
            String tableName = "";
            String columnName = "";
            int i2 = 1;
            while (i2 <= metadata.getColumnCount()) {
                Object value = resultset.getObject(i2);
                tableName = metadata.getTableName(i2);
                columnName = metadata.getColumnLabel(i2) + "[" + rowIndex + "]";
                if (tableName != "") {
                    columnName = tableName + "." + columnName;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("retrieving " + columnName + " as " + value);
                }
                results.put(metadata.getTableName(i2) + "." + metadata.getColumnLabel(i2), value);
                ++i2;
            }
        }
        return rowIndex;
    }
}

