/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.language.markup.xsp.AbstractEsqlQuery;
import org.apache.cocoon.components.language.markup.xsp.JdbcEsqlQuery;
import org.apache.cocoon.components.language.markup.xsp.MysqlEsqlQuery;
import org.apache.cocoon.components.language.markup.xsp.OracleEsqlQuery;
import org.apache.cocoon.components.language.markup.xsp.PervasiveEsqlQuery;
import org.apache.cocoon.components.language.markup.xsp.PostgresEsqlQuery;
import org.apache.cocoon.components.language.markup.xsp.PostgresOldEsqlQuery;
import org.apache.cocoon.components.language.markup.xsp.SybaseEsqlQuery;

public abstract class AbstractEsqlConnection
extends AbstractLogEnabled {
    private String url = null;
    private Properties properties = null;
    private boolean multipleResults = false;

    protected AbstractEsqlConnection() {
    }

    protected abstract Connection getConnection() throws SQLException;

    public void setMultipleResults(String value) {
        this.multipleResults = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public boolean getMultipleResults() {
        return this.multipleResults;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(name, value);
    }

    public void setUser(String user) {
        this.setProperty("user", user);
    }

    public void setPassword(String password) {
        this.setProperty("password", password);
    }

    public void setAutoCommit(boolean autocommit) throws SQLException {
        this.getConnection().setAutoCommit(autocommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.getConnection().getAutoCommit();
    }

    public String getURL() throws SQLException {
        if (this.url == null) {
            this.url = this.getConnection().getMetaData().getURL();
        }
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    public void close() throws SQLException {
        this.getConnection().close();
    }

    public AbstractEsqlQuery createQuery(String type, String queryString) throws SQLException {
        AbstractEsqlQuery query;
        Connection connection = this.getConnection();
        if ("".equals(type) || "auto".equalsIgnoreCase(type)) {
            String database = connection.getMetaData().getDatabaseProductName().toLowerCase();
            if (database.indexOf("postgresql") > -1) {
                query = new PostgresEsqlQuery(connection, queryString);
            } else if (database.indexOf("mysql") > -1) {
                query = new MysqlEsqlQuery(connection, queryString);
            } else if (database.indexOf("adaptive server anywhere") > -1 || database.indexOf("microsoft sql server") > -1) {
                query = new SybaseEsqlQuery(connection, queryString);
            } else if (database.indexOf("oracle") > -1) {
                query = new OracleEsqlQuery(connection, queryString);
            } else if (database.indexOf("pervasive") > -1) {
                query = new PervasiveEsqlQuery(connection, queryString);
            } else if (database.indexOf("hsql") > -1 || database.indexOf("interbase") > -1 || database.indexOf("access") > -1 || database.indexOf("sap db") > -1 || database.indexOf("firebird") > -1 || database.indexOf("sybase sql server") > -1) {
                query = new JdbcEsqlQuery(this.getConnection(), queryString);
            } else {
                this.getLogger().warn("Your database [" + String.valueOf(database) + "] is not being recognized yet." + " Using the generic [jdbc] query as default. " + " Please report this to cocoon-dev or to tcurdt.at.apache.org directly.");
                query = new JdbcEsqlQuery(this.getConnection(), queryString);
            }
        } else if ("sybase".equalsIgnoreCase(type)) {
            query = new SybaseEsqlQuery(connection, queryString);
        } else if ("postgresql".equalsIgnoreCase(type)) {
            query = new PostgresEsqlQuery(connection, queryString);
        } else if ("postgresql-old".equalsIgnoreCase(type)) {
            query = new PostgresOldEsqlQuery(connection, queryString);
        } else if ("mysql".equalsIgnoreCase(type)) {
            query = new MysqlEsqlQuery(connection, queryString);
        } else if ("oracle".equalsIgnoreCase(type)) {
            query = new OracleEsqlQuery(connection, queryString);
        } else if ("pervasive".equalsIgnoreCase(type)) {
            query = new PervasiveEsqlQuery(connection, queryString);
        } else if ("jdbc".equalsIgnoreCase(type)) {
            query = new JdbcEsqlQuery(connection, queryString);
        } else {
            this.getLogger().error("Unknown database type: " + String.valueOf(type));
            throw new SQLException("Unknown database type: " + String.valueOf(type));
        }
        this.setupLogger((Object)query);
        return query;
    }
}

