/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public abstract class AbstractEsqlQuery
extends AbstractLogEnabled {
    private int maxRows = -1;
    private int skipRows = 0;
    private int rowCount = -1;
    private int position = -1;
    private String query = null;
    private Connection connection = null;
    private ResultSetMetaData resultSetMetaData = null;
    private PreparedStatement preparedStatement = null;
    private ResultSet resultSet = null;
    private boolean hasResultSet = false;
    private boolean keepgoing = true;
    private int queryResultsCount = 0;
    private int updateResultsCount = 0;
    private int updateCount = -2;
    private ArrayList groups = null;
    private int groupLevel = -1;
    private int changeLevel = -1;

    protected AbstractEsqlQuery(Connection connection, String query) {
        this.connection = connection;
        this.query = query;
    }

    protected AbstractEsqlQuery(ResultSet resultSet) {
        this.connection = null;
        this.query = null;
        this.resultSet = resultSet;
        this.hasResultSet = resultSet != null;
    }

    public abstract AbstractEsqlQuery newInstance(ResultSet var1);

    public String getQueryString() throws SQLException {
        return this.query;
    }

    public PreparedStatement prepareStatement() throws SQLException {
        this.preparedStatement = this.connection.prepareStatement(this.getQueryString());
        return this.preparedStatement;
    }

    public CallableStatement prepareCall() throws SQLException {
        this.preparedStatement = this.connection.prepareCall(this.getQueryString());
        return (CallableStatement)this.preparedStatement;
    }

    public int getRowCount() throws SQLException {
        if (this.rowCount < 0) {
            int orderby;
            String lowerQuery = this.query.toLowerCase();
            int from = lowerQuery.indexOf(" from ");
            int groupby = lowerQuery.indexOf(" group by ");
            int min = Math.min(groupby, orderby = lowerQuery.indexOf(" order by "));
            String countQuery = min > -1 ? "select count(*)" + String.valueOf(this.query).substring(from, min) : "select count(*)" + String.valueOf(this.query).substring(from);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("executing [" + String.valueOf(this.query) + "]");
            }
            ResultSet rs = this.preparedStatement.executeQuery(countQuery);
            try {
                if (rs.first()) {
                    this.rowCount = rs.getInt(1);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("count = " + this.rowCount);
                    }
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                rs.close();
                throw throwable;
            }
            rs.close();
            {
            }
        }
        return this.rowCount;
    }

    public void getResultRows() throws SQLException {
        if (this.skipRows > 0) {
            while (this.resultSet.next()) {
                ++this.position;
                if (this.position >= this.skipRows) break;
            }
        }
    }

    public void cleanUp() {
        this.resultSetMetaData = null;
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
                this.resultSet = null;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
                this.preparedStatement = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected final void setPosition(int p) {
        this.position = p;
    }

    protected final PreparedStatement setPreparedStatement(PreparedStatement ps) {
        this.preparedStatement = ps;
        return this.preparedStatement;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final int getSkipRows() {
        return this.skipRows;
    }

    public final void setSkipRows(int i) {
        this.skipRows = i;
    }

    public final int getMaxRows() {
        return this.maxRows;
    }

    public final void setMaxRows(int i) {
        this.maxRows = i;
    }

    public final ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public final PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    public final CallableStatement getCallableStatement() {
        return (CallableStatement)this.preparedStatement;
    }

    public final ResultSet getResultSet() {
        return this.resultSet;
    }

    public final boolean nextRow() throws SQLException {
        ++this.position;
        return this.resultSet.next();
    }

    public final int getCurrentRow() {
        return this.position;
    }

    public final boolean execute(int resultSetFromObject) throws SQLException {
        if (this.preparedStatement != null) {
            this.hasResultSet = this.preparedStatement.execute();
            if (this.hasResultSet) {
                this.resultSet = (ResultSet)((CallableStatement)this.preparedStatement).getObject(resultSetFromObject);
                ++this.queryResultsCount;
                return true;
            }
            ++this.updateResultsCount;
            this.updateCount = this.preparedStatement.getUpdateCount();
            return this.updateCount > -1;
        }
        return false;
    }

    public final boolean execute() throws SQLException {
        if (this.preparedStatement != null) {
            this.hasResultSet = this.preparedStatement.execute();
            if (this.hasResultSet) {
                this.resultSet = this.preparedStatement.getResultSet();
                this.resultSetMetaData = this.resultSet.getMetaData();
                ++this.queryResultsCount;
                return true;
            }
            ++this.updateResultsCount;
            this.updateCount = this.preparedStatement.getUpdateCount();
            return this.updateCount > -1;
        }
        return false;
    }

    public final boolean executeQuery() throws SQLException {
        if (this.preparedStatement != null) {
            this.resultSet = this.preparedStatement.executeQuery();
            if (this.resultSet != null) {
                this.resultSetMetaData = this.resultSet.getMetaData();
                ++this.queryResultsCount;
                this.hasResultSet = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public final boolean getMoreResults() throws SQLException {
        if (this.preparedStatement != null) {
            this.hasResultSet = this.preparedStatement.getMoreResults();
            if (this.hasResultSet) {
                this.resultSet = this.preparedStatement.getResultSet();
                this.resultSetMetaData = this.resultSet.getMetaData();
                ++this.queryResultsCount;
                return true;
            }
            ++this.updateResultsCount;
            this.updateCount = this.preparedStatement.getUpdateCount();
            return this.updateCount > -1;
        }
        return false;
    }

    public final boolean hasResultSet() {
        return this.hasResultSet;
    }

    public final int getUpdateCount() {
        return this.updateCount;
    }

    public final int getQueryResultsCount() {
        return this.queryResultsCount;
    }

    public final int getUpdateResultsCount() {
        return this.updateResultsCount;
    }

    public final boolean keepGoing() {
        return this.keepgoing;
    }

    public final void setKeepGoing(boolean still) {
        this.keepgoing = still;
    }

    public final void incGroupLevel() {
        ++this.groupLevel;
    }

    public final void decGroupLevel() {
        --this.groupLevel;
    }

    public final boolean groupLevelExists() {
        return this.groups != null && this.groups.size() >= this.groupLevel + 1 && this.groups.get(this.groupLevel) != null;
    }

    public final void setGroupingVar(String key) throws SQLException {
        if (this.groups == null) {
            this.groups = new ArrayList(this.groupLevel);
        }
        this.groups.ensureCapacity(this.groupLevel);
        this.groups.add(this.groupLevel, new EsqlGroup(key, this.getResultSet().getObject(key)));
    }

    public final boolean hasGroupingVarChanged() throws SQLException {
        if (this.changeLevel != -1) {
            if (this.changeLevel < this.groupLevel) {
                return true;
            }
            this.changeLevel = -1;
            return true;
        }
        boolean result = false;
        int i = 0;
        while (i <= this.groupLevel) {
            Object tmp = this.getResultSet().getObject(((EsqlGroup)this.groups.get((int)i)).var);
            if (!tmp.equals(((EsqlGroup)this.groups.get((int)i)).value)) {
                ((EsqlGroup)this.groups.get((int)i)).value = tmp;
                result = true;
                if (this.changeLevel == -1 && this.groupLevel != i) {
                    this.changeLevel = i;
                }
            }
            ++i;
        }
        return result;
    }

    final class EsqlGroup {
        public String var = null;
        public Object value = null;

        EsqlGroup(String var, Object value) {
            this.var = var;
            this.value = value;
        }
    }
}

