/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.CascadingIOException;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;

public class BlobSource
extends AbstractLogEnabled
implements Source,
Serviceable {
    private ServiceManager manager = null;
    private String systemId;
    private String datasourceName;
    private String tableName;
    private String columnName;
    private String condition;
    private static final String URL_PREFIX = "blob:/";
    private static final int URL_PREFIX_LEN = "blob:/".length();

    public BlobSource(String url) throws MalformedURLException {
        this.systemId = url;
        int start = URL_PREFIX_LEN;
        int end = url.indexOf(47, start);
        if (end == -1) {
            throw new MalformedURLException("Malformed blob source (cannot find datasource) : " + url);
        }
        this.datasourceName = url.substring(start, end);
        start = end + 1;
        if ((end = url.indexOf(47, start)) == -1) {
            throw new MalformedURLException("Malformed blob source (cannot find table name) : " + url);
        }
        this.tableName = url.substring(start, end);
        start = end + 1;
        if ((end = url.indexOf(91, start)) == -1) {
            this.columnName = url.substring(start);
        } else {
            this.columnName = url.substring(start, end);
            start = end + 1;
            end = url.length() - 1;
            if (url.charAt(end) != ']') {
                throw new MalformedURLException("Malformed url for a blob source (cannot find condition) : " + url);
            }
            this.condition = url.substring(start, end);
        }
    }

    public void service(ServiceManager manager) {
        this.manager = manager;
    }

    public String getScheme() {
        return URL_PREFIX;
    }

    public String getURI() {
        return this.systemId;
    }

    public InputStream getInputStream() throws IOException, SourceException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Opening stream for datasource " + this.datasourceName + ", table " + this.tableName + ", column " + this.columnName + (this.condition == null ? ", no condition" : ", condition " + this.condition));
        }
        Connection cnx = null;
        Statement stmt = null;
        try {
            cnx = this.getConnection();
            stmt = cnx.createStatement();
            StringBuffer selectBuf = new StringBuffer("SELECT ").append(this.columnName).append(" FROM ").append(this.tableName);
            if (this.condition != null) {
                selectBuf.append(" WHERE ").append(this.condition);
            }
            String select = selectBuf.toString();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Executing statement " + select);
            }
            ResultSet rs = stmt.executeQuery(select);
            rs.next();
            int colType = rs.getMetaData().getColumnType(1);
            switch (colType) {
                case 2004: {
                    Blob blob = rs.getBlob(1);
                    return new JDBCInputStream(blob.getBinaryStream(), cnx);
                }
                case 2005: {
                    Clob clob = rs.getClob(1);
                    return new JDBCInputStream(clob.getAsciiStream(), cnx);
                }
            }
            String value = rs.getString(1);
            stmt.close();
            rs.close();
            cnx.close();
            return new ByteArrayInputStream(value.getBytes());
        }
        catch (SQLException sqle) {
            String msg = "Cannot retrieve content from " + this.systemId;
            this.getLogger().error(msg, (Throwable)sqle);
            try {
                if (cnx != null) {
                    cnx.close();
                }
            }
            catch (SQLException sqle2) {
                throw new SourceException("Cannot close connection", (Throwable)sqle2);
            }
            throw new SourceException(msg, (Throwable)sqle);
        }
    }

    public SourceValidity getValidity() {
        return null;
    }

    public void refresh() {
    }

    public boolean exists() {
        return true;
    }

    public String getMimeType() {
        return null;
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return 0L;
    }

    public String getParameter(String name) {
        return null;
    }

    public long getParameterAsLong(String name) {
        return 0L;
    }

    public Iterator getParameterNames() {
        return new EmptyIterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Connection getConnection() throws SourceException {
        Connection e2;
        ComponentSelector selector = null;
        DataSourceComponent datasource = null;
        try {
            try {
                selector = (ComponentSelector)this.manager.lookup(DataSourceComponent.ROLE + "Selector");
                datasource = (DataSourceComponent)selector.select((Object)this.datasourceName);
            }
            catch (Exception e2) {
                String msg = "Cannot get datasource '" + this.datasourceName + "'";
                this.getLogger().error(msg);
                throw new SourceException(msg, (Throwable)e2);
            }
            try {
                e2 = datasource.getConnection();
                Object var6_8 = null;
                if (datasource == null) return e2;
            }
            catch (Exception e3) {
                String msg = "Cannot get connection for datasource '" + this.datasourceName + "'";
                this.getLogger().error(msg);
                throw new SourceException(msg, (Throwable)e3);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (datasource == null) throw throwable;
            selector.release(datasource);
            throw throwable;
        }
        selector.release((Component)datasource);
        return e2;
    }

    static /* synthetic */ Logger access$001(BlobSource x0) {
        return x0.getLogger();
    }

    private class JDBCInputStream
    extends FilterInputStream {
        Connection cnx;

        private final void closeCnx() throws IOException {
            if (this.cnx != null) {
                try {
                    Connection tmp = this.cnx;
                    this.cnx = null;
                    tmp.close();
                }
                catch (Exception e) {
                    String msg = "Error closing the connection for " + BlobSource.this.getURI();
                    AbstractLogEnabled.access$001((BlobSource)BlobSource.this).warn(msg, (Throwable)e);
                    throw new CascadingIOException(msg + " : " + e.getMessage(), (Throwable)e);
                }
            }
        }

        public JDBCInputStream(InputStream stream, Connection cnx) {
            super(stream);
            this.cnx = cnx;
        }

        public int read() throws IOException {
            try {
                int result = this.in.read();
                if (result == -1) {
                    this.closeCnx();
                }
                return result;
            }
            catch (IOException e) {
                this.closeCnx();
                throw e;
            }
        }

        public int read(byte[] b) throws IOException {
            try {
                int result = this.in.read(b);
                if (result == -1) {
                    this.closeCnx();
                }
                return result;
            }
            catch (IOException e) {
                this.closeCnx();
                throw e;
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int result = this.in.read(b, off, len);
                if (result == -1) {
                    this.closeCnx();
                }
                return result;
            }
            catch (IOException e) {
                this.closeCnx();
                throw e;
            }
        }

        public void close() throws IOException {
            super.close();
            this.closeCnx();
        }
    }

    class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }
}

