/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.DatabaseAddAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.ImageProperties;
import org.apache.cocoon.util.ImageUtils;

public class OraAddAction
extends DatabaseAddAction {
    private static final Map selectLOBStatements = new HashMap();

    /*
     * Loose catch block
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters param) throws Exception {
        block40: {
            int currentIndex;
            Connection conn;
            DataSourceComponent datasource;
            block39: {
                Map map;
                datasource = null;
                conn = null;
                currentIndex = 0;
                Configuration conf = this.getConfiguration(param.getParameter("descriptor", null));
                String query = this.getAddQuery(conf);
                datasource = this.getDataSource(conf);
                conn = datasource.getConnection();
                Request request = ObjectModelHelper.getRequest((Map)objectModel);
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                PreparedStatement statement = conn.prepareStatement(query);
                this.getLogger().info(query);
                Configuration[] keys = conf.getChild("table").getChild("keys").getChildren("key");
                Configuration[] values = conf.getChild("table").getChild("values").getChildren("value");
                currentIndex = 1;
                int i = 0;
                while (i < keys.length) {
                    block38: {
                        String mode = keys[i].getAttribute("mode", "automatic");
                        if ("manual".equals(mode)) {
                            String selectQuery = this.getSelectQuery(keys[i]);
                            Statement stmt = null;
                            ResultSet set = null;
                            try {
                                stmt = conn.createStatement();
                                set = stmt.executeQuery(selectQuery);
                                set.next();
                                int value = set.getInt("maxid") + 1;
                                statement.setInt(currentIndex, value);
                                request.setAttribute(keys[i].getAttribute("param"), (Object)String.valueOf(value));
                                map = null;
                            }
                            catch (Throwable throwable) {
                                map = null;
                                set.close();
                                stmt.close();
                                ++currentIndex;
                                throw throwable;
                            }
                            set.close();
                            stmt.close();
                            ++currentIndex;
                            {
                                break block38;
                                catch (SQLException sqle) {
                                    this.getLogger().warn("There was an error retrieving the next key while inserting on the database", (Throwable)sqle);
                                    throw sqle;
                                }
                            }
                        }
                        if ("form".equals(mode)) {
                            String parameter = keys[i].getAttribute("param");
                            request.setAttribute(parameter, (Object)request.getParameter(parameter));
                            this.setColumn(statement, currentIndex, request, keys[i]);
                            ++currentIndex;
                        }
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < values.length) {
                    String type = values[i2].getAttribute("type");
                    String parameter = values[i2].getAttribute("param");
                    if (type.equals("image")) {
                        File binaryFile = (File)request.get(parameter);
                        Parameters iparam = new Parameters();
                        iparam.setParameter("image-size", String.valueOf(binaryFile.length()));
                        ImageProperties prop = ImageUtils.getImageProperties((File)binaryFile);
                        iparam.setParameter("image-width", Integer.toString(prop.width));
                        iparam.setParameter("image-height", Integer.toString(prop.height));
                        map = this.files;
                        synchronized (map) {
                            this.files.put(binaryFile, param);
                        }
                    }
                    if (!this.isLargeObject(type)) {
                        this.setColumn(statement, currentIndex, request, values[i2]);
                        ++currentIndex;
                    }
                    ++i2;
                }
                statement.execute();
                statement.close();
                query = this.getSelectLOBQuery(conf);
                if (query != null) {
                    OracleResultSet set;
                    PreparedStatement LOBstatement = conn.prepareStatement(query);
                    this.getLogger().info(query);
                    if (keys.length > 0) {
                        currentIndex = 1;
                        int i3 = 0;
                        while (i3 < keys.length) {
                            this.setColumn(LOBstatement, currentIndex, request, keys[i3]);
                            ++currentIndex;
                            ++i3;
                        }
                    }
                    if ((set = (OracleResultSet)LOBstatement.executeQuery()).next()) {
                        int index = 0;
                        int i4 = 0;
                        while (i4 < values.length) {
                            String type = values[i4].getAttribute("type", "");
                            if (this.isLargeObject(type)) {
                                Object attr = request.get(values[i4].getAttribute("param"));
                                int length = -1;
                                BufferedInputStream stream = null;
                                BufferedOutputStream output = null;
                                int bufSize = 1024;
                                ++index;
                                if (type.equals("ascii")) {
                                    CLOB ascii = set.getCLOB(index);
                                    if (attr instanceof File) {
                                        File asciiFile = (File)attr;
                                        stream = new BufferedInputStream(new FileInputStream(asciiFile));
                                    } else {
                                        String asciiText = (String)attr;
                                        stream = new BufferedInputStream(new ByteArrayInputStream(asciiText.getBytes()));
                                    }
                                    output = new BufferedOutputStream(ascii.getAsciiOutputStream());
                                    bufSize = ascii.getBufferSize();
                                } else {
                                    BLOB binary = set.getBLOB(index);
                                    File binaryFile = (File)attr;
                                    stream = new BufferedInputStream(new FileInputStream(binaryFile));
                                    length = (int)binaryFile.length();
                                    output = new BufferedOutputStream(binary.getBinaryOutputStream());
                                    bufSize = binary.getBufferSize();
                                }
                                byte[] buffer = new byte[bufSize];
                                while ((length = ((InputStream)stream).read(buffer)) != -1) {
                                    ((OutputStream)output).write(buffer, 0, length);
                                }
                                ((InputStream)stream).close();
                                ((OutputStream)output).close();
                            }
                            ++i4;
                        }
                    }
                    set.close();
                    set.getStatement().close();
                }
                conn.commit();
                Object var30_40 = null;
                if (conn == null) break block39;
                try {
                    conn.close();
                }
                catch (SQLException sqe) {
                    this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                }
            }
            if (datasource != null) {
                this.dbselector.release((Object)datasource);
            }
            break block40;
            {
                catch (Exception e) {
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException se) {
                            this.getLogger().debug("There was an error rolling back the transaction", (Throwable)se);
                        }
                    }
                    throw new ProcessingException("Could not add record :position = " + (currentIndex - 1), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var30_41 = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sqe) {
                        this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                    }
                }
                if (datasource != null) {
                    this.dbselector.release(datasource);
                }
                throw throwable;
            }
        }
        return null;
    }

    protected final String getAddQuery(Configuration conf) throws ConfigurationException {
        String query = null;
        Map map = DatabaseAddAction.addStatements;
        synchronized (map) {
            query = (String)DatabaseAddAction.addStatements.get(conf);
            if (query == null) {
                Configuration table = conf.getChild("table");
                Configuration[] values = table.getChild("values").getChildren("value");
                Configuration[] keys = table.getChild("keys").getChildren("key");
                StringBuffer queryBuffer = new StringBuffer("INSERT INTO ");
                queryBuffer.append(table.getAttribute("name"));
                queryBuffer.append(" (");
                int numKeys = 0;
                int i = 0;
                while (i < keys.length) {
                    String mode = keys[i].getAttribute("mode", "automatic");
                    if (numKeys > 0) {
                        queryBuffer.append(", ");
                    }
                    queryBuffer.append(keys[i].getAttribute("dbcol"));
                    if ("manual".equals(mode)) {
                        this.setSelectQuery(table.getAttribute("name"), keys[i]);
                    }
                    ++numKeys;
                    ++i;
                }
                int i2 = 0;
                while (i2 < values.length) {
                    if (numKeys + i2 > 0) {
                        queryBuffer.append(", ");
                    }
                    queryBuffer.append(values[i2].getAttribute("dbcol"));
                    ++i2;
                }
                queryBuffer.append(") VALUES (");
                numKeys = 0;
                ArrayList<String> sequences = new ArrayList<String>();
                int i3 = 0;
                while (i3 < keys.length) {
                    if (numKeys > 0) {
                        queryBuffer.append(", ");
                    }
                    if ("automatic".equals(keys[i3].getAttribute("mode", "automatic"))) {
                        String sequence = keys[i3].getAttribute("sequence", "");
                        queryBuffer.append(sequence);
                        if (sequences.contains(sequence)) {
                            queryBuffer.append(".CURRVAL");
                        } else {
                            sequences.add(sequence);
                            queryBuffer.append(".NEXTVAL");
                        }
                        ++numKeys;
                    } else {
                        queryBuffer.append("?");
                        ++numKeys;
                    }
                    ++i3;
                }
                int i4 = 0;
                while (i4 < values.length) {
                    if (numKeys + i4 > 0) {
                        queryBuffer.append(", ");
                    }
                    if (this.isLargeObject(values[i4].getAttribute("type"))) {
                        if (values[i4].getAttribute("type").equals("ascii")) {
                            queryBuffer.append("empty_clob()");
                        } else {
                            queryBuffer.append("empty_blob()");
                        }
                    } else {
                        queryBuffer.append("?");
                    }
                    ++i4;
                }
                queryBuffer.append(")");
                query = queryBuffer.toString();
                DatabaseAddAction.addStatements.put(conf, query);
            }
        }
        if ("".equals(query)) {
            return null;
        }
        return query;
    }

    private final String getSelectLOBQuery(Configuration conf) throws ConfigurationException {
        String query = null;
        Map map = selectLOBStatements;
        synchronized (map) {
            query = (String)selectLOBStatements.get(conf);
            if (query == null) {
                StringBuffer queryBuffer = new StringBuffer("SELECT ");
                Configuration table = conf.getChild("table");
                Configuration[] values = table.getChild("values").getChildren("value");
                Configuration[] keys = table.getChild("keys").getChildren("key");
                int numLobs = 0;
                int i = 0;
                while (i < values.length) {
                    if (this.isLargeObject(values[i].getAttribute("type"))) {
                        if (++numLobs > 1) {
                            queryBuffer.append(", ");
                        }
                        queryBuffer.append(values[i].getAttribute("dbcol"));
                    }
                    ++i;
                }
                if (numLobs < 1) {
                    query = "";
                    selectLOBStatements.put(conf, query);
                    String string = null;
                    return string;
                }
                queryBuffer.append(" FROM ").append(table.getAttribute("name"));
                if (keys.length > 0) {
                    queryBuffer.append(" WHERE ");
                    queryBuffer.append((Object)this.buildList(keys, " AND "));
                }
                query = queryBuffer.toString().trim();
                selectLOBStatements.put(conf, query);
            }
        }
        return "".equals(query) ? null : query;
    }
}

