/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.transformation.helpers.TextRecorder;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SQLTransformer
extends AbstractSAXTransformer
implements Disposable,
Configurable {
    public static final String NAMESPACE = "http://apache.org/cocoon/SQL/2.0";
    public static final String MAGIC_EXECUTE_QUERY = "execute-query";
    private static final String MAGIC_OWN_CONNECTION = "own-connection";
    public static final String MAGIC_CONNECTION = "use-connection";
    public static final String MAGIC_DBURL = "dburl";
    public static final String MAGIC_USERNAME = "username";
    public static final String MAGIC_PASSWORD = "password";
    public static final String MAGIC_NR_OF_ROWS = "show-nr-of-rows";
    public static final String MAGIC_QUERY = "query";
    public static final String MAGIC_VALUE = "value";
    public static final String MAGIC_COLUMN_CASE = "column-case";
    public static final String MAGIC_DOC_ELEMENT = "doc-element";
    public static final String MAGIC_ROW_ELEMENT = "row-element";
    public static final String MAGIC_IN_PARAMETER = "in-parameter";
    public static final String MAGIC_IN_PARAMETER_NR_ATTRIBUTE = "nr";
    public static final String MAGIC_IN_PARAMETER_VALUE_ATTRIBUTE = "value";
    public static final String MAGIC_OUT_PARAMETER = "out-parameter";
    public static final String MAGIC_OUT_PARAMETER_NAME_ATTRIBUTE = "name";
    public static final String MAGIC_OUT_PARAMETER_NR_ATTRIBUTE = "nr";
    public static final String MAGIC_OUT_PARAMETER_TYPE_ATTRIBUTE = "type";
    public static final String MAGIC_ESCAPE_STRING = "escape-string";
    public static final String MAGIC_ERROR = "error";
    public static final String MAGIC_NS_URI_ELEMENT = "namespace-uri";
    public static final String MAGIC_NS_PREFIX_ELEMENT = "namespace-prefix";
    public static final String MAGIC_ANCESTOR_VALUE = "ancestor-value";
    public static final String MAGIC_ANCESTOR_VALUE_LEVEL_ATTRIBUTE = "level";
    public static final String MAGIC_ANCESTOR_VALUE_NAME_ATTRIBUTE = "name";
    public static final String MAGIC_SUBSTITUTE_VALUE = "substitute-value";
    public static final String MAGIC_SUBSTITUTE_VALUE_NAME_ATTRIBUTE = "name";
    public static final String MAGIC_NAME_ATTRIBUTE = "name";
    public static final String MAGIC_STORED_PROCEDURE_ATTRIBUTE = "isstoredprocedure";
    public static final String MAGIC_UPDATE_ATTRIBUTE = "isupdate";
    public static final String CLOB_ENCODING = "clob-encoding";
    protected static final int STATE_OUTSIDE = 0;
    protected static final int STATE_INSIDE_EXECUTE_QUERY_ELEMENT = 1;
    protected static final int STATE_INSIDE_VALUE_ELEMENT = 2;
    protected static final int STATE_INSIDE_QUERY_ELEMENT = 3;
    protected static final int STATE_INSIDE_ANCESTOR_VALUE_ELEMENT = 4;
    protected static final int STATE_INSIDE_SUBSTITUTE_VALUE_ELEMENT = 5;
    protected static final int STATE_INSIDE_IN_PARAMETER_ELEMENT = 6;
    protected static final int STATE_INSIDE_OUT_PARAMETER_ELEMENT = 7;
    protected static final int STATE_INSIDE_ESCAPE_STRING = 8;
    protected boolean oldDriver;
    protected int connectAttempts;
    protected int connectWaittime;
    protected Query query;
    protected int state;
    protected ServiceSelector datasources;
    protected String connName;
    protected Connection conn;
    protected XMLSerializer compiler;
    protected XMLDeserializer interpreter;
    protected SAXParser parser;

    public SQLTransformer() {
        this.defaultNamespaceURI = NAMESPACE;
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        try {
            this.datasources = (ServiceSelector)manager.lookup(DataSourceComponent.ROLE + "Selector");
        }
        catch (ServiceException e) {
            this.getLogger().warn("DataSource component selector is not available.", (Throwable)e);
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.oldDriver = conf.getChild("old-driver").getValueAsBoolean(false);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Value for old-driver is " + this.oldDriver);
        }
        this.connectAttempts = conf.getChild("connect-attempts").getValueAsInteger(5);
        this.connectWaittime = conf.getChild("connect-waittime").getValueAsInteger(5000);
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, source, parameters);
        this.state = 0;
        this.connName = this.name(this.parameters);
    }

    public void recycle() {
        this.query = null;
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            this.getLogger().info("Could not close connection", (Throwable)e);
        }
        this.connName = null;
        this.manager.release((Object)this.parser);
        this.parser = null;
        this.manager.release((Object)this.compiler);
        this.compiler = null;
        this.manager.release((Object)this.interpreter);
        this.interpreter = null;
        super.recycle();
    }

    public void dispose() {
        if (this.datasources != null) {
            this.manager.release((Object)this.datasources);
            this.datasources = null;
        }
        super.dispose();
    }

    private String getAttributeValue(Attributes attr, String name) {
        String value = attr.getValue("", name);
        if (value == null) {
            value = attr.getValue(this.namespaceURI, name);
        }
        return value;
    }

    protected static void throwIllegalStateException(String message) {
        throw new IllegalStateException("Illegal state: " + message);
    }

    protected void startExecuteQueryElement() {
        switch (this.state) {
            case 0: 
            case 1: {
                this.query = new Query(this.query);
                this.query.enableLogging(this.getLogger().getChildLogger(MAGIC_QUERY));
                this.state = 1;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start execute query element");
            }
        }
    }

    protected void startValueElement(String name) throws SAXException {
        switch (this.state) {
            case 1: {
                this.stack.push(name);
                this.startTextRecording();
                this.state = 2;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start value element: " + name);
            }
        }
    }

    protected void startQueryElement(Attributes attributes) throws SAXException {
        switch (this.state) {
            case 1: {
                String name;
                String isProcedure;
                this.startTextRecording();
                this.state = 3;
                String isUpdate = attributes.getValue("", MAGIC_UPDATE_ATTRIBUTE);
                if (isUpdate != null && !isUpdate.equalsIgnoreCase("false")) {
                    this.query.setUpdate(true);
                }
                if ((isProcedure = attributes.getValue("", MAGIC_STORED_PROCEDURE_ATTRIBUTE)) != null && !isProcedure.equalsIgnoreCase("false")) {
                    this.query.setStoredProcedure(true);
                }
                if ((name = attributes.getValue("", "name")) == null) break;
                this.query.setName(name);
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start query element");
            }
        }
    }

    protected void endQueryElement() throws ProcessingException, SAXException {
        switch (this.state) {
            case 3: {
                String value = this.endTextRecording();
                if (value.length() > 0) {
                    this.query.addQueryPart(value);
                }
                this.state = 1;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a stop query element");
            }
        }
    }

    protected void endValueElement() throws SAXException {
        switch (this.state) {
            case 2: {
                String name = (String)this.stack.pop();
                String value = this.endTextRecording();
                this.query.setParameter(name, value);
                this.state = 1;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting an end value element");
            }
        }
    }

    protected void endExecuteQueryElement() throws SAXException {
        switch (this.state) {
            case 1: {
                if (this.query.parent == null) {
                    this.query.executeQuery();
                    this.query = null;
                    this.state = 0;
                    break;
                }
                this.query.parent.addNestedQuery(this.query);
                this.query = this.query.parent;
                this.state = 1;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting an end execute query element");
            }
        }
    }

    protected void startAncestorValueElement(Attributes attributes) throws ProcessingException, SAXException {
        switch (this.state) {
            case 3: {
                String value;
                int level = 0;
                try {
                    level = Integer.parseInt(this.getAttributeValue(attributes, MAGIC_ANCESTOR_VALUE_LEVEL_ATTRIBUTE));
                }
                catch (Exception e) {
                    this.getLogger().debug("Invalid or missing value for level attribute", (Throwable)e);
                    SQLTransformer.throwIllegalStateException("Ancestor value elements must have a level attribute");
                }
                String name = this.getAttributeValue(attributes, "name");
                if (name == null) {
                    SQLTransformer.throwIllegalStateException("Ancestor value elements must have a name attribute");
                }
                if ((value = this.endTextRecording()).length() > 0) {
                    this.query.addQueryPart(value);
                }
                this.query.addQueryPart(new AncestorValue(level, name));
                this.startTextRecording();
                this.state = 4;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start ancestor value element");
            }
        }
    }

    protected void endAncestorValueElement() {
        this.state = 3;
    }

    protected void startSubstituteValueElement(Attributes attributes) throws ProcessingException, SAXException {
        switch (this.state) {
            case 3: {
                String name = this.getAttributeValue(attributes, "name");
                if (name == null) {
                    SQLTransformer.throwIllegalStateException("Substitute value elements must have a name attribute");
                }
                String substitute = this.parameters.getParameter(name, null);
                substitute = StringEscapeUtils.escapeSql((String)substitute);
                String value = this.endTextRecording();
                if (value.length() > 0) {
                    this.query.addQueryPart(value);
                }
                this.query.addQueryPart(substitute);
                this.startTextRecording();
                this.state = 5;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start substitute value element");
            }
        }
    }

    protected void endSubstituteValueElement() {
        this.state = 3;
    }

    protected void startEscapeStringElement(Attributes attributes) throws ProcessingException, SAXException {
        switch (this.state) {
            case 3: {
                String value = this.endTextRecording();
                if (value.length() > 0) {
                    this.query.addQueryPart(value);
                }
                this.startTextRecording();
                this.state = 8;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start escape-string element");
            }
        }
    }

    protected void endEscapeStringElement() throws SAXException {
        switch (this.state) {
            case 8: {
                String value = this.endTextRecording();
                if (value.length() > 0) {
                    value = StringEscapeUtils.escapeSql((String)value);
                    value = StringUtils.replace((String)value, (String)"\\", (String)"\\\\");
                    this.query.addQueryPart(value);
                }
                this.startTextRecording();
                this.state = 3;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a end escape-string element");
            }
        }
    }

    protected void startInParameterElement(Attributes attributes) {
        switch (this.state) {
            case 1: {
                String nr = this.getAttributeValue(attributes, "nr");
                String value = this.getAttributeValue(attributes, "value");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("IN PARAMETER NR " + nr + "; VALUE " + value);
                }
                int position = Integer.parseInt(nr);
                this.query.setInParameter(position, value);
                this.state = 6;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting an in-parameter element");
            }
        }
    }

    protected void endInParameterElement() {
        this.state = 1;
    }

    protected void startOutParameterElement(Attributes attributes) {
        switch (this.state) {
            case 1: {
                String name = this.getAttributeValue(attributes, "name");
                String nr = this.getAttributeValue(attributes, "nr");
                String type = this.getAttributeValue(attributes, MAGIC_OUT_PARAMETER_TYPE_ATTRIBUTE);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("OUT PARAMETER NAME" + name + ";NR " + nr + "; TYPE " + type);
                }
                int position = Integer.parseInt(nr);
                this.query.setOutParameter(position, type, name);
                this.state = 7;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting an out-parameter element");
            }
        }
    }

    protected void endOutParameterElement() {
        this.state = 1;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attributes) throws ProcessingException, SAXException {
        if (name.equals(MAGIC_EXECUTE_QUERY)) {
            this.startExecuteQueryElement();
        } else if (name.equals(MAGIC_QUERY)) {
            this.startQueryElement(attributes);
        } else if (name.equals(MAGIC_ANCESTOR_VALUE)) {
            this.startAncestorValueElement(attributes);
        } else if (name.equals(MAGIC_SUBSTITUTE_VALUE)) {
            this.startSubstituteValueElement(attributes);
        } else if (name.equals(MAGIC_IN_PARAMETER)) {
            this.startInParameterElement(attributes);
        } else if (name.equals(MAGIC_OUT_PARAMETER)) {
            this.startOutParameterElement(attributes);
        } else if (name.equals(MAGIC_ESCAPE_STRING)) {
            this.startEscapeStringElement(attributes);
        } else {
            this.startValueElement(name);
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws ProcessingException, IOException, SAXException {
        if (name.equals(MAGIC_EXECUTE_QUERY)) {
            this.endExecuteQueryElement();
        } else if (name.equals(MAGIC_QUERY)) {
            this.endQueryElement();
        } else if (name.equals(MAGIC_ANCESTOR_VALUE)) {
            this.endAncestorValueElement();
        } else if (name.equals(MAGIC_SUBSTITUTE_VALUE)) {
            this.endSubstituteValueElement();
        } else if (name.equals(MAGIC_IN_PARAMETER)) {
            this.endInParameterElement();
        } else if (name.equals(MAGIC_OUT_PARAMETER)) {
            this.endOutParameterElement();
        } else if (name.equals(MAGIC_ESCAPE_STRING)) {
            this.endEscapeStringElement();
        } else {
            this.endValueElement();
        }
    }

    protected String nsQualify(String name, String prefix) {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        if (StringUtils.isNotEmpty((String)prefix)) {
            return prefix + ":" + name;
        }
        return name;
    }

    protected void start(String uri, String prefix, String name, Attributes attr) throws SAXException {
        try {
            super.startTransformingElement(uri, name, this.nsQualify(name, prefix), attr);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (ProcessingException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    protected void end(String uri, String prefix, String name) throws SAXException {
        try {
            super.endTransformingElement(uri, name, this.nsQualify(name, prefix));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (ProcessingException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    protected void data(String data) throws SAXException {
        if (data != null) {
            super.characters(data.toCharArray(), 0, data.length());
        }
    }

    private String name(Parameters params) {
        boolean ownConnection = params.getParameterAsBoolean(MAGIC_OWN_CONNECTION, false);
        if (ownConnection) {
            return null;
        }
        String datasourceName = params.getParameter(MAGIC_CONNECTION, null);
        if (datasourceName != null) {
            return "ds:" + datasourceName;
        }
        String dburl = params.getParameter(MAGIC_DBURL, null);
        if (dburl != null) {
            String username = params.getParameter(MAGIC_USERNAME, null);
            String password = params.getParameter(MAGIC_PASSWORD, null);
            if (username == null || password == null) {
                return "db:@" + dburl;
            }
            return "db:" + username + ":" + password + "@" + dburl;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Connection open(Parameters params) throws SQLException {
        Connection result = null;
        String datasourceName = params.getParameter(MAGIC_CONNECTION, null);
        if (datasourceName != null) {
            block14: {
                if (this.datasources == null) {
                    throw new SQLException("Unable to get connection from datasource '" + datasourceName + "': " + "No datasources configured in cocoon.xconf.");
                }
                DataSourceComponent datasource = null;
                try {
                    try {
                        datasource = (DataSourceComponent)this.datasources.select((Object)datasourceName);
                        int i = 0;
                        while (i < this.connectAttempts && result == null) {
                            block13: {
                                try {
                                    result = datasource.getConnection();
                                }
                                catch (SQLException e) {
                                    if (i + 1 >= this.connectAttempts) break block13;
                                    long waittime = this.connectWaittime;
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().info("Unable to get connection; waiting " + waittime + "ms to try again.", (Throwable)e);
                                    } else {
                                        this.getLogger().info("Unable to get connection; waiting " + waittime + "ms to try again.");
                                    }
                                    try {
                                        Thread.sleep(waittime);
                                    }
                                    catch (InterruptedException ex) {
                                        // empty catch block
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    catch (ServiceException e) {
                        throw new SQLException("Unable to get connection from datasource '" + datasourceName + "': " + "No such datasource.");
                    }
                    Object var11_13 = null;
                    if (datasource == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (datasource == null) throw throwable;
                    this.datasources.release((Object)datasource);
                    throw throwable;
                }
                this.datasources.release((Object)datasource);
            }
            if (result != null) return result;
            throw new SQLException("Failed to obtain connection from datasource '" + datasourceName + "'. " + "Made " + this.connectAttempts + " attempts with " + this.connectWaittime + "ms interval");
        }
        String dburl = params.getParameter(MAGIC_DBURL, null);
        if (dburl == null) return result;
        String username = params.getParameter(MAGIC_USERNAME, null);
        String password = params.getParameter(MAGIC_PASSWORD, null);
        if (username == null) return DriverManager.getConnection(dburl);
        if (password == null) return DriverManager.getConnection(dburl);
        return DriverManager.getConnection(dburl, username, password);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stream(String value) throws ServiceException, SAXException, IOException {
        try {
            if (value.startsWith("<?xml ")) {
                value = value.substring(value.indexOf("?>") + 2);
            }
            if (this.parser == null) {
                this.parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
            }
            if (this.compiler == null) {
                this.compiler = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
            }
            if (this.interpreter == null) {
                this.interpreter = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
            }
            this.parser.parse(new InputSource(new StringReader("<root>" + value + "</root>")), (ContentHandler)this.compiler);
            IncludeXMLConsumer filter = new IncludeXMLConsumer((ContentHandler)((Object)this), (LexicalHandler)((Object)this));
            filter.setIgnoreRootElement(true);
            this.interpreter.setConsumer((XMLConsumer)filter);
            this.interpreter.deserialize(this.compiler.getSAXFragment());
            Object var4_3 = null;
            if (this.compiler == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.compiler == null) throw throwable;
            this.manager.release((Object)this.compiler);
            this.compiler = null;
            throw throwable;
        }
        this.manager.release((Object)this.compiler);
        this.compiler = null;
    }

    public String endTextRecording() throws SAXException {
        this.sendEndPrefixMapping();
        TextRecorder recorder = (TextRecorder)this.removeRecorder();
        String text = recorder.getAllText();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("End text recording. Text=" + text);
        }
        return text;
    }

    private static class AncestorValue {
        protected int level;
        protected String name;

        protected AncestorValue(int level, String name) {
            this.level = level;
            this.name = name;
        }

        public String toString() {
            return "<ancestor level " + this.level + ", name " + this.name + ">";
        }
    }

    private class Query
    extends AbstractLogEnabled {
        protected Query parent;
        protected final List nested = new ArrayList();
        protected final List parts = new ArrayList();
        protected String name;
        protected boolean isUpdate;
        protected boolean isStoredProcedure;
        protected Parameters params;
        protected String outUri;
        protected String outPrefix;
        protected String rowsetElement;
        protected String rowElement;
        protected String nrOfRowsAttr = "nrofrows";
        protected String nameAttr = "name";
        protected int columnCase;
        protected HashMap inParameters;
        protected HashMap outParameters;
        protected HashMap outParametersNames;
        protected boolean showNrOfRows;
        protected String clobEncoding;
        protected Connection conn;
        protected String connName;
        protected boolean ownConn;
        protected PreparedStatement pst;
        protected CallableStatement cst;
        protected ResultSet rs;
        protected ResultSetMetaData md;
        protected int rv = -1;

        protected Query(Query parent) {
            this.parent = parent;
            this.params = new Parameters();
            this.params.merge(SQLTransformer.this.parameters);
        }

        protected void addNestedQuery(Query query) {
            this.nested.add(query);
        }

        protected void addQueryPart(Object value) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding query part \"" + value + "\"");
            }
            this.parts.add(value);
        }

        protected String getName() {
            return this.name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        protected void setParameter(String name, String value) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding parameter name {" + name + "} value {" + value + "}");
            }
            this.params.setParameter(name, value);
        }

        protected void setUpdate(boolean flag) {
            this.isUpdate = flag;
        }

        protected void setStoredProcedure(boolean flag) {
            this.isStoredProcedure = flag;
        }

        protected void setInParameter(int pos, String val) {
            if (this.inParameters == null) {
                this.inParameters = new HashMap();
            }
            this.inParameters.put(new Integer(pos), val);
        }

        protected void setOutParameter(int pos, String type, String name) {
            if (this.outParameters == null) {
                this.outParameters = new HashMap();
                this.outParametersNames = new HashMap();
            }
            this.outParameters.put(new Integer(pos), type);
            this.outParametersNames.put(new Integer(pos), name);
        }

        private void setColumnCase(String columnCase) {
            if (columnCase.equals("lowercase")) {
                this.columnCase = -1;
            } else if (columnCase.equals("uppercase")) {
                this.columnCase = 1;
            } else if (columnCase.equals("preserve")) {
                this.columnCase = 0;
            } else {
                this.getLogger().warn("[" + columnCase + "] is not a valid value for <column-case>. " + "Column name retrieved from database will be used.");
            }
        }

        private void registerInParameters() throws SQLException {
            if (this.inParameters == null) {
                return;
            }
            Iterator i = this.inParameters.keySet().iterator();
            while (i.hasNext()) {
                Integer counter = (Integer)i.next();
                String value = (String)this.inParameters.get(counter);
                try {
                    this.pst.setObject(counter, value);
                }
                catch (SQLException e) {
                    this.getLogger().error("Caught a SQLException", (Throwable)e);
                    throw e;
                }
            }
        }

        private void registerOutParameters(CallableStatement cst) throws SQLException {
            if (this.outParameters == null) {
                return;
            }
            Iterator i = this.outParameters.keySet().iterator();
            while (i.hasNext()) {
                Integer counter = (Integer)i.next();
                String type = (String)this.outParameters.get(counter);
                int index = type.lastIndexOf(".");
                if (index <= -1) {
                    this.getLogger().error("Invalid SQLType: " + type, null);
                    throw new SQLException("Invalid SQLType: " + type);
                }
                String className = type.substring(0, index);
                String fieldName = type.substring(index + 1, type.length());
                try {
                    Class<?> clss = Class.forName(className);
                    Field fld = clss.getField(fieldName);
                    cst.registerOutParameter((int)counter, fld.getInt(fieldName));
                }
                catch (Exception e) {
                    this.getLogger().error("Invalid SQLType: " + className + "." + fieldName, (Throwable)e);
                }
            }
        }

        private void open() throws SQLException {
            this.connName = SQLTransformer.this.name(this.params);
            if (this.connName == null) {
                this.conn = SQLTransformer.this.open(this.params);
                this.ownConn = true;
                return;
            }
            Query query = this.parent;
            while (query != null) {
                if (this.connName.equals(query.connName)) {
                    this.conn = query.conn;
                    this.ownConn = false;
                    return;
                }
                query = query.parent;
            }
            if (this.connName.equals(SQLTransformer.this.connName)) {
                if (SQLTransformer.this.conn == null) {
                    SQLTransformer.this.conn = SQLTransformer.this.open(SQLTransformer.this.parameters);
                }
                this.conn = SQLTransformer.this.conn;
                this.ownConn = false;
                return;
            }
            this.conn = SQLTransformer.this.open(this.params);
            this.ownConn = true;
        }

        protected void executeQuery() throws SAXException {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Executing query " + (Object)((Object)this));
            }
            this.outUri = this.params.getParameter(SQLTransformer.MAGIC_NS_URI_ELEMENT, SQLTransformer.this.namespaceURI);
            this.outPrefix = this.params.getParameter(SQLTransformer.MAGIC_NS_PREFIX_ELEMENT, "sql");
            this.showNrOfRows = SQLTransformer.this.parameters.getParameterAsBoolean(SQLTransformer.MAGIC_NR_OF_ROWS, false);
            this.clobEncoding = SQLTransformer.this.parameters.getParameter(SQLTransformer.CLOB_ENCODING, "");
            String prefix = SQLTransformer.this.findPrefixMapping(this.outUri);
            if (prefix == null) {
                SQLTransformer.this.startPrefixMapping(this.outPrefix, this.outUri);
            } else {
                this.outPrefix = prefix;
            }
            boolean success = false;
            try {
                block15: {
                    try {
                        String name;
                        try {
                            this.open();
                            this.execute();
                            success = true;
                        }
                        catch (SQLException e) {
                            this.getLogger().info("Failed to execute query " + (Object)((Object)this), (Throwable)e);
                            this.start(this.rowsetElement, AbstractSAXTransformer.EMPTY_ATTRIBUTES);
                            this.start(SQLTransformer.MAGIC_ERROR, AbstractSAXTransformer.EMPTY_ATTRIBUTES);
                            this.data(e.getMessage());
                            this.end(SQLTransformer.MAGIC_ERROR);
                            this.end(this.rowsetElement);
                        }
                        if (!success) break block15;
                        AttributesImpl attr = new AttributesImpl();
                        if (this.showNrOfRows) {
                            attr.addAttribute("", this.nrOfRowsAttr, this.nrOfRowsAttr, "CDATA", String.valueOf(this.getNrOfRows()));
                        }
                        if ((name = this.getName()) != null) {
                            attr.addAttribute("", this.nameAttr, this.nameAttr, "CDATA", name);
                        }
                        this.start(this.rowsetElement, attr);
                        if (this.isStoredProcedure) {
                            this.serializeStoredProcedure();
                        }
                        while (this.next()) {
                            this.start(this.rowElement, AbstractSAXTransformer.EMPTY_ATTRIBUTES);
                            this.serializeRow();
                            Iterator i = this.nested.iterator();
                            while (i.hasNext()) {
                                ((Query)((Object)i.next())).executeQuery();
                            }
                            this.end(this.rowElement);
                        }
                        this.end(this.rowsetElement);
                    }
                    catch (SQLException e) {
                        this.getLogger().debug("Exception in executeQuery()", (Throwable)e);
                        throw new SAXException(e);
                    }
                }
                Object var7_8 = null;
                this.close();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.close();
                throw throwable;
            }
            if (prefix == null) {
                SQLTransformer.this.endPrefixMapping(this.outPrefix);
            }
        }

        private void execute() throws SQLException {
            this.rowsetElement = this.params.getParameter(SQLTransformer.MAGIC_DOC_ELEMENT, "rowset");
            this.rowElement = this.params.getParameter(SQLTransformer.MAGIC_ROW_ELEMENT, "row");
            this.setColumnCase(this.params.getParameter(SQLTransformer.MAGIC_COLUMN_CASE, "lowercase"));
            StringBuffer sb = new StringBuffer();
            Iterator i = this.parts.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                if (object instanceof String) {
                    sb.append((String)object);
                    continue;
                }
                if (!(object instanceof AncestorValue)) continue;
                AncestorValue av = (AncestorValue)object;
                Query query = this;
                int k = av.level;
                while (k > 0) {
                    query = query.parent;
                    --k;
                }
                sb.append(query.getColumnValue(av.name));
            }
            String query = StringUtils.replace((String)sb.toString().trim(), (String)"\r", (String)" ", (int)-1);
            if (!(this.isStoredProcedure || this.isUpdate || query.length() <= 6 || query.substring(0, 6).equalsIgnoreCase("SELECT"))) {
                this.isUpdate = true;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Executing " + query);
            }
            if (!this.isStoredProcedure) {
                this.pst = SQLTransformer.this.oldDriver ? this.conn.prepareStatement(query) : this.conn.prepareStatement(query, 1004, 1007);
            } else {
                this.cst = SQLTransformer.this.oldDriver ? this.conn.prepareCall(query) : this.conn.prepareCall(query, 1004, 1007);
                this.registerOutParameters(this.cst);
                this.pst = this.cst;
            }
            this.registerInParameters();
            boolean result = this.pst.execute();
            if (result) {
                this.rs = this.pst.getResultSet();
                this.md = this.rs.getMetaData();
            } else {
                this.rv = this.pst.getUpdateCount();
            }
        }

        protected int getNrOfRows() throws SQLException {
            int nr = 0;
            if (this.rs != null) {
                if (SQLTransformer.this.oldDriver) {
                    nr = -1;
                } else {
                    try {
                        this.rs.last();
                        nr = this.rs.getRow();
                        this.rs.beforeFirst();
                    }
                    catch (NullPointerException e) {
                        this.getLogger().error("NPE while getting the nr of rows", (Throwable)e);
                    }
                }
            } else if (this.outParameters != null) {
                nr = this.outParameters.size();
            }
            return nr;
        }

        protected String getColumnValue(int i) throws SQLException {
            String retval;
            int numberOfChar = 1024;
            if (this.rs.getMetaData().getColumnType(i) == 8) {
                retval = this.getStringValue(this.rs.getBigDecimal(i));
            } else if (this.rs.getMetaData().getColumnType(i) == 2005) {
                Clob clob = this.rs.getClob(i);
                InputStream inputStream = clob.getAsciiStream();
                byte[] readByte = new byte[numberOfChar];
                StringBuffer buffer = new StringBuffer();
                try {
                    while (inputStream.read(readByte) > -1) {
                        String string = new String(readByte, this.clobEncoding);
                        buffer.append(string);
                    }
                }
                catch (IOException e) {
                    throw new SQLException("Error reading stream from CLOB");
                }
                retval = buffer.toString();
            } else {
                retval = this.getStringValue(this.rs.getObject(i));
            }
            return retval;
        }

        protected String getColumnValue(String name) throws SQLException {
            String retval = this.getStringValue(this.rs.getObject(name));
            return retval;
        }

        protected boolean next() throws SQLException {
            if (this.rv != -1) {
                return true;
            }
            return this.rs != null && this.rs.next();
        }

        protected void close() {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException e) {
                    this.getLogger().info("Unable to close the result set.", (Throwable)e);
                }
                this.rs = null;
            }
            if (this.pst != null && this.pst != this.cst) {
                try {
                    this.pst.close();
                }
                catch (SQLException e) {
                    this.getLogger().info("Unable to close the statement.", (Throwable)e);
                }
            }
            this.pst = null;
            if (this.cst != null) {
                try {
                    this.cst.close();
                }
                catch (SQLException e) {
                    this.getLogger().info("Unable to close the statement.", (Throwable)e);
                }
                this.cst = null;
            }
            try {
                if (this.ownConn && this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException e) {
                this.getLogger().info("Unable to close the connection", (Throwable)e);
            }
            this.conn = null;
        }

        protected void serializeData(String value) throws SQLException, SAXException {
            if (value != null) {
                if ((value = value.trim()).length() > 0 && value.charAt(0) == '<') {
                    try {
                        SQLTransformer.this.stream(value);
                    }
                    catch (Exception ignored) {
                        this.data(value);
                    }
                } else {
                    this.data(value);
                }
            }
        }

        protected void serializeRow() throws SQLException, SAXException {
            if (this.rv != -1) {
                this.start("returncode", AbstractSAXTransformer.EMPTY_ATTRIBUTES);
                this.serializeData(String.valueOf(this.rv));
                this.end("returncode");
                this.rv = -1;
            } else {
                int i = 1;
                while (i <= this.md.getColumnCount()) {
                    String columnName = this.getColumnName(this.md.getColumnName(i));
                    this.start(columnName, AbstractSAXTransformer.EMPTY_ATTRIBUTES);
                    this.serializeData(this.getColumnValue(i));
                    this.end(columnName);
                    ++i;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void serializeStoredProcedure() throws SQLException, SAXException {
            if (this.outParametersNames == null) return;
            if (this.cst == null) {
                return;
            }
            Iterator itOutKeys = new TreeMap(this.outParameters).keySet().iterator();
            while (itOutKeys.hasNext()) {
                Integer counter = (Integer)itOutKeys.next();
                try {
                    Object obj = this.cst.getObject(counter);
                    String name = (String)this.outParametersNames.get(counter);
                    this.start(name, AbstractSAXTransformer.EMPTY_ATTRIBUTES);
                    if (!(obj instanceof ResultSet)) {
                        this.serializeData(this.getStringValue(obj));
                    } else {
                        SQLException e2222;
                        Object var10_10;
                        ResultSet rs = (ResultSet)obj;
                        try {
                            ResultSetMetaData md = rs.getMetaData();
                            block8: while (true) {
                                if (!rs.next()) {
                                    var10_10 = null;
                                    break;
                                }
                                this.start(this.rowElement, AbstractSAXTransformer.EMPTY_ATTRIBUTES);
                                int i = 1;
                                while (true) {
                                    if (i > md.getColumnCount()) {
                                        this.end(this.rowElement);
                                        continue block8;
                                    }
                                    String columnName = this.getColumnName(md.getColumnName(i));
                                    this.start(columnName, AbstractSAXTransformer.EMPTY_ATTRIBUTES);
                                    if (md.getColumnType(i) == 8) {
                                        this.serializeData(this.getStringValue(rs.getBigDecimal(i)));
                                    } else {
                                        this.serializeData(this.getStringValue(rs.getObject(i)));
                                    }
                                    this.end(columnName);
                                    ++i;
                                }
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            var10_10 = null;
                            try {
                                rs.close();
                                throw throwable;
                            }
                            catch (SQLException e2222) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {}
                        catch (SQLException e2222) {}
                        rs.close();
                    }
                    this.end(name);
                }
                catch (SQLException e) {
                    this.getLogger().error("Caught a SQLException", (Throwable)e);
                    throw e;
                }
            }
            return;
        }

        private String getColumnName(String columnName) {
            switch (this.columnCase) {
                case -1: {
                    columnName = columnName.toLowerCase();
                    break;
                }
                case 1: {
                    columnName = columnName.toUpperCase();
                    break;
                }
            }
            return columnName;
        }

        private String getStringValue(Object object) {
            if (object instanceof byte[]) {
                return new String((byte[])object);
            }
            if (object instanceof char[]) {
                return new String((char[])object);
            }
            if (object != null) {
                return object.toString();
            }
            return "";
        }

        private void start(String name, Attributes attr) throws SAXException {
            SQLTransformer.this.start(this.outUri, this.outPrefix, name, attr);
        }

        private void end(String name) throws SAXException {
            SQLTransformer.this.end(this.outUri, this.outPrefix, name);
        }

        private void data(String data) throws SAXException {
            SQLTransformer.this.data(data);
        }
    }
}

