/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.components.deli.Deli;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.transformation.TraxTransformer;
import org.w3c.dom.Document;

public class DeliTransformer
extends TraxTransformer {
    private Deli deli;

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        this.deli = (Deli)this.manager.lookup(Deli.ROLE);
    }

    protected Map getLogicSheetParameters() {
        HashMap<String, Object> map = super.getLogicSheetParameters();
        if (this.deli != null) {
            try {
                Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
                if (map == null) {
                    map = new HashMap<String, Object>();
                }
                Document deliCapabilities = this.deli.getUACapabilities(request);
                map.put("deli-capabilities", deliCapabilities);
                String accept = request.getParameter("accept");
                if (accept == null) {
                    accept = request.getHeader("accept");
                }
                map.put("accept", accept);
            }
            catch (Exception e) {
                this.getLogger().error("Error setting DELI info", (Throwable)e);
            }
        }
        this.logicSheetParameters = map;
        return this.logicSheetParameters;
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.deli);
            this.deli = null;
        }
        super.dispose();
    }
}

