/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.hsqldb;

import java.io.File;
import java.io.IOException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.hsqldb.Server;
import org.apache.cocoon.components.thread.RunnableManager;
import org.apache.cocoon.environment.Context;

public class ServerImpl
extends AbstractLogEnabled
implements Server,
Parameterizable,
Contextualizable,
ThreadSafe,
Runnable,
Serviceable,
Startable {
    private static final boolean DEFAULT_TRACE = false;
    private static final boolean DEFAULT_SILENT = true;
    private static final int DEFAULT_PORT = 9002;
    private static final String CONTEXT_PROTOCOL = "context:/";
    private static final String DEFAULT_DB_NAME = "cocoondb";
    private static final String DEFAULT_DB_PATH = "context://WEB-INF/db";
    private Context cocoonContext;
    private org.hsqldb.Server hsqlServer = new org.hsqldb.Server();
    private String m_daemonThreadPoolName = "daemon";
    private ServiceManager m_serviceManager;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this.cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.hsqlServer.setLogWriter(null);
        this.hsqlServer.setErrWriter(null);
        this.hsqlServer.setPort(params.getParameterAsInteger("port", 9002));
        this.hsqlServer.setSilent(params.getParameterAsBoolean("silent", true));
        this.hsqlServer.setTrace(params.getParameterAsBoolean("trace", false));
        this.hsqlServer.setNoSystemExit(true);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configure HSQLDB with port: " + this.hsqlServer.getPort() + ", silent: " + this.hsqlServer.isSilent() + ", trace: " + this.hsqlServer.isTrace());
        }
        this.m_daemonThreadPoolName = params.getParameter("thread-pool-name", this.m_daemonThreadPoolName);
        String dbCfgPath = params.getParameter("path", DEFAULT_DB_PATH);
        String dbPath = dbCfgPath;
        if (dbPath.startsWith(CONTEXT_PROTOCOL)) {
            dbPath = this.cocoonContext.getRealPath(dbPath.substring(CONTEXT_PROTOCOL.length()));
        }
        if (dbPath == null) {
            throw new ParameterException("The hsqldb cannot be used inside an unexpanded WAR file. Real path for <" + dbCfgPath + "> is null.");
        }
        String dbName = params.getParameter("name", DEFAULT_DB_NAME);
        try {
            this.hsqlServer.setDatabasePath(0, new File(dbPath).getCanonicalPath() + File.separator + dbName);
        }
        catch (IOException e) {
            throw new ParameterException("Could not get database directory <" + dbPath + ">", (Throwable)e);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Database path is <" + this.hsqlServer.getDatabasePath(0, true) + ">");
        }
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        RunnableManager runnableManager = null;
        try {
            try {
                runnableManager = (RunnableManager)this.m_serviceManager.lookup(RunnableManager.ROLE);
                runnableManager.execute(this.m_daemonThreadPoolName, (Runnable)this);
            }
            catch (ServiceException e) {
                throw new CascadingRuntimeException("Cannot get RunnableManager", (Throwable)e);
            }
            Object var4_2 = null;
            if (null == runnableManager) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (null == runnableManager) throw throwable;
            this.m_serviceManager.release((Object)runnableManager);
            throw throwable;
        }
        this.m_serviceManager.release((Object)runnableManager);
    }

    public void stop() {
        this.getLogger().debug("Shutting down HSQLDB");
        this.hsqlServer.stop();
        this.getLogger().debug("Shutting down HSQLDB: Done");
    }

    public void run() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting " + this.hsqlServer.getProductName() + " " + this.hsqlServer.getProductVersion() + " with parameters:");
        }
        this.hsqlServer.start();
    }
}

