/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.java;

import java.util.HashMap;
import org.apache.cocoon.components.flow.java.ContinuationStack;

public class Continuation {
    private ContinuationStack stack;
    private Object context;
    private static HashMap continuationsmap = new HashMap();
    public boolean restoring = false;
    public boolean capturing = false;

    public Continuation(Object context) {
        this.stack = new ContinuationStack();
        this.context = context;
    }

    public Continuation(Continuation parent, Object context) {
        if (parent == null) {
            throw new NullPointerException("Parent continuation is null");
        }
        this.stack = new ContinuationStack(parent.stack);
        this.context = context;
        this.restoring = true;
    }

    public ContinuationStack getStack() {
        return this.stack;
    }

    public Object getContext() {
        return this.context;
    }

    public static void suspend() {
        Continuation continuation = Continuation.currentContinuation();
        if (continuation == null) {
            throw new IllegalStateException("No continuation is running");
        }
        continuation.capturing = !continuation.restoring;
        continuation.restoring = false;
    }

    public boolean isRestoring() {
        return this.restoring;
    }

    public boolean isCapturing() {
        return this.capturing;
    }

    public void registerThread() {
        HashMap hashMap = continuationsmap;
        synchronized (hashMap) {
            continuationsmap.put(Thread.currentThread(), this);
        }
    }

    public void deregisterThread() {
        HashMap hashMap = continuationsmap;
        synchronized (hashMap) {
            continuationsmap.remove(Thread.currentThread());
        }
    }

    public static Continuation currentContinuation() {
        HashMap hashMap = continuationsmap;
        synchronized (hashMap) {
            Thread t = Thread.currentThread();
            Continuation continuation = (Continuation)continuationsmap.get(t);
            return continuation;
        }
    }
}

